jQuery(document).ready(function ($) {

    $("input[name^='fecha']").removeClass('hasDatepicker').datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        minDate: 0
    });

    $("input[name^='fecha']").mask("99-99-9999");
    $("input[name^='fecha']").attr('placeholder', "dd-mm-yyyy");

    $("#vehiculo, #destino, #encargado, #acompaniante, #estado, #medio").select2();
    $("#contacto").mask("9999-9999")

    $("#destino").find("option[value='0']").remove();

    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;

    // //------------- Time entry (picker) -------------//
    // $('#hora').timeEntry({
    //   show24Hours: true,
    //   spinnerImage: ''
    // });

    $("#encargado").on('click', function () {
        $.ajax({
            dataType: 'json',
            type: 'POST',
            data: {emp_id: $(this).val()},
            url: urlj + 'transporte/procesos/cargar_acompaniante',
            success: function (data) {
                $("#acompaniante").html(data.drop);
                $("#acompaniante").select2("val", ""); // Limpia el select, como nuevo.
            }
        })
    });

    $("#acompaniante option").each(function () {
        if ($(this).val() == $("#encargado option:selected").val())
            $(this).remove();

    });

    $("#crear").hover(function (event) {
        $("#tipo_btn").val(1);
    });

    $("#crear_volver").hover(function (event) {
        $("#tipo_btn").val(2);
    });

    $("#crear, #crear_volver").click(function (event) {
        event.preventDefault();

        setTimeout(function () {
            verificarValidacion();
        }, 300);
        $("#frm-solicitud").submit();
    });

    $("#pasar-pestaña1").on('click', function (event) {
        event.preventDefault();
        $("#pes-anexo").trigger('click');
    });

    $("#regreso1").on('click', function (event) {
        event.preventDefault();
        $("#pes-solicitud").trigger('click');
    });

    $("#hora").keyup(function (event) {
        $("#hora_error").text('');
        if ($("#hora").val() != '' && $("#time").val() > 0) {
            $("#validar_hora").text('');
        }
    });

    $("#time").change(function (event) {
        $("#time_error").text('');
        if ($("#hora").val() != '' && $(this).val() > 0) {
            $("#validar_hora").text('');
        }
    });

    $("#frm-solicitud").validate({
        ignore: "",
        rules: {
            fecha: {required: true},
            personas: {required: true},
            encargado: {required: true, min: 1},
            hora: {required: true},
            contacto: {required: true},
            descripcion: {required: true},
            //estado:{required:true},
            "destino[]": {required: true},
            //actividad_des:{ required:true},
            vehiculo: {required: true, min: 1}
        },
        messages: {
            encargado: "Campo requerido",
       },
        ignore: ".select2-container",
                errorPlacement: function (error, element) {
                    var nombre = $(element).attr("id");
                    $('#' + nombre + '_error').html(error);
                    if ($("#hora_error").text() != '' || $("#time_error").text() != '') {
                        //$("#validar_hora").text("Campo requerido");
                        $("#validar_hora").html('<label for="hora" class="error">Campo requerido</label>');
                    } else {
                        $("#validar_hora").text("");
                    }
                },
        submitHandler: function (form) {
            if ($("#error").val() == 0) {
                form.submit();
            }
        }
    });

});

function verificarValidacion() {

    var error_tab1 = false;
    var error_tab2 = false;

    if ($("#vehiculo").val() == 0 || $("#personas").val() == '' || $("#encargado").val() == '' || $("#hora").val() == '' || $("#contacto").val() == '' || $("#descripcion").val() == '' || $("#destino").val() == 0) {
        $("#pes-solicitud").addClass("clasecss");
        error_tab1 = true;
        //alert(error_tab1);
    } else if ($("#error").val() == 1) {
        $("#pes-anexo").addClass("clasecss");
        error_tab2 = true;
    }


    setTimeout(function () {
        if ($(".error").length > 0 || $("#pes-solicitud").hasClass('clasecss')) {
            $("#datagried").addClass('error');
            nombre_tab = "";

            if (error_tab1 == true) {
                $("#pes-solicitud").trigger('click');
                nombre_tab = "en la <br/> <h5>Pestaña Solicitud.</h5>";
            }
            if ($.trim(nombre_tab) != "") {
                crear_alerta('error', 'Campos Requeridos (*)', 'Favor revisar los campos requeridos ' + nombre_tab)
            }
            ;
        } else if ($("#error").val() == 1 || $("#pes-anexo").hasClass('clasecss')) {
            nombre_tab2 = '';
            if (error_tab2 == true) {
                $("#pes-anexo").trigger('click');
                nombre_tab2 = "en la <br/> <h5>Pestaña Anexo.</h5>";
            }
            if ($.trim(nombre_tab2) != "") {
                crear_alerta('error', 'Documentos adjuntos', 'Favor revisar los nombres de los documentos ' + nombre_tab2)
            }
            ;

        }
    }, 500);
} // End verificarValidacion 