$(document).ready(function(){

	$("#contrato").on('change', function(){
		limpiar_series();
        if($(this).val()>0){
            $.ajax({          
                    type: 'POST',
                    url: urlj+'transporte/inicio_trans/cargar_series',          
                    dataType: 'json',
                    data: {id_contrato: $(this).val()},
                  success: function(data){          
                    $("#series").html(data.series).select2();  
                  } 
              });
        }
    });

  $("#vale_det").keyup(function(event){
    ticket_val=$(this).val();
    $("#valor_ticket").val(ticket_val);
  });

	$("#series").on('change', function(){
      cargar_tabla_vales($(this).val());
      $("#cantidad").attr('disabled',false);
       $("#vale_det").val($("#total_vales").val());
       $("#valor_ticket").val($("#vale_det").val());
      $("#vales_inicio, #cantidad").attr('readonly',false);
    });

    $("#vales_inicio").keyup(function(event) {
      if($(this).val().trim() != '' && $(this).val().trim()>=1 && $("#cantidad").val()>=1){
        var cantidad = parseInt($(this).val()) + parseInt($("#cantidad").val()) -1;
        $("#vales_fin").val(cantidad);  
      }
    });

    $("#cantidad").focus(function(){
      $("#vales_inicio").val('');
      $("#vales_fin").val('');
    });

    $("#ver_vales").on('click', function(event){
    	event.preventDefault();
    	cargar_tabla_vales($('#series').val());
    	setTimeout(function(){ ver_serie_vales(); }, 500);
    });

    $("#vales_inicio").focus(function() {
    	$("#v_inicioCorrelativo").text('');
  	});

}); // End document ready

// All your functions goes here (Those functions most be call from events) 


function eliminar_vales_asignados(vxg_id)
{
  $.ajax({          
      type: 'POST',
      url: urlj+'transporte/inicio_trans/eliminar_vales_transporte',          
      dataType: 'json',
      data: {vxg_id: vxg_id},
    success: function(data){          
      
    } 
  });
} // End eliminar_vales_asignados

function eliminar_vales_combustible(vxc_id)
{
  $.ajax({          
      type: 'POST',
      url: urlj+'transporte/inicio_trans/eliminar_vales_combustible',          
      dataType: 'json',
      data: {vxc_id: vxc_id},
    success: function(data){          
      
    } 
  });
} // End eliminar_vales_asignados



function cargar_tabla_vales(id_serie)
{
    var vales_temp_inicio = new Array();
    var vales_temp_fin    = new Array();

      if($(".fin_"+id_serie).length > 0 ){
      $(".inicio_"+id_serie).each(function() {
        //El inicio temporal
        var inicio_local = $.trim($(this).val());
         vales_temp_inicio.push(inicio_local);
      });
      $(".fin_"+id_serie).each(function() {
        //El fin temporal
        var fin_local= $.trim($(this).val());
         vales_temp_fin.push(fin_local);
      });
     } // End if

    if(id_serie>0){
        $.ajax({          
                type: 'POST',
                url: urlj+'transporte/inicio_trans/get_rangos_libres',          
                dataType: 'json',
                data: {id_serie: id_serie, vales_inicio: vales_temp_inicio, vales_fin: vales_temp_fin},
              success: function(data){   
                
                $("#tablaValesSeries").html(data.tabla_vales); //setear la tabla
                if(data.valor!='' && data.valor!= null){ 
                  $("#valor_ticket").val(data.valor);
                 
                  $("#label_valor_ticket").html('Valor del vale: <b>$ '+data.valor+'</b>');
                  $("#div_agregar").css({'left':'380px'});
                  $("#div_valor_ticket").show();
                  $("#div_vale").hide();
                 
                }else{
                  $("#div_agregar").css({'left':'530px'});
                  $("#div_valor_ticket").hide();
                  $("#div_vale").show();
                }
               	$("#div_ver_vales").show();
              } 
          });
    }
} // End cargar_tabla_vales

function validar_rango_correlativo()
{
    
    var id_serie      = $("#series").val();
    var inicio_serie  = $("#vales_inicio").val();
    var fin_serie     = $("#vales_fin").val();

    var vales_temp_inicio = new Array();
    var vales_temp_fin    = new Array();

      if($(".fin_"+id_serie).length > 0 ){
      $(".inicio_"+id_serie).each(function() {
        //El inicio temporal
        var inicio_local = $.trim($(this).val());
         vales_temp_inicio.push(inicio_local);
      });
      $(".fin_"+id_serie).each(function() {
        //El fin temporal
        var fin_local= $.trim($(this).val());
         vales_temp_fin.push(fin_local);
      });
     } // End if

    if(id_serie>0 && inicio_serie>0 && fin_serie >0){
        $.ajax({          
                type: 'POST',
                url: urlj+'transporte/inicio_trans/validar_rango_correlativo',          
                dataType: 'json',
                data: {id_serie: id_serie, inicio_input : inicio_serie, fin_input : fin_serie, vales_inicio: vales_temp_inicio, vales_fin: vales_temp_fin},
              success: function(data){   
                
                if(data.espacio==false) { //no hay disponibilidad para dicho rango
                  $("#vales_inicio, #vales_fin").val('');
                  $("#v_inicioCorrelativo").text('No hay disponibilidad para dicho rango');
                }

                $("#tablaValesSeries").html(data.tabla_vales); //setear la tabla
              } 
          });
    } else {
      $("#inicio_serie").val('');
      $("#fin_serie").val('');
    }
} // Validar rango correlativo

function ver_serie_vales() {
 
    var Inf_correlativos = $("#tablaValesSeries").html();
   $.fancybox(Inf_correlativos,{
    openEffect: 'fade',
    closeEffect: 'fade',
    scrolling:	'auto',    
    width    : '800',
    height    : 'auto'
  });
 }

function limpiar_series()
{
	$("#cantidad, #vales_inicio, #vales_fin").val('');
	$("#div_valor_ticket").hide();
	$("#div_ver_vales").hide();
  $("#div_vale").hide();
  $("#div_agregar").css({'left':'380px'});
  $("#valor_ticket").val('');
	$("#vales_inicio, #cantidad").attr('readonly',true);
}