$(document).ready(function(){
  
  $("select option[value='0']").val('');
  $("input[name^='fecha']").datepicker({
    dateFormat: 'dd-mm-yy',
    changeMonth: true, 
    changeYear: true,
    showButtonPanel: true,
    changeMonth: true,
    changeYear: true,
    dateFormat: 'dd-mm-yy',
    monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
    dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
    nextText: "Siguiente",
    prevText: "Anterior"});
  $("input[name^='fecha']").mask("99-99-9999");
  $("input[name^='fecha']").attr('placeholder',"dd-mm-yyyy");
  
  $("#origen").select2();
  $("#cliente").select2();
  $("#servicio").select2();$("#procesado").select2();

  $("#cliente").change(function(){
        var cli = $(this).val();
        var ser = $("#servicio").val();

        if(cli!='' || ser!=''){
            $.ajax({
                url: 'obtener_cdr_cliente_servicio',
                type: 'POST',
                //dataType: 'json',
                data: {cliente:cli,'servicio':ser},
                success:function(data) {
                    $("#origen").html(data);
                    $("#origen").select2();
                }
            });
        }
  });

  $("#servicio").change(function(){
        var ser = $(this).val();
        var cli = $("#cliente").val();

        if(cli!='' || ser!=''){
            console.log(cli+' '+ser);
            $.ajax({
                url: 'obtener_cdr_cliente_servicio',
                type: 'POST',
                //dataType: 'json',
                data: {cliente:cli,'servicio':ser},
                success:function(data){
                    $("#origen").html(data);
                    $("#origen").select2();
                }
            });
        }
  });

  $("#filtro").click(function(){

    var origen = $("#origen").val();
    var procesado = $('#procesado').val();
    var fecha_ini = $("#fecha_inicio").val();
    var fecha_fin = $("#fecha_fin").val();
    if(fecha_ini!='' && fecha_fin!=''){
        if(!verifica_fecha(fecha_ini,fecha_fin)){
          return false; 
        }
    }
    
    $.ajax({
        url: 'consultar_detalle_cdr',
        type: 'POST',
        dataType: 'json',
        data: {origen:origen,fecha_ini:fecha_ini,fecha_fin:fecha_fin,procesado:procesado},
        success:function(data) {
            $("#datagried").html(data.drop);
            $("#checkAll").show('slide');
            $("#descargar").show();
            //$(".form-actions").show('slow');
            $(".botones_export_print").show('slow');
        }
    });
  });

  function verifica_fecha(fecha_ini, fecha_fin){
        //Convierto la fecha a Y-m-d
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");

        if(Date.parse(fecha_i) == Date.parse(fecha_f)){ $("#fecha_fin_error").text(''); return true;}
        
        if(Date.parse(fecha_i) > Date.parse(fecha_f)){
          crear_alerta('error','Error','Verifique las fechas del período');
          //$("#fecha_fin_error").text("Verifique las fechas del período");
          return false;
        }

        if(Date.parse(fecha_i) < Date.parse(fecha_f)){
          $("#fecha_fin_error").text('');
          return true;
        }
    }
});