$(document).ready(function(){
  
  $("select option[value='0']").val('');
  $("input[name^='fecha']").datepicker({
    dateFormat: 'dd-mm-yy',
    changeMonth: true, 
    changeYear: true,
    showButtonPanel: true,
    changeMonth: true,
    changeYear: true,
    dateFormat: 'dd-mm-yy',
    monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
    dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
    nextText: "Siguiente",
    prevText: "Anterior"});
  $("input[name^='fecha']").mask("99-99-9999");
  $("input[name^='fecha']").attr('placeholder',"dd-mm-yyyy");
  
  $("#promo").select2();
  $("#departamento").select2();

  $("#filtro").click(function(){

    var promo = $("#promo").val();
    var departamento = $("#departamento").val();
    var fecha_ini = $("#fecha_inicio").val();
    var fecha_fin = $("#fecha_fin").val();

    if(fecha_ini!='' && fecha_fin!=''){
        if(!verifica_fecha(fecha_ini,fecha_fin)){
          return false; 
        }
    }
    
    $.ajax({
      url: 'consultar_consolidado_promo',
      type: 'POST',
      dataType: 'json',
      data: {promo:  promo,depto:departamento,fecha_ini:fecha_ini,fecha_fin:fecha_fin},
      success:function(data) {
        $("#datagried").html(data.drop);
        $("#checkAll").show('slide');
        $("#descargar").show();
        $(".form-actions").show('slow');
        $(".botones_export_print").show('slow');
      }
    });
  });

  function verifica_fecha(fecha_ini, fecha_fin){
        //Convierto la fecha a Y-m-d
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");

        if(Date.parse(fecha_i) == Date.parse(fecha_f)){ $("#fecha_fin_error").text(''); return true;}
        
        if(Date.parse(fecha_i) > Date.parse(fecha_f)){
          crear_alerta('error','Error','Verifique las fechas del período');
          return false;
        }

        if(Date.parse(fecha_i) < Date.parse(fecha_f)){
          $("#fecha_fin_error").text('');
          return true;
        }
    }
});