/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

$(document).ready(function(){
  
  var pathArray = window.location.pathname.split( '/' );
  var urlj=url_base_proyecto;
  
  $("#checkAll").DataTable({
      "bPaginate": false,
      "aaSorting": [[0,'desc']]
  });

  $("select option[value='0']").val('');
  $("input[name^='fecha']").datepicker({
    dateFormat: 'dd-mm-yy',
    changeMonth: true, 
    changeYear: true,
    showButtonPanel: true,
    changeMonth: true,
    changeYear: true,
    dateFormat: 'dd-mm-yy',
    monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
    dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
    nextText: "Siguiente",
    prevText: "Anterior"});
  $("input[name^='fecha']").mask("99-99-9999");
  $("input[name^='fecha']").attr('placeholder',"dd-mm-yyyy");
  
  $("#filtro").click(function(){

    var fecha_ini = $("#fecha_inicio").val();
    var fecha_fin = $("#fecha_fin").val();

    if(fecha_ini!='' && fecha_fin!=''){
        if(!verifica_fecha(fecha_ini,fecha_fin)){
          return false; 
        }
    }
    $.ajax({
      url: urlj+'tarificador/reportes/cdr_no_procesados',
      type: 'POST',
      dataType: 'json',
      data: {fecha_inicio:fecha_ini, fecha_fin:fecha_fin},
      success:function(data) {
        $("#datagried").html(data.drop);
        $("#checkAll").show('slide');
        //$("#descargar").show();
        $(".form-actions").show('slow');
        $(".botones_export_print").show('slow');
      }
    });
  });

  function verifica_fecha(fecha_ini, fecha_fin){
        //Convierto la fecha a Y-m-d
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");
        
        if(Date.parse(fecha_i) == Date.parse(fecha_f)){ $("#fecha_fin_error").text(''); return true;}
        
        if(Date.parse(fecha_i) > Date.parse(fecha_f)){
          crear_alerta('error','Error','Verifique las fechas del período');
          return false;
        }

        if(Date.parse(fecha_i) < Date.parse(fecha_f)){
          $("#fecha_fin_error").text('');
          return true;
        }
    }
});