/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

$(document).ready(function () {
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;
    
    $('select').select2();
    $("input[name^='fecha']").mask("99-99-9999");
    $("input[name^='fecha']").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
    $("#minutos").numeric();
    $("#costo").numeric(".");
    $('.numeric').live('keyup', function () {
        this.value = (this.value + '').replace(/[^0-9]/g, '');
    });

    $('#form_cliente').validate({
        ignore: 'input[type="hidden"]',
        rules: {
            fecha_desde: {required: true},
            fecha_hasta: {required: true, fecha_ini_fin: ["input[name='fecha_desde']", "input[name='fecha_hasta']"]},
            nombre: {required: true},
            minutos: {required: true},
            costo: {required: true},
            tipo: {required: true, min: 1}
        },
        errorPlacement: function (error, element) {
            if ($(element).is("select")) {
                $(element).next().append(error);
            }
            else {
                error.insertAfter(element);
            }
        },
        submitHandler: function (form) {
            form.submit();
        }
    });

    // Validar la fecha fin
    jQuery.validator.addMethod("fecha_ini_fin", function (value, element, params) {

        ini = $(params[0]).val();
        fin = $(params[1]).val();
        return this.optional(element) || (ini <= fin);

    }, jQuery.validator.format("Verifique las fechas del periodo."));

    // Peticion AJAX Select2
    $("#codigos_aplica").select2({
        placeholder: "Buscar un destino",
        minimumInputLength: 2,
        multiple: true,
        ajax: {
            url: urlj + 'tarificador/procesos/buscar_destino',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (prefijo) {
                return {
                    buscar: prefijo
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {

                    myResults.push({
                        'id': item.ppa_id,
                        'text': item.ppa_nombre + ' || ' + item.ppa_desde_codigo
                    });
                });

                return {
                    results: myResults
                };
            }
        },
    });
});
