$(document).ready(function(){
	window.gSateliteWhite.jsSelect();
	var interes = $("#interes").val();
	$('select option[value=0]').val('');

	$(".solo-numeros").numeric();

	$('.solo-numeros').live('keyup', function (){
        this.value = (this.value + '').replace(/[^0-9\.]/g, '');
	});

	$("#crear").hover(function(){
		$("#tipo_btn").val(1);
	});

	$("#crear_v").hover(function(){
		$("#tipo_btn").val(2);
	});

	$("#sin_int").iButton({
      'labelOn':'Si',
      'labelOff':'No',
      change:function(element){
          if(element.is(':checked')){
            $("#sin_interes").val(1);
          }
          else{
            $("#sin_interes").val(0);
          }
      }
    });

     $("#sin_int").attr('checked','checked');
    $("#sin_int").trigger('change');

	jQuery.fn.dataTableExt.oApi.fnGetHiddenNodes = function ( settings )
	{
			var nodes;
			var display = jQuery('tbody tr', settings.nTable);

			if ( jQuery.fn.dataTable.versionCheck ) {
			// DataTables 1.10
			var api = new jQuery.fn.dataTable.Api( settings );
			nodes = api.rows().nodes().toArray();
		}
		else {
			// 1.9-
			nodes = this.oApi._fnGetTrNodes( settings );
		}

		/* Remove nodes which are being displayed */
		for ( var i=0 ; i<display.length ; i++ ) {
			var iIndex = jQuery.inArray( display[i], nodes );

			if ( iIndex != -1 ) {
				nodes.splice( iIndex, 1 );
			}
		}

		return nodes;
	};

    $(".eliminar").live('click',function(){
    	event.preventDefault();

    	var anexo = $(this).attr('href');

    	alerta_confirm(anexo,'Alerta de confirmación','¿Seguro que quieres eliminar esta solicitud?');
    });

    $(":submit").live('click',function(event){
    	event.preventDefault();

    	if($("#contenedor_facturas tr").length==0){
			crear_alerta('error','Financiamiento', 'Debe ingresar al menos una factura');
			return false;
		}

		if($("#contenedor_cuotas tr").length==0){
			crear_alerta('error','Financiamiento', 'Debe generar las cuotas');
			return false;
		}

		tabla = $("#tabla_cuotas").dataTable();

		$(tabla.fnGetHiddenNodes()).find('input').appendTo("#cuotas_hidden");

		/*nods.each(function(index){
			console.log(nods[index]);
		});*/
		

		$("#financiamiento").submit();
    });

	$("#financiamiento").validate({
		ignore: "",
		rules: {
			fecha_plan:{required:true},
			observacion:{required:true},
		},
		errorPlacement: function(error, element){
			var nombre = $(element).attr("id");
			$("#"+nombre+"_error").html(error);
		}
	});

	$("#cliente").change(function(event){
		var val = $(this).val();
		if(val!=''){
			$.ajax({
				url:url_base_proyecto+'tarificador/procesos/cargar_facturas',
				data:{cli:val},
				type:'POST',
				success: function(data){
					$("#factura").html(data);
					$("#factura").select2();
					$("#factura option[value='0']").val('');
				},
			});	
		}
	});

	/*Filtrar Grid*/
	//$("input[name^='fecha']").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
	$("input[name^='fecha']").mask("99-99-9999");
	$("input[name^='fecha']").attr('placeholder',"dd-mm-yyyy");
	$("input[name^='fecha']").removeClass('hasDatepicker').datepicker({
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            dateFormat: 'dd-mm-yy',
            monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
            dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
            nextText: "Siguiente",
            prevText: "Anterior",
            closeText: 'Cerrar',
 			currentText: 'Hoy',
            //minDate: 0
    });

	$("#fecha_ini, #fecha_fin").change(function(event){
		jQuery.validator.addMethod("fecha_ini_fin", function(value, element, params) {
        ini = $(params[0]).val();
        fin = $(params[1]).val();
            return this.optional(element) || ( ini <= fin );
       
        }, jQuery.validator.format("Verifique las fechas del periodo."));

    	jQuery.validator.addMethod("fecha", function(value, element) {
            // dd/mm/yyyy
            var re = /^\d{1,2}\-\d{1,2}\-\d{4}$/;
            // valid if optional and empty OR if it passes the regex test
            return (this.optional(element) && value=="") || re.test(value);
        }, jQuery.validator.format("Verifique las fechas del periodo.")
        );
	});

	//TABLA ELEMENTO
	$("#agregar_fac").live('click',function(event){
		event.preventDefault();

		var factura = $("#factura").val();
		
		var error = '';
		if(factura=='' || factura==null){
			$("#factura").addClass('error');
			var nombre = $("#factura").attr("id");
			error = '<label for="" generated="true" class="error">Campo requerido.</label>';
			$("#"+nombre+"_error").html(error);
		}

		if(error!=''){ return false; }

		var id_tr = factura;
		var con = $("#"+id_tr).attr('id');
		if(con!='' && typeof(con)!='undefined'){
			crear_alerta('error','Financiamiento', 'La factura ya fue ingresada');
		}
		else{

			if($("#contenedor_cuotas tr").length>0){
				var plan = $("#plan").val();

				var data = {'factura':0,'plan':plan};

				alerta_confirm_ajax(modificar_factura,data,'Alerta de confirmación','¿Seguro que quieres modificar el plan de pagos? Debera generar nuevamente el cálculo de cuotas.');
			}
			else{
				agregar_factura();
			}
		}		
	});

	

	$(".del_fact").live('click',function(){
		var parent = $(this).parent().parent();

		var monto_act = $("#monto_deuda").val();

		var total_nuevo = monto_act - $(this).val();

		$("#monto_deuda").val(total_nuevo);

		$("#"+parent[0].id).remove().delay(300);
		$("#contenedor_cuotas").html('');
		if($("#contenedor_facturas tr").length==0){
			$("#tabla_facturas").fadeOut(200);
		}
	});

	//TABLA ELEMENTO
	$("#generar_cuotas").live('click',function(event){
		event.preventDefault();
		
		var num_factura;
		
		var fecha_cuota = $("#fecha_cuota").val();

		var num_cuotas = $("#cuotas").val();

		var error = '';

		num_factura = $("#contenedor_facturas tr").length;
		
		if(num_factura==0){
			crear_alerta('error','Financiamiento', 'Debe ingresar al menos una factura');
			return false;
		}

		if(fecha_cuota==''){
			$("#fecha_cuota").addClass('error');
			var nombre = $("#fecha_cuota").attr("id");
			error = '<label for="" generated="true" class="error">Campo requerido.</label>';
			$("#"+nombre+"_error").html(error);
		}

		if(num_cuotas==''){
			$("#cuotas").addClass('error');
			var nombre = $("#cuotas").attr("id");
			error = '<label for="" generated="true" class="error">Campo requerido.</label>';
			$("#"+nombre+"_error").html(error);
		}

		if(error!=''){ return false; }

		else{	

			$("#tabla_cuotas").dataTable().fnDestroy();
			$("#contenedor_cuotas").html('');

			var partes = fecha_cuota.split('-');
			var dia = partes[0];
			var dia_principal = partes[0];
			var mes = parseInt(partes[1]);
			var anio = parseInt(partes[2]);
			var calc_total_cuotas = 0;
			var num_cuota = 0;
			html = '';

			var monto_act = $("#monto_deuda").val();

			monto_cuota = monto_act/num_cuotas;

			monto_cuota = monto_cuota.toFixed(2);

			monto_cuota = parseFloat(monto_cuota);
			
			sin_interes = $("#sin_interes").val();

			if(sin_interes==0){
				var impuesto = 0;	
			}
			else{
				var impuesto = monto_cuota * interes;
			}

			impuesto = impuesto.toFixed(2);

			impuesto = parseFloat(impuesto);

			var total_cuota = monto_cuota + impuesto;

			total_cuota = total_cuota.toFixed(2);

			total_cuota = parseFloat(total_cuota);

			if(sin_interes==0){

				calc_total_cuotas = monto_cuota * num_cuotas;

				calc_total_cuotas = aproximar_decimales(calc_total_cuotas,2);

				diferencia = monto_act - calc_total_cuotas;

				diferencia = aproximar_decimales(diferencia,2);

				if(diferencia>0){
					nuevo_monto = monto_cuota + diferencia;
					nuevo_monto = aproximar_decimales(nuevo_monto,2);
					num_cuota = 1;
				}
				else if(diferencia<0){
					nuevo_monto = monto_cuota - (diferencia*-1);
					nuevo_monto = aproximar_decimales(nuevo_monto,2);
					num_cuota = num_cuotas; 
				}
			}

			for (var i = 1; i <= num_cuotas; i++) {

				if(num_cuota == i){
					monto_cuota = nuevo_monto;
					total_cuota = nuevo_monto;
				}

				if(i > 1) { mes++;}
				if(mes==2){
					if(dia_principal>27) {
						dia = (new Date((new Date(anio, mes, 1)) - 1)).getDate();
					}
				}else{
					dia = dia_principal;
					if(dia_principal>30) {
						dia = (new Date((new Date(anio, mes, 1)) - 1)).getDate();
					}
				}
				if(mes > 12) { mes = 1; anio++;}
				if(sin_interes==0){ impuesto = 0.00; } 
				fecha = dia+'-'+(mes<10 ? '0' : '')+mes+'-'+anio;

				html += '<tr id="'+i+'">';

				html += '<td>';
				html += '<input type="text" name="num_cuotas[]" class="text tables-input-show tables-input solo-numeros" value="'+i+'" readonly="readonly"/>'
				html += '</td>';

				html += '<td>';
				html += '<input type="text" name="vencimientos[]" class="text tables-input-show tables-input solo-numeros" value="'+fecha+'" readonly="readonly"/>';
				html += '</td>';

				html += '<td><input type="hidden" name="montos[]" class="text tables-input-show tables-input solo-numeros" value="'+monto_cuota+'" readonly="readonly"/>';
				html += '<input type="text" class="text tables-input-show tables-input solo-numeros" value="$'+monto_cuota+'" readonly="readonly"/>';
				html += '</td>';

				html += '<td><input type="hidden" name="impuestos[]" class="text tables-input-show tables-input solo-numeros" value="'+impuesto+'" readonly="readonly"/>';
				html += '<input type="text" class="text tables-input-show tables-input solo-numeros" value="$'+impuesto+'" readonly="readonly"/>';
				html += '</td>';

				html += '<td><input type="hidden" name="totales[]" class="text tables-input-show tables-input solo-numeros" value="'+total_cuota+'" readonly="readonly"/>';
				html += '<input type="text" class="text tables-input-show tables-input solo-numeros" value="$'+total_cuota+'" readonly="readonly"/>';
				html += '</td>';

				html +='</tr>';
			}

			$("#contenedor_cuotas").append(html);

			$("#tabla_cuotas").fadeIn(200);

			$("#tabla_cuotas").addClass('dynamicTable');
			$("#tabla_cuotas").dataTable();

			window.gSateliteWhite.jsSelect();
		}
	});

	$(".del_fact_edit").live('click',function(){

		var plan = $("#plan").val();

		var factura = $(this).data('fac');

		var monto = $(this).val();

		var data = {'factura':factura,'plan':plan,'monto':monto};

		alerta_confirm_ajax(eliminar_registro,data,'Alerta de confirmación','¿Seguro que quieres eliminar permanentemente este registro? Debera generar nuevamente el cálculo de cuotas.');
	});
});

function eliminar_registro(data){
	$.ajax({
		url:url_base_proyecto+'tarificador/procesos/e_registros_plan_pago',
		data:{factura:data.factura,plan:data.plan},
		type:'POST',
		success:function(html){

			var monto_act = $("#monto_deuda").val();

			var total_nuevo = monto_act - data.monto;

			$("#monto_deuda").val(total_nuevo);

			$("#"+data.factura).remove().delay(300);
			$("#contenedor_cuotas").html('');
			$("#generar_cuotas").removeAttr('disabled');
			if($("#contenedor_facturas tr").length==0){
				$("#tabla_facturas").fadeOut(200);
			}
		}
	});
}

function agregar_factura(){

	var factura = $("#factura").val();

	var error = '';
	if(factura=='' || factura==null){
		$("#factura").addClass('error');
		var nombre = $("#factura").attr("id");
		error = '<label for="" generated="true" class="error">Campo requerido.</label>';
		$("#"+nombre+"_error").html(error);
	}

	if(error!=''){ return false; }

	var id_tr = factura;
	var con = $("#"+id_tr).attr('id');
	if(con!='' && typeof(con)!='undefined'){
		crear_alerta('error','Financiamiento', 'La factura ya fue ingresada');
	}
	else{

			$("#contenedor_cuotas").html('');
			var producto =  $("#factura option:selected").data('servicio');
			var num_fac =  $("#factura option:selected").data('num_fac');
			var periodo =  $("#factura option:selected").data('periodo');
			var total =  $("#factura option:selected").data('total');
			var estado =  $("#factura option:selected").data('estado');

			var monto_act = $("#monto_deuda").val();

			monto_act = parseFloat(monto_act);
			//monto_act = monto_act.toFixed(2);

			total = parseFloat(total);
			//total = total.toFixed(2);

			var total_general = parseFloat(monto_act + total);

			estado_text = (estado==1) ? 'Pendiente':'Pagada';

			// console.log(producto);
			// return false;

			html = '<tr id="'+id_tr+'">';


			html += '<td>';
			//hiddens
			html += '<input type="hidden" name="facturas[]" class="text tables-input-show tables-input solo-numeros" value="'+factura+'" readonly="readonly"/>'
			html += '<input type="text" class="text tables-input-show tables-input solo-numeros" value="'+producto+'" readonly="readonly"/>';
			html += '</td>';

			html += '<td><input type="text" id="fac_monto" name="" class="text tables-input-show tables-input solo-numeros" value="'+num_fac+'" readonly="readonly"/></td>';
			html += '<td><input type="text" class="text tables-input-show tables-input solo-numeros" value="'+periodo+'" readonly="readonly"/></td>';
			html += '<td><input type="text" class="text tables-input-show tables-input solo-numeros" value="$'+total+'" readonly="readonly"/></td>';
			html += '<td><input type="text" class="text tables-input-show tables-input solo-numeros" value="'+estado_text+'" readonly="readonly"/></td>';

			html+='<td>';
			html+='<button type="button" value="'+total+'" class="btn btn-danger btn-mini del_fact" style="float:left; /*margin-left:5%;*/ height:30px;width:50px;"><input type="hidden" value="6" id="txtest">Eliminar</button>';
			html+='</td>';

			html += '</tr>';

			$("#monto_deuda").val(total_general);
			$("#contenedor_facturas").append(html);

			$("#tabla_facturas").fadeIn(200);

			$("#generar_cuotas").removeAttr('disabled');

		}
	}

function modificar_factura(data){
	$.ajax({
		url:url_base_proyecto+'tarificador/procesos/e_registros_plan_pago',
		data:{factura:data.factura,plan:data.plan},
		type:'POST',
		success:function(html){
			console.log(data);
			agregar_factura();
		}
	});
}

function aproximar_decimales(cantidad,decimales){

	cantidad = cantidad.toFixed(decimales);

	cantidad = parseFloat(cantidad);

	return cantidad;

}