$(document).ready(function(){
  
  $("select option[value='0']").val('');
  $("input[name^='fecha']").datepicker({
    dateFormat: 'dd-mm-yy',
    changeMonth: true, 
    changeYear: true,
    showButtonPanel: true,
    changeMonth: true,
    changeYear: true,
    dateFormat: 'dd-mm-yy',
    monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
    dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
    nextText: "Siguiente",
    prevText: "Anterior"});
  $("input[name^='fecha']").mask("99-99-9999");
  $("input[name^='fecha']").attr('placeholder',"dd-mm-yyyy");
  
  $("#cliente").select2();
  $("#filtro").click(function(){
    var fecha_ini = $("#fecha_inicio").val();
    var fecha_fin = $("#fecha_fin").val();
    var cliente   = $("#cliente").val();

    if(fecha_ini==''){
      $("#fecha_inicio").addClass('error');
       crear_alerta('error','Error','Complete todos los campos');
      return false;
    }

    if(fecha_fin==''){
      $("#fecha_fin").addClass('error');
       crear_alerta('error','Error','Complete todos los campos');
      return false;
    }

    if(fecha_ini!='' && fecha_fin!=''){
        if( !validarDiasDelMes(fecha_ini, fecha_fin, false) ){
            return false; 
      }
    }
    wait.start();
    $.ajax({
      url: 'calcular_costo_llamada',
      type: 'POST',
      dataType: 'json',
      data: {fecha_ini:fecha_ini,fecha_fin:fecha_fin, cliente:cliente},
      success:function(data) {
        wait.close();
        if(data.ninguno == 1){
          crear_alerta('warning','Nota','No se modifico ningun registro');
          $("#datagried").html(data.drop);
          $("#listado").show('slide');
        }
        else{
          crear_alerta('success','Completado','Procesos completado correctamente');
          $("#datagried").html(data.drop);
          $("#listado").show('slide');
        }
      },error: function(request, status, error){
        wait.close();
        console.log(request);
        console.log(status);
        console.log(error);
        crear_alerta('error','Error','Hubo un problema al realizar la operación');
      }
    });
  });

   $(".ver_en_modal_ctel").fancybox({
       'autoSize': false,  
       'width': 800,
       'height': 460,
      openEffect  : 'elastic',
      closeEffect : 'elastic',
      href: $(this).attr('href'),
      type: 'iframe'
    });

}); // End jquery on load
      