jQuery(document).ready(function($){

	var pathArray = window.location.pathname.split( '/' );
	var urlj=url_base_proyecto;

	$("input[name^='fecha']").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
	$("input[name^='fecha']").mask("99-99-9999");
	$("input[name^='fecha']").attr('placeholder',"dd-mm-yyyy");
	$("#cargo, #estado").select2();

	$("#cargo").change(function(event){
		id_cargo=$(this).val();

		$.ajax({
			type: 'POST',
		    url: urlj+'tarificador/procesos/get_cargo_costo',
		    data: {id_cargo:id_cargo},
		    success: function(data){
		    if(data>0){
		    	valor=parseFloat(data);
		     	$("#costo").val(valor);
		    }
		    
		    }
		});

	});


	$("#form_producto_cliente").validate({
        rules:{
            cargo:{required:true, min:1},
            fecha_contrato:{required:true},
            costo:{required:true},
            estado:{required:"#estado:visible", min:1}
        },
        messages:{
           cargo:"Campo requerido", 
           estado:"Campo requerido"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("name");
            $('#'+nombre+'_error').html(error);
        },
        submitHandler: function(form) {
                form.submit();
        }
    });

    $("#crear").mouseover(function(event){
    	$("#boton").val(1);
    });
     $("#crear_b").mouseover(function(event){
    	$("#boton").val(2);
    });

});