/**
 * Descripcion: Utilidades Basicas de javaScript implementada en la plantilla azul, con el 
 *              objetivo de agilizar el desarrollo de las aplicaciones web.
 * @author:     Alan Alvarenga.
 * @version:    0.3 2013-07-19
 * @since:      2013-07-19
 * @package:    Grupo Satelite Blue (plantilla azul)
 * @type {Object}
 * =================================================================================================
 * Nomenclatura:
 * + AGREGADO
 * - ELIMINADO
 * * ACTUALIZADO
 * -------------------------------------------------------------------------------------------------
 * Bitacora:
 * 2013-07-19
 * + baseUrl    -   genera la URL base de el proyecto.
 * + jsSelect   -   convierte todos las etiquetas de tipo select a select2 
 * + jsDatePicker   - convierte todos los input de tipo text que posean en el name la palabra fecha
 * por Alan Alvarenga.
 * -------------------------------------------------------------------------------------------------
 */

var urlj=url_base_proyecto;

window.gSateliteWhite = {
    baseUrl: function (path) {
        //Set default value, si no es definido
        path = typeof path !== 'undefined' ? path : '';

        //Set default value, si no es definido
        path = typeof path !== 'undefined' ? path : '';

        //Magic ;)
        return satelite.base_url() + path;
    },
    jsSelect: function () {
        //Obtiene todos las etiquetas de tipo select.
        var $select = $("select");
        //A traves de la propiedad prototype, adjudica a cada select la funcion select2
        return $select.select2({placeholder:"Selecccione una opción"});
    },
    jsDatePicker: function (selector) {
        if(selector == '' || selector === undefined){
            selector = "input[name*='fecha']";
        }

        $(selector).datepicker({
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            dateFormat: 'yy-mm-dd',
            monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
            dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
            nextText: "Siguiente",
            prevText: "Anterior",
        }).click(function() {
            $('button.ui-datepicker-current')
            .removeClass('ui-priority-secondary')
            .addClass('ui-priority-primary');
        });
        $('button.ui-datepicker-current').live('click', function() {
            $.datepicker._curInst.input.datepicker('setDate', new Date()).datepicker('hide').blur();
        });
    },
    jsSelectFilter: function (options) {
        var url = gSateliteBlue.baseUrl('utils/ajax/call/get_dropdown_filter');
        $.ajax({
            url: url,
            dataType: 'json',
            data: options,
            type: 'GET',
            success: function (data) {

                var rows = data.message;
                var $selector = $('[name="' + options.insert + '"]');

                gSateliteBlue.fn.doList($selector, rows);
            }
        });
    },
    jsUnsetDateTimePicker: function(formato) {
        if(formato=='' || formato == null) { formato = 'dd-mm-yy'; }
        $('.datetime-input').datetimepicker('destroy');
        $('.datetime-input').next().remove();

        $('.datetime-input').each(function(){
            var parent = $(this).parent();
            var children = parent.children();
            parent.html('');
            parent.append(children);
        });

        $('.datetime-input').datetimepicker({
            //timeFormat: '',
            separator:'',
            dateFormat: formato,
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            showTimepicker:false,
            autoClose: true,
            onSelect: function(){
                //$("#ui-datepicker-div").fadeOut('200');
                $(".ui-datepicker-close").trigger('click');
            }
        });
    },
    fn: {
        doList: function ($selector, rows) {
            //Limpiar opciones antiguas
            $selector.empty();

            //iniciarlizar listado de opciones
            var optionList = '';

            //Generar listado de opciones
            $.each(rows, function (index, element) {
                optionList += '<option value="' + element.id + '">' + element.value + '</option>';
            });

            return $selector.append(optionList);
        }
    }
};



////funion js que hace los mismo que number_format
///INICIO DE FUNCIÓN number_format
function number_format(number, decimals, dec_point, thousands_sep) {
  //  discuss at: http://phpjs.org/functions/number_format/
  // original by: Jonas Raoni Soares Silva (http://www.jsfromhell.com)
  // improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
  // improved by: davook
  // improved by: Brett Zamir (http://brett-zamir.me)
  // improved by: Brett Zamir (http://brett-zamir.me)
  // improved by: Theriault
  // improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
  // bugfixed by: Michael White (http://getsprink.com)
  // bugfixed by: Benjamin Lupton
  // bugfixed by: Allan Jensen (http://www.winternet.no)
  // bugfixed by: Howard Yeend
  // bugfixed by: Diogo Resende
  // bugfixed by: Rival
  // bugfixed by: Brett Zamir (http://brett-zamir.me)
  //  revised by: Jonas Raoni Soares Silva (http://www.jsfromhell.com)
  //  revised by: Luke Smith (http://lucassmith.name)
  //    input by: Kheang Hok Chin (http://www.distantia.ca/)
  //    input by: Jay Klehr
  //    input by: Amir Habibi (http://www.residence-mixte.com/)
  //    input by: Amirouche
  //   example 1: number_format(1234.56);
  //   returns 1: '1,235'
  //   example 2: number_format(1234.56, 2, ',', ' ');
  //   returns 2: '1 234,56'
  //   example 3: number_format(1234.5678, 2, '.', '');
  //   returns 3: '1234.57'
  //   example 4: number_format(67, 2, ',', '.');
  //   returns 4: '67,00'
  //   example 5: number_format(1000);
  //   returns 5: '1,000'
  //   example 6: number_format(67.311, 2);
  //   returns 6: '67.31'
  //   example 7: number_format(1000.55, 1);
  //   returns 7: '1,000.6'
  //   example 8: number_format(67000, 5, ',', '.');
  //   returns 8: '67.000,00000'
  //   example 9: number_format(0.9, 0);
  //   returns 9: '1'
  //  example 10: number_format('1.20', 2);
  //  returns 10: '1.20'
  //  example 11: number_format('1.20', 4);
  //  returns 11: '1.2000'
  //  example 12: number_format('1.2000', 3);
  //  returns 12: '1.200'
  //  example 13: number_format('1 000,50', 2, '.', ' ');
  //  returns 13: '100 050.00'
  //  example 14: number_format(1e-8, 8, '.', '');
  //  returns 14: '0.00000001'

    number = (number + '')
    .replace(/[^0-9+\-Ee.]/g, '');
    var n = !isFinite(+number) ? 0 : +number,
    prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
    sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
    dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
    s = '',
    toFixedFix = function(n, prec) {
        var k = Math.pow(10, prec);
        return '' + (Math.round(n * k) / k)
        .toFixed(prec);
    };
    // Fix for IE parseFloat(0.55).toFixed(0) = 0;
    s = (prec ? toFixedFix(n, prec) : '' + Math.round(n))
    .split('.');
    if (s[0].length > 3) {
        s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
  }
  if ((s[1] || '')
    .length < prec) {
    s[1] = s[1] || '';
    s[1] += new Array(prec - s[1].length + 1)
      .join('0');
  }
  return s.join(dec);
}

///FIN DE FUNCION number_format

/**
* @author René Castaneda
* Como usar?: unicamente hacer un: $("#input_nombre").addClass('soloLetras'); 
* Si se quiere que permita otro(s) caracter(es) hacer lo siguiente
* $("#input_nombre").attr('extras', 'OTROS_CARACTERES');  
* $("#input_nombre").attr('extras', '-+/');
*/
///FUNCIONES PARA VALIDAR CARACTERES


//1-Función para permitir ingresar solo letras en un input
function soloLetras(e, masCaracteres) {
    key = e.keyCode || e.which;
    tecla = String.fromCharCode(key).toLowerCase();
    if (tecla == '\'' || tecla == '%' || tecla == '"' ) { return false;} 
    letras = " áéíóúabcdefghijklmnñopqrstuvwxyz" + masCaracteres;
    especiales = [8,37,39,46,13,9];
    // especiales = [13];

    tecla_especial = false
    for (var i in especiales) {
        if (key == especiales[i]) {
            tecla_especial = true;
            break;
        }
    }

    if (letras.indexOf(tecla) == -1 && !tecla_especial)
     {    return false; }
}

//2-Función para permitir ingresar solo numeros en un input
function soloNumeros(e, masCaracteres) {
    key = e.keyCode || e.which;
    tecla = String.fromCharCode(key).toLowerCase();

    letras = "0123456789" + masCaracteres;
    if(masCaracteres.indexOf('.') != -1){ 
     if (tecla == '\'' || tecla == '%' || tecla == '"' ) { return false;} 
    }
    else {
    if (tecla == '\'' || tecla == '%' || tecla == '"'  || tecla == '.' ) { return false;} 
    }
    especiales = [8,37,39,46,13,9];
   // especiales = [13];

    tecla_especial = false
    for (var i in especiales) {
        if (key == especiales[i]) {
            tecla_especial = true;
            break;
        }
    }

    if (letras.indexOf(tecla) == -1 && !tecla_especial)
      {   return false; }
}

//3-Función para permitir ingresar solo letras y numeros
function soloNumerosLetras(e, masCaracteres) {
    key = e.keyCode || e.which;
    tecla = String.fromCharCode(key).toLowerCase();
    letras = " áéíóúabcdefghijklmnñopqrstuvwxyz0123456789" + masCaracteres;
    if (tecla == '\'' || tecla == '%' || tecla == '"' ) { return false;} 
    especiales = [8,37,39,46,13,9];
    //especiales = [13];

    tecla_especial = false
    for (var i in especiales) {
        if (key == especiales[i]) {
            tecla_especial = true;
            break;
        }
    }

    if (letras.indexOf(tecla) == -1 && !tecla_especial)
       { return false; }
}

//4-Función para permitir ingresar solo letras y numeros
function soloPermitidos(e) {
    key = e.keyCode || e.which;
    tecla = String.fromCharCode(key).toLowerCase();
    letras = " áéíóúabcdefghijklmnñopqrstuvwxyz0123456789-/+*#@$%?¿=_.,[{}];:()!¡";
    if (tecla == '\'' || tecla == '"' ) { return false;} 
    especiales = [8,37,39,46,13,9];
    //especiales = [13];

    tecla_especial = false
    for (var i in especiales) {
        if (key == especiales[i]) {
            tecla_especial = true;
            break;
        }
    }

    if (letras.indexOf(tecla) == -1 && !tecla_especial)
       { return false; }
}

// 5- Función para permitir solo Decimales y delimitarlos
function soloDecimales(e, numDecimales) {
    key = e.keyCode || e.which;
    tecla = String.fromCharCode(key).toLowerCase();
    var masCaracteres = ".-";
    if(numDecimales == 0){
        masCaracteres = "";
    }
    letras = "0123456789" + masCaracteres;
    if(masCaracteres.indexOf('.') != -1){ 
     if (tecla == '\'' || tecla == '%' || tecla == '"' ) { return false;} 
    }
    else {
    if (tecla == '\'' || tecla == '%' || tecla == '"'  || tecla == '.' ) { return false;} 
    }
    especiales = [8,37,39,46,13,9];
   // especiales = [13];

    tecla_especial = false
    for (var i in especiales) {
        if (key == especiales[i]) {
            tecla_especial = true;
            break;
        }
    }

    if (letras.indexOf(tecla) == -1 && !tecla_especial)
      {   return false; }
    var text = e.target.value; 
    if ((text.indexOf('.') != -1) && (text.substring(text.indexOf('.')).length > numDecimales) && (event.which != 0 && event.which != 8) && (e.target.selectionStart >= text.length - numDecimales)) {
        return false;
    }
}

/////APLICACION DE LAS FUNCIONES ANTERIORES MEDIANTE UNA CLASE
/////AL INPUT SE PUEDE AÑADIR UNA ETIQUETA LLAMA EXTRA, PARA ACEPTAR MAS CARACTERES

    $(".soloLetras").live('keypress', function(e) {
        if ($(this).attr('extras')) {
            var masC = $(this).attr('extras');
            return soloLetras(e, masC);
        } else {
            return soloLetras(e, '');
        }
    });

    $(".soloNumeros").live('keypress', function(e) {
        if ($(this).attr('extras')) {
            var masC = $(this).attr('extras');
            return soloNumeros(e, masC);
        } else {
            return soloNumeros(e, '');
        }
    });

    $(".soloNumerosLetras").live('keypress', function(e) {
        if ($(this).attr('extras')) {
            var masC = $(this).attr('extras');
            return soloNumerosLetras(e, masC);
        } else {
            return soloNumerosLetras(e, '');
        }
    });

    $(".soloPermitidos").live('keypress', function(e) {
            return soloPermitidos(e);
    });
    
    $("body").on('keypress', '.soloDecimales', function (e) {
        
        var decimales = ($(this).attr('decimales'))?$(this).attr('decimales'):2;
        if(decimales > 0 ){
            $(this).numeric();
        }
        return soloDecimales(e, decimales);
    });

//@author René Castaneda
function crear_alerta(tipo,titulo,texto) {
    icono = 'picon icon16 entypo-icon-warning white';
    if( $.trim(tipo) == 'warning' ) { icono = 'picon icon16 entypo-icon-warning white'; }
    if( $.trim(tipo) == 'info' ) { icono = 'picon icon16 brocco-icon-info white'; }
    if( $.trim(tipo) == 'success' ) { icono = 'picon icon16 iconic-icon-check-alt white'; }
    if( $.trim(tipo) == 'error' ) { icono = 'picon icon24 typ-icon-cancel white'; }
    $('div.ui-pnotify').remove(); //si existe remover
   if(!$("div").hasClass('ui-pnotify'))
     $.pnotify({
        type: tipo,
        title: titulo,
        text: texto,
        icon: icono,
        opacity: 0.95,
        history: false,
        sticker: false
      });
  }

//@author René Castaneda 
//crear un confirm de jquery  (modal dialog)

/*
COMO USAR?
 $(".eliminar_registro").click(function(event) {
            event.preventDefault();
alerta_confirm(base_url + '/mantenimientos/eliminar_registro/52'
                ,'Realmente desea eliminar el registro?',
                'Es posible que se pierda información importante'
                );
  });
*/

function alerta_confirm(url_action,titulo,mensaje) {
$("body").append('<div id="dialog_alerta_confirm" style="display:none;" title="Confirmar"><p><span class="icon16  icomoon-icon-warning black" style="float:left; margin:0 7px 20px 0;"></span><span id="dialog_alerta_confirm_text"></span></p></div>');    
$("#dialog_alerta_confirm_text").html(mensaje);
$( "#dialog_alerta_confirm" ).dialog({
resizable: false, 
position: 'top',
draggable: false,
title: titulo,
show: {
effect: "slideDown",
duration: 400
}, hide: {
effect: "slideUp",
duration: 300
},
modal: true,
close: function(event, ui) { setTimeout(function(){ $("#dialog_alerta_confirm").remove(); }, 300); },
height: 150,
width: 250,
overlay: { backgroundColor: "#000", opacity: 0.5 },
buttons: {
"Aceptar": function() {
$( this ).dialog( "close" );
window.location.href = url_action;
$("#dialog_alerta_confirm").remove();
},
"Cancelar": function() {
$( this ).dialog( "close" );
setTimeout(function(){ $("#dialog_alerta_confirm").remove(); }, 300);
}
}
});

}

/**
*@author René Castaneda
* la funcion es siminar pero con la diferencia que no hace un redirect a una url 
* si no que manda a llamar a una funcion (como primer parametro), 
* dicha funcion recibe un parametro (como segundo parametro de la funcion si son varios se puede hacer en un array)
* y despues el titulo y en mensaje como los dos ultimos parametros de la funcion.
* ejemplo de uso:
      data[0]=id;
      data[1]=p5
alerta_confirm_ajax(eliminar_registro_ajax,data,'Confirmar eliminar registro','¿Realmente desea eliminar el registro seleccionado?');

**/
  function alerta_confirm_ajax(funcion_action,parametro,titulo,mensaje,funcion_action_cancelar,parametro_cancelar) {
    var accion_cancelar = 0;
    funcion_action_cancelar = typeof funcion_action_cancelar !== 'undefined' ? funcion_action_cancelar : null;
    parametro_cancelar = typeof parametro_cancelar !== 'undefined' ? parametro_cancelar :null;
    accion_cancelar = (funcion_action_cancelar)? 1:0;

    $("body").append('<div id="dialog_alerta_confirm" style="display:none;" title="Confirmar"><p><span class="icon16  icomoon-icon-warning black" style="float:left; margin:0 7px 20px 0;"></span><span id="dialog_alerta_confirm_text"></span></p></div>');    
    $("#dialog_alerta_confirm_text").html(mensaje);
    $( "#dialog_alerta_confirm" ).dialog({
      resizable: false, 
      position: 'top',
      draggable: false,
      title: titulo,
      show: {
        effect: "slideDown",
        duration: 400
      }, 
      hide: {
        effect: "slideUp",
      duration: 300
      },
      modal: true,
      close: function(event, ui) { setTimeout(function(){ $("#dialog_alerta_confirm").remove(); }, 300); },
      height: 150,
      width: 250,
      overlay: { backgroundColor: "#000", opacity: 0.5 },
      buttons: {
        "Aceptar": function() {
          $( this ).dialog( "close" );
          funcion_action(parametro);
          $("#dialog_alerta_confirm").remove();
        },
        "Cancelar": function() {
          $( this ).dialog( "close" );
            if (accion_cancelar == 1) {
              funcion_action_cancelar(parametro_cancelar);
            }
            setTimeout(function(){ $("#dialog_alerta_confirm").remove(); }, 300);
        }
      }
    });
  }

//para ir a un tab(pestaña) especifico unicamente se pasa el id del tab (id del link del tab)
  function saltar_tab(id_tab,tiempo) {
     event.preventDefault();
     setTimeout(function(){
   $("#"+id_tab).trigger( "click" );
  }, tiempo);
}

//anadir a un link la clase "ver_en_modal" para mostrar su contenido en un fancybox
jQuery(document).ready(function($) {
   $(".ver_en_modal").fancybox({
      width: '100%',
      openEffect  : 'elastic',
      closeEffect : 'elastic',
      href: $(this).attr('href'),
      type: 'iframe',
      height :'100%',
      maxHeight : 900,
      autoSize: false,
    });

   $(".ver_en_modal_ajax_").fancybox({
      openEffect  : 'elastic',
      closeEffect : 'elastic',
      href: $(this).attr('href')
    });


 $(".ver_en_modal_ajax_").live('mouseover', function(event){
  event.preventDefault();
  padre=$(this).parent().parent();
   codigo_fancy='$(".ver_en_modal_ajax_").fancybox({ openEffect  : "elastic", closeEffect : "elastic", href: $(this).attr("href") });';
   script_java = '<script type="text/javascript">'+ codigo_fancy +'</script>';
   div_fancy ='<div id="div_contenedor_fancy_script" style="display:none;" >'+ script_java +'</div>';
   if($("#div_contenedor_fancy_script").length<=0){ 
   $(padre).append(div_fancy);
   }
 }); 

    $(".ver_en_modal_ajax2").live('click', function (event) {
        event.preventDefault();
        url = $(this).attr('href');
        wait.start();
        $.ajax({
            url: url
        }).done(function (html) {
            wait.close();
            $.fancybox(html);
        });

    });
    
    $(".btn-cancelar").live("click", function (e) {
        e.preventDefault();

        var url = $(this).attr("href");

        alerta_confirm(url, 'Alerta confirmación', 'Los datos que insertaste no han sido guardados.<br /> ¿Éstas seguro que quieres regresar a la lista?');
    });
    
    
    $(".btn-eliminar").live("click", function (e) {
        e.preventDefault();

        var url = $(this).attr("href");

        alerta_confirm(url, 'Alerta confirmación', '¿Éstas seguro que quieres eliminar este registro?');
    });
    
   // $("#DataTables_Table_0_wrapper .tools .delete-row").live('click',function(event) {
   //   setTimeout(function(){
   //   $('.ui-dialog-buttonset button:first').attr('onclick',"esperar_error();");
   //   }, 1000);
   // });


  $('.btniframe').click( function (event) {
    event.preventDefault();
    $.fancybox({
      'width': '70%',
      'height' : '80%',
      'autoScale': true,
      'transitionIn': 'fade',
      'transitionOut': 'fade',
      'href':  $(this).attr('href'),
      'type': 'iframe'
    });

  });
// Codigo para controlar el panel de menu con la tecla "Alt"
  //   $(document).keyup(function(e){
  //   if($('#sidebar div').length>1){ 
  //     e.preventDefault();
  //     if(e.which==18){
  //       $(".collapseBtn > .tipR").trigger('click');
  //     }
  //   }
  // });

$('.hora').timeEntry({
      show24Hours: false,
      ampmPrefix: ' ',
      spinnerImage: urlj+'media/images/spinner.png',
      spinnerSize: [30, 30, 0],
      spinnerBigSize: [70, 50, 0],
      spinnerIncDecOnly: true,
      spinnerTexts: ['', '', '', 'Incrementar', 'Disminuir']
     
    });
$('.hora24').timeEntry({
      show24Hours: true,
      ampmPrefix: ' ',
      spinnerImage: urlj+'media/images/spinner.png',
      spinnerSize: [30, 30, 0],
      spinnerBigSize: [70, 50, 0],
      spinnerIncDecOnly: true,
      spinnerTexts: ['', '', '', 'Incrementar', 'Disminuir']
     
    });

// Para los proyectos de Asamblea

  $('.hora').css({'margin-bottom':'25px', 'width':'85px', 'height':'28px'});
  $('.timeEntry_control').css({'position':'absolute', 'margin-left':'-20px'});


  // CONVERTIR LO QUE SE ESCRIBA EN UN INPUT QUE POSEEA LA CLASE todo_mayuscula EN MAYUSCULA
  $('.todo_mayuscula').css('text-transform', 'uppercase');
  $(".todo_mayuscula").live('focus',function(event) {
    //text-transform:uppercase;
    $(this).css('text-transform', 'uppercase');
  });

  $(".todo_mayuscula").live('blur', function(event) {
    /* Act on the event */
    valor_ = $(this).val().toUpperCase(); 
    $(this).val(valor_);
  });
  
  
    $(".limitarCaracteres").live("keypress", function (e) {
        var maximo = $(this).attr("maxlength");
        if (maximo > 0) {
            limitarCaracteres(this);
        }
    });

    $(".limitarCaracteres").live("change", function (e) {
        var maximo = $(this).attr("maxlength");
        if (maximo > 0) {
            limitarCaracteres(this);
        }
    });

    function titulo_master_page() {
        var hdn_url_grid = ($.trim($("#hdn_url_grid").val()) != "") ? $("#hdn_url_grid").val() : window.location.pathname;
        $.ajax({
            type: 'POST',
            url: urlj + 'sistema/acceso/nom_menu_en_titulo',
            dataType: 'json',
            data: {url: hdn_url_grid},
            beforeSend: function () {
            },
            success: function (data) {
                console.log(data);
                if (data.titulo!='') {
                    $('.title_heading').html(data.titulo);
                    $('.title_grid_crud_grocery').html(data.titulo); //TITULO DE LAS GRIDS Y EL CRUD DEL GROCERY
                    $("#agreg").text("Agregar" + " " + data.titulo);
                }
            }
        });
    }
    

    titulo_master_page();

}); // End document.ready

// function esperar_error() {
//   setTimeout(function(){
//     crear_alerta('error','NOTA','El registro posee integridad referencial <br />&nbsp;No podrá ser eliminado.');
// }, 1701);
// }


/*
 * Valida los días de dos fechas, que el día de la fecha inicio y el día de la fecha fin sean
 * El primer y el último día del mes seleccioando. Adicional un flag por si se quiere restrigir
 * fechas futuras.
 * Devuelve true o false
 */
function validarDiasDelMes(fecha_ini, fecha_fin, flagFechaFutura){
        var fechaInicio = fecha_ini.split("-").reverse();
        var fechaFin    = fecha_fin.split("-").reverse();
        var fechaFinMes = new Date( (new Date(fechaFin[0], fechaFin[1],1))-1 );
        var fechaHoy   =   new Date();
        
        if( !flagFechaFutura && ( fechaFinMes.getFullYear()+fechaFinMes.getMonth() ) > ( fechaHoy.getFullYear()+fechaHoy.getMonth() ) ){
            crear_alerta('error','Error en las fechas','No se permiten fechas futuras');
            return false;
        }
        // Comprueba los días del mes
        if( (fechaInicio[0]+fechaInicio[1]) == (fechaFin[0]+fechaFin[1]) &&  Date.parse(fechaInicio[0]+'-'+fechaInicio[1]+'-'+'01')  ==  Date.parse(fechaInicio[0]+'-'+fechaInicio[1]+'-'+fechaInicio[2]) && fechaFinMes.getDate() == fechaFin[2]   ){
            $("#fecha_fin_error").text('');
            return true;
        } else {
            crear_alerta('error','Error en las fechas','Favor de seleccionar todos los días del mes.');
            return false;
        }
      } // End validarDiasDelMes
      

 /*
 @author René Castaneda
 id_fecha_inicio=id del input de la fecha inicio
 id_fecha_fin=id del input de la fecha fin
 texto_alerta=texto a mostrar al usuario (opcional)
 forma de uso:  $("#fecha_inicio,#fecha_fin").change(function(event) {  validar_fecha_inicio_fin('fecha_inicio','fecha_fin'); });
 */
 function validar_fecha_inicio_fin(id_fecha_inicio,id_fecha_fin,texto_alerta) { 
     texto_alerta = typeof texto_alerta !== 'undefined' ? texto_alerta : 'La fecha de inicio debe ser menor a la fecha fin';
     if($("#"+id_fecha_inicio).length >0 && $("#"+id_fecha_fin).length >0 ) {
         var fecha_inicio = $("#"+id_fecha_inicio).val();
         var fecha_fin = $("#"+id_fecha_fin).val();
         if(fecha_inicio != '' && fecha_fin != '') {
            
            if(fecha_inicio.indexOf('/') != -1){
                f_1 = fecha_inicio.split('/');
                f_2 = fecha_fin.split('/');
            } else {
                f_1 = fecha_inicio.split('-');
                f_2 = fecha_fin.split('-');
            }



            ////////////////////////////////////
            // SI SOLO SE TIENE MES Y ANIO
            ///////////////////////////////////
            if (f_1.length == 2) {
                f_1[2] = f_1[1];
                f_1[1] = f_1[0];
                f_1[0] = '01';
            }
            //alert(f_1[0]+" "+f_1[1]+" "+f_1[2]);
         

            if (f_2.length == 2) {
                f_2[2] = f_2[1];
                f_2[1] = f_2[0];
                f_2[0] = '01';
            }
            //alert(f_2[0]+" "+f_2[1]+" "+f_2[2]);
            
            /////////////////////////////////

             if (f_1[0].length==4 ) { //el año va en la primera posición
              fecha1 = f_1[0] + "-" + f_1[1] + "- " + f_1[2] + " 00:00:00";
              fecha2 = f_2[0] + "-" + f_2[1] + "- " + f_2[2] + " 11:59:00";
              //var f1 = new Date(f_1[0], f_1[1], f_1[2]); 
              //var f2 = new Date(f_2[0], f_2[1], f_2[2]);
             } else {
              fecha1 = f_1[2] + "-" + f_1[1] + "- " + f_1[0] + " 00:00:00";
              fecha2 = f_2[2] + "-" + f_2[1] + "- " + f_2[0] + " 11:59:00";
              //var f1 = new Date(f_1[2], f_1[1], f_1[0]); 
              //var f2 = new Date(f_2[2], f_2[1], f_2[0]);
             }
             var f1 = new Date(fecha1); 
             var f2 = new Date(fecha2);
              
             //alert(f1);
             //alert(f2);
             if( ( f2 < f1 ) ){
                 crear_alerta('error','Error en fechas',texto_alerta);
                 $("#"+id_fecha_inicio).val('');
                 $("#"+id_fecha_fin).val('');
             }
         }

     }
 }     

function goToList2() {
 // alert(list_url );
 alerta_confirm(list_url ,'Alerta confirmación',
 'Los datos que insertaste no han sido guardados.<br /> ¿Éstas seguro que quieres regresar a la lista?');
}

function validarEmail(correo){    
    emailRegex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;;
    
    if(!emailRegex.test(correo)){
        return false;
    }
    return true;
}

function validarPeriodo(fecha_ini,fecha_fin){   
    
    fecha_ini = fecha_ini.replace(/\//g, "-");
    fecha_fin = fecha_fin.replace(/\//g, "-");
    
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        return true;
    }
}

function limitarCaracteres(text){
    //asp.net textarea maxlength doesnt work; do it by hand
    var object = document.getElementById(text.id)  //get your object
    var maxlength = text.attributes["maxlength"].value; //set your value here (or add a parm and pass it in)
    if (object.value.length > maxlength)
    {
        object.focus(); //set focus to prevent jumping
        object.value = text.value.substring(0, maxlength); //truncate the value
        object.scrollTop = object.scrollHeight; //scroll to the end to prevent jumping
        return false;
    }
    return true;
}

//@Melbin Cruz
// Se utiliza en el manejo de errores de las peticiones Ajax
function exportarError(error){
    wait.close();
    var url = window.location.pathname; // Returns path only
    icono = 'picon icon24 typ-icon-cancel white';  
    if(!$("div").hasClass('ui-pnotify'))
   $.pnotify({
      type: "error",
      title: "Error",
      text: "Hubo un error en la operación<br><a id='printError' href='#' style='color: rgb(127, 255, 0); padding-left:20%; font-size:15px; '><b> &LT;&LT;Exportar Error&GT;&GT; </b></a>",
      icon: icono,
      opacity: 0.95,
      history: false,
      sticker: false
    });

  $("<form method='POST' target='_blank' action='"+window.gSateliteWhite.baseUrl('inicio/imprimirError')+"' id='formError' name='formError' style='display:none;'><input type='text' id='textoError' name='textoError'> <input type='text' id='urlError' name='urlError'></form>").appendTo('body');
  $("#urlError").val(url);
  $("#textoError").val(error);
  $("#printError").on('click',function(){
      $("#formError").submit();
  });

}

 /*
 @author René Castaneda
 @since 13-12-2017
 @Description: 
 Esta función debe colocarse para advertir del cierre de una pestaña o ventana del navegador cuya información no se ha guardado aun.
 */
function  alerta_cierre_navegador() {
  $('button[type="submit"]').live('click', function() { mostrar_alerta_cierre_navegador = false; });
  $('.es_boton_submit').live('click', function() { mostrar_alerta_cierre_navegador = false; });
  window.onbeforeunload = confirmExit;
  function confirmExit()
  {
    return mostrar_alerta_cierre_navegador ? "Ha intentado salir de esta pagina. Si ha realizado algun cambio en los campos sin hacer clic en el boton Guardar, los cambios se perderan. Seguro que desea salir de esta pagina? " : null;
  }
}


//FUNCIONALIDAD GENERICA Y DINAMICA PARA LOS BOTONES DE ANTERIOR Y SIGUIENTE
//added by René Castaneda
$('.boton_anterior_tab').click(function(event) {
$("[href='#"+$(this).parent().prev().attr('id')+"']").trigger('click');
});

$('.boton_siguiente_tab').click(function(event) {
$("[href='#"+$(this).parent().next().attr('id')+"']").trigger('click');
});

//FUNCIONALIDAD GENERICA Y DINAMICA PARA AGREGAR TOOLTIP
//added by René Castaneda
function crearToolTip(class_name, titulo_personalizado) {
  titulo_personalizado = typeof titulo_personalizado !== 'undefined' ? titulo_personalizado : ''; //preguntar si existe un titulo personalizado
  titulo_personalizado = ($.trim(titulo_personalizado) == '' )? $('.' + class_name + ':first').attr('title'):titulo_personalizado; //preguntar por el titulo (attr)
  titulo_personalizado = ($.trim(titulo_personalizado) == '' )? $('.' + class_name + ':first').attr('alt'):titulo_personalizado; //preguntar por el titulo (attr)
  titulo_personalizado = ($.trim(titulo_personalizado) == '' )? $('.' + class_name + ':first').text():titulo_personalizado; //sino existe titulo preguntar por el texto

  if (titulo_personalizado != '' ) {
        $('.' + class_name).qtip({
         content: {
          text: titulo_personalizado
        },
        position: {
          my: 'bottom center',
          at: 'top center',
          viewport: $(window)
        },
        style: {
          classes: 'ui-tooltip-tipsy'
        }
      });
  }

}

//FUNCIONALIDAD GENERICA PARA GENERAR UN MENSAJE FLOTANTE EN LA PANTALLA.
//added by René Castaneda 04/06/2018
function mostrar_mensaje_emergente(mensaje,tiempo_ocultar,normal) {
 //mensaje='<h1 style="padding-top: 25px; color: lime;"><b style="color: #71D260;">CORRELATIVO</b> # 125458</h1>';
$(".contenedor_msg_emergente").remove(); //SI EXISTE QUE  LO REMUEVA PARA INGRESAR EL NUEVO  
tiempo_ocultar = typeof tiempo_ocultar !== 'undefined' ? tiempo_ocultar :3500 ;

normal = typeof normal !== 'undefined' ? normal :1 ;

link_cerrar_mensaje='<a onclick="$(\'.contenedor_msg_emergente\').remove();" href="javascript: void(0);" style="position: absolute;margin-top: -2%;right: 1%;">Cerrar</a>';
//height:100%;right:0px !important;
ht='<div class="contenedor_msg_emergente" style="position: fixed;z-index:9999999;width:100%;display:none;">';
ht+='<div style="position: absolute;width:100%;height: 70px;padding-top: 0px;padding-bottom:25px;font-family: Segoe UI;font-size: 16px;color: #FFF;background-color:rgba(0,0,0,.68);text-align:center;">';
ht+= mensaje+link_cerrar_mensaje+'</div></div>';

$('body').prepend(ht);
if(normal==1){   $(".contenedor_msg_emergente").fadeIn();} 
else {  $(".contenedor_msg_emergente").show();  }
   // $(".contenedor_msg_emergente").show('slide');
  //  $(".contenedor_msg_emergente").show('puff', 1100);
    setTimeout(function() {
    $(".contenedor_msg_emergente").fadeOut();
   // $(".contenedor_msg_emergente").hide('puff', 2000);
     setTimeout(function() {
     $(".contenedor_msg_emergente").remove();
     },5500); 

    },tiempo_ocultar);
} 

/*
@author René Castaneda
@since 15-07-2019
@Description: 
Esta función para redondear numeros 
*/
function round_number(num, precision) {
    precision = typeof precision !== 'undefined' ? precision :2 ;
    return (+(Math.round(+(num + 'e' + precision)) + 'e' + -precision)).toFixed(precision);
}

/*
@author René Castaneda
@since 24-08-2019
@Description: 
Esta función para eliminar las cookies del navegador
*/
 function elminarCookie() { (function () { var cookies = document.cookie.split("; "); for (var c = 0; c < cookies.length; c++) { var d = window.location.hostname.split("."); while (d.length > 0) { var cookieBase = encodeURIComponent(cookies[c].split(";")[0].split("=")[0]) + '=; expires=Thu, 01-Jan-1970 00:00:01 GMT; domain=' + d.join('.') + ' ;path='; var p = location.pathname.split('/'); document.cookie = cookieBase + '/'; while (p.length > 0) { document.cookie = cookieBase + p.join('/'); p.pop(); }; d.shift(); } } })(); }

/*
@author Mario Marquez
@since 20-12-2019
@Description:
Esta función para generar datepicker segun el periodo contable
*/
function generarDatePickerPc(){
    $(".FechasContable").datepicker('destroy');
    $(".FechasContable").attr('readonly','readonly');
    $(".FechasContable").datepicker({
        showButtonPanel: false,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        // closeText: 'Cerrar',
        // currentText: 'Hoy',
    }).on("change", function(e) {
        e.preventDefault();

        var fechaCampo = this.value;
        var resultado = true;
        //Se valida la fecha contra los periodos

        if(fechaCampo!=""){
            var splitFecha = fechaCampo.split("-");
            var codigoPeriodo = splitFecha[2] + splitFecha[1]; 
            var indexMes = periodosContables.findIndex(x => x.codigo === codigoPeriodo);

            if(indexMes < 0){
                resultado = false;
                this.value = "";
                crear_alerta('info', 'Periodos Contables','Fecha fuera de los periodos contables');
            }
        }
        return resultado;
    });

    var validacion = 0;
    $(".FechasContable").each(function () {
        if($(this).val()!=""){
          periodo_fin = typeof periodo_fin !== 'undefined' ? periodo_fin :"0" ;
            var splitFecha = $(this).val().split("-");
            var codigoPeriodo = splitFecha[2] + splitFecha[1]; 
            var indexMes = periodosContables.findIndex(x => x.codigo === codigoPeriodo);

            if(indexMes < 0 && periodo_fin != "0" ){
                resultado = false;
                var ultimaFecha = periodosContables[periodosContables.length-1].periodo_fin.split("-").reverse().join("-");
                this.value = "";//ultimaFecha;
                crear_alerta('info', 'Periodos Contables','Fecha fuera de los periodos contables');
            }
        }
    });
}

function abrirVentana(url_carga) {
    window.open(url_carga, "_blank", "toolbar=yes,scrollbars=yes,resizable=yes,top=70,left=200,width=1200,height=500");
}