jQuery(document).ready(function($) {
	var pathArray = window.location.pathname.split( '/' );
	var urlj=url_base_proyecto;

	$("#slc_sucursal").select2();

	$("#usuario").blur(function(){
		$.ajax({
            dataType:'json',
            type:'POST',
            data:{usuario:$(this).val(), usuario_hid :$("#usuario_hid").val()},
            url: urlj+'sistema/acceso/validar_nombre_usuario',
            success: function(data){
            	$("#usuario_error").css("margin-top","-3%");
            	if(data.respuesta==1){
            		$("#usuario").addClass("existe");
            		$("#usuario_error").html("Usuario ya existe");	
            	} else if(data.respuesta==0){
            		$("#usuario").addClass("espacio");
            		$("#usuario_error").html("Espacios en blanco NO permitidos");	
            	}
            	 else {
            		$("#usuario").removeClass("existe espacio");
            		$("#usuario_error").html('');
            	}
            }
        })
	});

	$("#registrar").click(function(){
		// if($("#empleado").val()==0){
		// 	$("#empleado_error").html('Campo requerido');
		// }
		$("#frm-registrar").validate({
			ignore: '',
			rules: {
				usuario:{ required:true, minlength: 4},
				email:{ email:true},
				"rol[]":{ required:true},
				"empresa[]":{ required:true},				
			},
			// Specify the validation error messages
			messages: { 
				usuario: {
					minlength: 'Su usuario debe contener al menos 4 caracteres'
				},
				"rol[]": 'Debe seleccionar al menos un rol'
			},			
			errorPlacement: function (error, element) {
				var nombre=$(element).attr("id");
				$('#'+nombre+'_error').html(error);
			},
			submitHandler: function(form) {
				if($("#usuario").hasClass('existe') != true && $('#password_error').hasClass('short') != true /*$("#empleado").val()!=0 && */){
					form.submit();		
				}
			}
		});
	}); // End Registrar

	$('#password').keyup(function(){
		$('#password_error').html(checkStrength($('#password').val()));
	});

	$("body").on("change","#empresa", function (event) { 
		var empresa = $(this).val();
        if (empresa != null) {
            $.ajax({
                dataType: 'text',
                type: 'POST',
                url: urlj+'sistema/acceso/get_sucursales',
                data: {
                    empresa:empresa
                },
                beforeSend: function () {                    
                    wait.start();                
                },
                success: function(data){					
                    $("#slc_sucursal").html("");
                    $("#slc_sucursal").html(data);
                    $("#slc_sucursal").select2({placeholder: "Seleccione"});
                    wait.close();
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    //alert(xhr.status);
                    //alert(thrownError);
                    crear_alerta('error','Alerta','Ocurrio un error interno.');
                    wait.close();
                }
            });
        } else {
            $("#slc_sucursal").html('<option value=""></option>');            
            $("#slc_sucursal").select2({placeholder: "Seleccione"});
        }
	});	

	// $("#confirm_password").blur(function(){
	// 	$("#confirm_password_error").css("margin-top","-3%");
	// 	if($(this).val() === $("#password").val()){
	// 		$("#confirm_password_error").html("Iguales");	
	// 	} else {
	// 		$("#confirm_password_error").html("Distintas");	
	// 	}
	// });
}); // End Jquery function

function checkStrength(password){
	//initial strength
	var strength = 0;	

	$("#password_error").css("margin-top","-3%");
	//if the password length is less than 6, return message.
	if (password.length < 6) {
		if(password.length <1){
			return '';	
		} else {
			$('#password_error').removeClass();
			$('#password_error').addClass('short');
			return 'Muy corta';
		}
	}
	
	//length is ok, lets continue.
	//if length is 8 characters or more, increase strength value
	
	if (password.length > 6) strength += 1;
	//if password contains both lower and uppercase characters, increase strength value

	if (password.match(/^[a-zA-Z]+$/)) strength += 1;
	//if it has numbers and characters, increase strength value
	if (password.match(/([a-zA-Z])/) && password.match(/([0-9])/)) strength += 1;

	//if it has one special character, increase strength value
	if (password.match(/([!,%,&,@,#,$,^,*,?,_,~,;,''])/)) strength += 1;
	//if it has two special characters, increase strength value
	if (password.match(/(.*[!,%,&,@,#,$,^,*,?,_,~].*[!,",%,&,@,#,$,^,*,?,_,~])/)) strength += 1;
	
	//now we have calculated strength value, we can return messages
	
	//if value is less than 2
	if (strength < 2 ) {
		$('#password_error').removeClass();
		$('#password_error').addClass('weak');
		return 'Debil';
	} else if (strength == 2 ) {
		$('#password_error').removeClass();
		$('#password_error').addClass('good');
		return 'Buena';
	} else {
		$('#password_error').removeClass();
		$('#password_error').addClass('strong');
		return 'Fuerte';
	}
} // End checkStrength
