$(document).ready(function () {
    window.gSateliteWhite.jsSelect();
  
    $("#slcDocente").select2({
        placeholder: "Buscar Docente",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'registro_academico/procesos/get_empleados_like/1',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (empleado) {
                return {
                    empleado: empleado
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.empleado,
                        'text': item.emp_nombre
                    });
                });
               
                return {
                    results: myResults
                };
                
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('text');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#slcDocente").change(function(event) {
      var docente = $(this).val();
      var proyeccion = $("#slcProyeccion").val();
        if(docente>0){
            $.ajax({
                type:'post',
                dataType:'json',
                url:window.gSateliteWhite.baseUrl('registro_academico/procesos/cargar_select_grupos'),
                data:{docente: docente, proyeccion: proyeccion},
                beforeSend:function(){
                    $("#slcGrupo").attr("placeholder","Cargando..."); 
                    $("#slcGrupo").select2();
                },
                success:function(data){
                    wait.close();
                    $("#slcGrupo").attr("placeholder","Seleccione");
                    $("#slcGrupo").html(data);
                    $("#slcGrupo").select2();                     
                }
            });
      }else{
          $("#slcGrupo option:first").attr('selected','selected');
          $("#slcGrupo").html('<option value=""></option>');
      } 
    });
    
    /*Busqueda*/
    $("#btnConsultar").click(function(){
       var proyeccion = $("#slcProyeccion").val();
       var docente = $("#slcDocente").val();
       var grupo = $("#slcGrupo").val();
       
       $("#dv_contenedor_alumnos").hide('slide',{
                direction:'right'
            },
            400,function(){
                $.ajax({
                   type:'post',
                   url:window.gSateliteWhite.baseUrl('registro_academico/procesos/traslado_grupo'),
                   data:{proyeccion:proyeccion,docente:docente, grupo:grupo},
                   beforeSend:function(){
                       wait.start();
                   },
                   success:function(result){
                       wait.close();
                       var oTabla = $("#tblAlumnos").dataTable();
                       
                       oTabla.fnDestroy();
                       $("#tbContenedorAlumnos").html(result);
                       
                       $("#dv_contenedor_alumnos").show("slide", {
			                    direction: 'left'
                        }, 500);
                       aplidarDataTable('tblAlumnos');
                   }
                });
            }
        );
    });


    $(".exportar").click(function(event){
      event.preventDefault();
        $("#frm_cierre").submit();
      
    });
  

  
}); //End jQuery

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

