$(document).ready(function(){
    gSateliteWhite.jsSelect();

     $("#slcDocente, #slcDocente_dst").select2({
        placeholder: "Buscar Docente",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'registro_academico/procesos/get_empleados_like/1',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (empleado) {
                return {
                    empleado: empleado
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.empleado,
                        'text': item.emp_nombre
                    });
                });
               
                return {
                    results: myResults
                };
                
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('text');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#slcDocente").change(function(event) {
      var docente = $(this).val();
      var proyeccion = $("#slcProyeccion").val();
        if(docente>0){
            $.ajax({
                type:'post',
                dataType:'json',
                url:window.gSateliteWhite.baseUrl('registro_academico/procesos/cargar_select_grupos'),
                data:{docente:docente, proyeccion:proyeccion},
                beforeSend:function(){
                    $("#slcGrupo").attr("placeholder","Cargando..."); 
                    $("#slcGrupo").select2();
                },
                success:function(data){
                    wait.close();
                    $("#slcGrupo").attr("placeholder","Seleccione");
                    $("#slcGrupo").html(data);
                    $("#slcGrupo option[value=0]").val('');
                    $("#slcGrupo").select2();                     
                }
            });
      }else{
          $("#slcGrupo option:first").attr('selected','selected');
          $("#slcGrupo").html('<option value=""></option>');
      } 
    });

    $("#slcProyeccion").change(function(event) {
        $("#slcGrupo option:first").attr('selected','selected');
        $("#slcGrupo").html('<option value=""></option>');
        if($("#slcDocente").val()>0){
            $(".docente span").text('');
            $("#slcDocente").val('');
            $("#slcDocente").attr('placeholder', 'Seleccione');
        }
        $("#slcGrupo").select2();
    });

    $("#slcProyeccion_dst").change(function(event) {
        $("#slcGrupo_dst option:first").attr('selected','selected');
        $("#slcGrupo_dst").html('<option value=""></option>');
    });

    $("#slcGrupo").change(function(event) {
        var grupo = $(this).val();
        if(grupo>0){
            $("#grupo_sel").val(grupo);
        }else{
            $("#grupo_sel").val('');
        }
    });

    $("#slcDocente_dst").change(function(event) {
      var docente = $(this).val();
      var proyeccion = $("#slcProyeccion_dst").val();
        if(docente>0){
            $.ajax({
                type:'post',
                dataType:'json',
                url:window.gSateliteWhite.baseUrl('registro_academico/procesos/cargar_select_grupos'),
                data:{docente:docente, proyeccion:proyeccion},
                beforeSend:function(){
                    $("#slcGrupo_dst").attr("placeholder","Cargando..."); 
                    $("#slcGrupo").select2();
                },
                success:function(data){
                    wait.close();
                    $("#slcGrupo_dst").attr("placeholder","Seleccione");
                    $("#slcGrupo_dst").html(data);
                    $("#slcGrupo_dst option[value=0]").val('');
                    $("#slcGrupo_dst").select2();                     
                }
            });
      }else{
          $("#slcGrupo_dst option:first").attr('selected','selected');
          $("#slcGrupo_dst").html('<option value=""></option>');
      } 
    });


   $("#ver_alumno").click(function(event) {
        event.preventDefault();

        proyeccion = $("#slcProyeccion").val();
        docente = $('#slcDocente').val();
        grupo = $('#slcGrupo').val();
    
        if(proyeccion>0 && docente>0 && grupo>0){
            wait.start();
            $("#filtro_area_error").text('');
            
           $.ajax({ 
            type: 'post',
            url: urlj+"registro_academico/procesos/ver_alumnos_trs",
            data: {proyeccion :proyeccion, docente :docente, grupo: grupo},
            success: function(data){
                wait.close();
                var oTable = $('#datagried1').dataTable();  
                oTable.fnDestroy();
                $("#docs").html(data);
                $('#datagried1').dataTable({
                    "iDisplayLength":10,
                    "bAutoWidth": false,
                    "aLengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
                    'oLanguage':{
                        'sLengthMenu': 'Mostrando _MENU_ entradas'
                    }
                });
                $('#datagried1').css('width', '95%');
                $('#datagried1').show('slide');
                /*area = $("#filtro_area").val();
                emp  = $("#emp_origen").val();
                $("#area_origen").val(area);
                $("#origen_emp").val(emp);*/
            }
            });
        }else{
           crear_alerta('error', 'Error', 'Favor de verificar campos requeridos');
        }
   });

    $("#filtro_area").change(function() {
        flt_area = $('#filtro_area').val();
        if(flt_area>0){
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj+'activo/nuevo/empleados_oficinasxasig',
                data: {area_sel:flt_area},
                beforeSend: function(){
                    $("#emp_origen").attr("placeholder","Cargando..."); 
                    $("#emp_origen").select2();
                },
                success: function(data){
                    $("#emp_origen").attr("placeholder","Seleccione");
                    $("#emp_origen").html(data.drop);
                    $("#emp_origen option[value=0]").val('');
                    $("#emp_origen").select2();
                                
                }
            });
        }else{
            $("#emp_origen option:first").attr('selected','selected');
            $("#emp_origen").html('<option value=""></option>');
           
        }
    });

   $("#area").change(function() {
        area = $('#area').val();
        if(area>0){
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: gSateliteWhite.baseUrl('activo/nuevo/empleados_oficinas'),
                data: {area_sel:area},
                beforeSend: function(){
                    $("#emp_id").attr("placeholder","Cargando..."); 
                    $("#emp_id").select2();
                },
                success: function(data){
                    $("#emp_id").attr("placeholder","Seleccione");
                    $("#emp_id").html(data.drop);
                    $("#emp_id option[value=0]").val('');
                    $("#emp_id").select2();
                                
                }
            });
        }else{
            $("#emp_id option:first").attr('selected','selected');
            $("#emp_id").html('<option value=""></option>');
           
        }
    });

    var array=[];
    $("#agregar").click(function(event){ 
        var array=[];

        $("#ids_selected").val('');
        $(".check_act").each(function() {
            if($(this).is(':checked')){
                array.push($(this).val());
                $("#ids_selected").val(array);
            }
        });

        if(array.length>0){
            wait.start();
            $.ajax({ 
                type: 'post',
                url: urlj+"registro_academico/procesos/ver_alumnos_trs",
                data: {array :array},
                success: function(data){
                    wait.close();
                    var oTable = $('#datagried').dataTable();  
                    oTable.fnDestroy();
                    $("#destino").html(data);
                    $('#datagried').dataTable({
                        "iDisplayLength":10,
                        "bAutoWidth": false,
                        "aLengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
                        'oLanguage':{
                            'sLengthMenu': 'Mostrando _MENU_ entradas'
                        }
                    });
                    $('#datagried').css('width', '95%');
                    $('#datagried').show('slide');
                }
            });
        }else{
            crear_alerta('error', 'Error','Debe seleccionar al menos un alumno.');
        }

    });

    $("#registrar").click(function(){
        $("#disparar").trigger("click");
        validarformulario();
    });

    $(".eliminar_trs").live('click', function(event) {
      $(this).parent().parent().remove();
    });

 

    $(".check_act").live('change', function(event) {
            var oTable = $('#datagried').dataTable();  
                oTable.fnDestroy();
        $("table#datagried tbody#destino").html('');
        $('#datagried').dataTable({"sPaginationType": "full_numbers"});
    });

    $('#datagried1').on( 'draw.dt', function (event) {
        applyStyle();
    });

    $("#guardar, #guardar_volver").click(function(event){
        event.preventDefault();
        proyeccion = $('#slcProyeccion').val();
        grupo = $('#grupo_sel').val();
        proyeccion_dst = $('#slcProyeccion_dst').val();
        grupo_dst = $('#slcGrupo_dst').val();
        
        validar_evaluaciones(proyeccion, grupo, proyeccion_dst, grupo_dst);
    });

    
    $("#frm_solicitud").validate({
        ignore: "", 
        rules:{
            slcProyeccion:{ required:true, min:1 },
            slcDocente:{ required:true, min:1 },
            slcGrupo:{ required:true, min:1 },
            slcProyeccion_dst:{ required:true, min:1 },
            slcDocente_dst:{ required:true, min:1 },
            slcGrupo_dst:{ required:true, min:1 },
        }, 
        messages: { 
            slcProyeccion: "Campo requerido",
            slcDocente: "Campo requerido",
            slcGrupo: "Campo requerido",
            slcProyeccion_dst: "Campo requerido",
            slcDocente_dst: "Campo requerido",
            slcGrupo_dst:  "Campo requerido"
        },
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').html(error);
            if($("table#datagried tbody#destino tr .alumno_sel").length<=0){
                crear_alerta('error', 'Error', 'Verifique los alumnos a trasladar');
            }
        },
        submitHandler: function(form){  
            if ( ($('#slcProyeccion').val() == $('#slcProyeccion_dst').val()) && ($('#grupo_sel').val() == $('#slcGrupo_dst').val()) ){
                crear_alerta('error', 'Error', 'No es posible trasladar un alumno a un mismo grupo, en la misma proyección');
                return false;
            }

            if($("table#datagried tbody#destino tr .alumno_sel").length<=0){
                crear_alerta('error', 'Error', 'Verifique los alumnos a trasladar');
            }else{
                form.submit();   
            }
        } 
    });

    $("#cancelar").click(function(event){
        alerta_confirm_ajax(regresar,data,'Confirmar eliminar registro','Los datos que insertaste no han sido guardados. ¿Éstas seguro que quieres regresar a la lista?');
    });

});//End jQuery

function regresar(){
    window.location.href=urlj+'registro_academico/procesos/traslado_grupo';
}

function applyStyle() {
    $(":checkbox").iButton({
        labelOn: "<span class='icon16 icomoon-icon-checkmark-2 white'></span>",
        labelOff: "<span class='icon16 icomoon-icon-cancel-3 white'></span>",
    });
}

function checkArrays( arrA, arrB ){
    //check if lengths are different
    if(arrA.length !== arrB.length) return false;
    var cA = arrA.slice().sort().join(","); 
    var cB = arrB.slice().sort().join(",");
    return cA===cB;
}

function existe_sesion() { 
    $.ajax({
        url: window.gSateliteWhite.baseUrl('activo/nuevo/existe_sesion'),
        type: 'post',
        dataType: 'json',
        data: {
            'nada': 'nada'
        },
        success: function(data) {
            if (data.existepdf == true ) { //aplica
                location.reload();
            }
        }
    });
 }

function existe_peticion() {
  setTimeout(function () {existe_sesion();}, 10);
}

function realizar_traslado(){
    $("#frm_solicitud").submit();
}

function validar_evaluaciones(proyeccion, grupo, proyeccion_dst, grupo_dst){
    $.ajax({
        url: window.gSateliteWhite.baseUrl('registro_academico/procesos/validar_evaluaciones'),
        type: 'post',
        data: {proyeccion: proyeccion, grupo: grupo, proyeccion_dst: proyeccion_dst, grupo_dst: grupo_dst},
        success: function(data){
            console.log(data);
            if(data==1){
                alerta_confirm_ajax(realizar_traslado,null,'Confirmar traslado de alumno(s)','El grupo de destino no posee evaluaciones configuradas. <br> Si el alumno posee notas, éstas no serán trasladadas. ¿Estas seguro de trasladar a los alumnos seleccionados?');
            }else if(data == 2){
                alerta_confirm_ajax(realizar_traslado,null,'Confirmar traslado de alumno(s)','La configuración de evaluaciones para ambos grupos no coincide. <br> Si el alumno posee notas, éstas no serán trasladadas. ¿Estas seguro de trasladar a los alumnos seleccionados?');
            }else{
                $("#frm_solicitud").submit();
            }
        }
    });
}