$(document).ready(function($){
    $(".botones_export").hide();
    $("select").select2();

    $("#slc_alumno").select2({
        placeholder: "Buscar Alumno",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'registro_academico/procesos/get_alumnos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (alumno) {
                return {
                    alumno: alumno
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.alumno,
                        'text': item.alm_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('text');
                callback({id: valor, text: texto});
            }
        }
    });
 
    $("#buscar").click(function(event){
        event.preventDefault();
        $(".botones_export").hide();
        var alumn = $("#slc_alumno").val();
        var modal = $("#slc_modality").val();
        var frecu = $("#slc_frecuency").val();
        var grupo = $("#slc_grupo_acad").val();
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'registro_academico/consultas/rpt_modalidad_estudio/1',
            data: {
                grupo_acad: grupo,
                frencuency: frecu,
                estudiante: alumn,
                modalities: modal,
                tipo: ""
            },
            beforeSend: function(){
                wait.start();
            },
            success: function(data){
                console.log(data);
                $("#contenido").html(data.html);
                if(data.filas > 0){
                    $("#frencuency").val(frecu);
                    $("#estudiante").val(alumn);
                    $("#grupo_acad").val(grupo);
                    $("#modalities").val(modal);
                    $(".botones_export").show('slow');
                }
                wait.close();
            }
        });
    });

});
