$(document).ready(function() {
    $(".fecha").datepicker({dateFormat: 'yy-mm-dd',changeMonth: true, changeYear: true});
    $(".fecha").mask("9999-99-99");
    $(".fecha").attr('placeholder',"yyyy-mm-dd");

    $(".exportar").hide();

    $("#tblCerrados").dataTable();

    $(document).on('change', '#txtfechainicio', function(event) {
        validar_fecha_inicio_fin('txtfechainicio', 'txtfechacierre');
    });

    $(document).on('change', '#txtfechacierre', function(event) {
        validar_fecha_inicio_fin('txtfechainicio', 'txtfechacierre');
    });

    $(document).on('click', '#btnConsultar', function(event) {
        event.preventDefault();

        var fechaInicio = $('#txtfechainicio').val();
        var fechaCierre = $('#txtfechacierre').val();

        if (fechaInicio != '' && fechaCierre != '') {
            $.ajax({
                 url:  urlj + "registro_academico/consultas/reporte_grupos_cerrados",
                 type: 'POST',
                 data: {fechaInicio: fechaInicio, fechaCierre: fechaCierre},
                 dataType: 'text',
                 beforeSend: function () {
                     wait.start('Cargando..');
                 },
                 error: function (xhr, status, error){
                  exportarError(xhr.responseText);
                  wait.close();
              },
                  success: function (text) {

                    // console.log(json);
                    $('.exportar').show('slow');
                    $("#tblCerrados").dataTable();
                    $('#tblCerrados').html(text);
                    aplidarDataTable('tblCerrados');
                    $("#exportar").val(1);
                    wait.close();
              }

            });
        } else {
            crear_alerta('error','Información', 'Debe filtrar la información a buscar');
        }

    });

    $("#exportar").val(0);

    $(".exportar").click(function(event){
      event.preventDefault();
        var fechaDesde = $('#txtfechainicio').val();
        var fechaHasta = $('#txtfechacierre').val();

        $('#filtro_fechaInicio').val(fechaDesde);
        $('#filtro_fechaCierre').val(fechaHasta);
      if($("#exportar").val()==1){
        $("#frm_cierre").submit();
      }else{
        crear_alerta('error','Información', 'Debe filtrar la información a buscar');
      }
    });

});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}