$(document).ready(function () {
    $('#slcArea').select2();
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");
    
    $(".duplicar_grupo").live('click',function(event) {
        event.preventDefault();

        nombre=$(this).data('nombre'); 
        $("#txtNombre").text(nombre);

        id_grupo=$(this).attr('href').split('/'); 
        $("#id_pyc_duplicar").val(id_grupo.pop());

        $.ajax({
           type:'post',
           url:window.gSateliteWhite.baseUrl('registro_academico/mantenimientos/ajax_duplicar_proyeccion'),
           data:{proyeccion: $("#id_pyc_duplicar").val()},
           dataType: 'json',
           beforeSend:function(){
               wait.start();
           },
           success:function(result){
               wait.close();
               console.log(result);

               $("#txtNombre").val(result.pyc.pyc_nombre);
               $("#slcArea").html(result.areas);
               $("#slcArea").select2();
               $("#txtninscritos").val(result.cantidad);
               $("#txtFecha_ini").val(result.fecha_inicio);
               $("#txtFecha_fin").val(result.fecha_fin);
               $("#txtFecha_max").val(result.fecha_max_nota);
               $("#txtFecha_ins").val(result.fecha_ins);

               $("#txtFecha_ini_gra").val(result.fecha_inicio);
               $("#txtFecha_fin_gra").val(result.fecha_fin);
           }
        });

        $("#mostrar_modal").trigger('click');
            
      });


    /*Busqueda*/
    $("#btnConsultar").click(function(){
      var fecha_ini = $("#txtFechaIni").val();
      var fecha_fin = $("#txtFechaFin").val();
       
      if(fecha_ini !='' && fecha_fin != ''){
           if(!verifica_fecha(fecha_ini,fecha_fin)){
               crear_alerta('error','Proyecciones','Verifique las fechas del período.');
               return false;
           }
      }

      $("#dv_contenedor_proyeccion").hide('slide',{
                direction:'right'
            },
            400,function(){
                $.ajax({
                   type:'post',
                   url:window.gSateliteWhite.baseUrl('registro_academico/mantenimientos/proyecciones'),
                   data:{fecha_ini:fecha_ini,fecha_fin:fecha_fin},
                   beforeSend:function(){
                       wait.start();
                   },
                   success:function(result){
                       wait.close();
                       var oTabla = $("#tblProyeccion").dataTable();
                       
                       oTabla.fnDestroy();
                       $("#tbContenedorProyeccion").html(result);
                       
                       $("#dv_contenedor_proyeccion").show("slide", {
			                    direction: 'left'
                        }, 500);
                       aplidarDataTable('tblProyeccion');
                   }
                });
            }
        );
   });
  
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#fecha_fin_error").text('');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#fecha_fin").addClass('error');
        $("#fecha_fin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
        return true;
    }
}

  function duplicar_proyeccion() {

    cantidad=$("#cantidad_pyc").val();
    id_pyc =  $("#id_pyc_duplicar").val();
    area = $("#slcArea").val();
    nombre = $("#txtNombre").val();
    fechaIni = $("#txtFecha_ini").val();
    fechaFin = $("#txtFecha_fin").val();
    fecha_max = $("#txtFecha_max").val();
    fecha_ins = $("#txtFecha_ins").val();

    fechaIni_gra = $("#txtFecha_ini_gra").val();
    fechaFin_gra = $("#txtFecha_fin_gra").val();

    if(fechaIni !='' && fechaFin != ''){
      if(!verifica_fecha(fechaIni,fechaFin)){
        crear_alerta('error','Proyecciones','Verifique las fechas del período.');
        return false;
      }
    }

    if(fechaIni_gra !='' && fechaFin_gra != ''){
      if(!verifica_fecha(fechaIni_gra,fechaFin_gra)){
        crear_alerta('error','Proyecciones','Verifique las fechas del período.');
        return false;
      }
    }

    if(area>0 && fechaIni !='' && fechaFin !='' && fecha_max !='' && fecha_ins !='' && nombre !='' && fechaIni_gra !='' &&  fechaFin_gra !='' ){
      $.ajax({
          type: 'POST',
          dataType: 'json',
          url:  window.gSateliteWhite.baseUrl('registro_academico/mantenimientos/duplicar_proyeccion'),
          data: {'id_pyc':id_pyc, 'area': area, 'fechaIni': fechaIni, 'fechaFin':fechaFin, 'fecha_max': fecha_max, 'fecha_ins': fecha_ins, 'nombre': nombre, 'fechaIni_gra': fechaIni_gra, 'fechaFin_gra': fechaFin_gra},
          success: function (data) {
            
              location.reload();
            
          }
      });
    }else{
      crear_alerta('error', 'Campos requeridos', 'Verifique los campos requeridos (*)');
    }
  }