$(document).ready(function(){
    $("#slcProyeccion, #slcArea, #slcPeriodos, #tipo_nota, #grupos").select2();

    $("#crear").click(function(event){
        event.preventDefault();
        if(validar_notas()){
            $("#frm_notas").submit();
        }
    });

    $("#slcProyeccion").change(function(event) {
        var proyeccion = $(this).val();
  
        if(proyeccion>0){
              wait.start();
              $.ajax({
                type: "POST",
                dataType:'json',
                url: urlj+"registro_academico/procesos/get_info_proyeccion",
                data: {proyeccion: proyeccion },
                beforeSend: function(){
  
                  $("#slcArea").attr("placeholder", "Cargando...");
                  $("#slcArea").select2();
                },
                success: function(data){
  
                  $("#slcArea").html(data.areas);
                  $("#slcArea").attr("placeholder", "Seleccione");
                  $("#slcArea").select2();

                  $("[name=notas_tb] tbody").html('<tr class="odd"><td valign="top" colspan="6" class="dataTables_empty">No se encontraron registros</td></tr>');
                  
                  cargar_Alumnos(proyeccion);

                  wait.close();
                }
              });
        }else{
 
            $("[name=notas_tb] tbody").html('<tr class="odd"><td valign="top" colspan="6" class="dataTables_empty">No se encontraron registros</td></tr>');

            $("#slcArea").attr("placeholder", "Seleccione");
            $("#slcArea").html('<option value=""></option>');
            $("#slcArea option:first").attr('selected','selected');
            $("#slcArea").select2();
        }
    });


    $("#slcArea").on('change',function(event){
        var area = $(this).val();

        $("#lblArea").text($("#slcArea option:selected").text());
    });

    $("#grupos").live('change',function(event){
        var grupo = $(this).val();
        var area = $("#slcArea").val();

        if(grupo>0){
            $.ajax({
                type:'POST',
                dataType:'json',
                url: urlj+'registro_academico/procesos/cargar_peridoxgrupo',
                data: {
                    grupo:grupo,
                    area:area
                },
                cache:false,
                beforeSend: function(){
                    $("#slcPeriodos").attr("placeholder", "Cargando...");
                    $("#slcPeriodos").select2();
                },
                error: function(jqXHR, textStatus, errorThrown){
                    console.log(jqXHR);
                    console.log(textStatus);
                    console.log(errorThrown);
                    crear_alerta('error','Error', 'Ocurrió un error al cargar los periodos');
                },
                success: function(data){
                    if(data != ''){
                       $("#slcPeriodos").attr("placeholder", "Seleccione");
                       $("#slcPeriodos").html(data.opt);
                       $("#slcPeriodos").select2();
                       $("#lblNivel").text(data.nivel);
                       $("#dt_grupo").html(data.detalle);
                       $("#lblFrecuencia").text(data.frecuencia);
                       $("#lblArea").text(data.area);
                       $("#lblAula").text(data.aula);
                       $("#lblModulo").text(data.modulo);
                       $("#lblSeccion").text(data.seccion);
                       $("#lblMinimo").text(data.minimo);
                       $("#lblMaximo").text(data.maximo);
                       $("#lblFecha_ini").text(data.inicio);
                       $("#lblFecha_fin").text(data.fin);
                       $("#lblLimite").text(data.limite);
                    }
                }
            });
        }else{
            $("#slcPeriodos, #tipo_nota").attr("placeholder", "Seleccione");
            $("#slcPeriodos option:first, #tipo_nota option:first").attr('selected','selected');
            $("#slcPeriodos, #tipo_nota").select2();
            $("#lblNivel").text('');
            $("#dt_grupo").html('');
            $("#lblFrecuencia, #lblArea, #lblAula, #lblModulo, #lblSeccion, #lblMinimo, #lblMaximo, #lblFecha_ini, #lblFecha_fin, #lblLimite").text('');
        }          
    });

    $("#slcPeriodos").change(function(event){
        var periodo = $(this).val();
        var grupo = $("#grupos").val();
       
        if(periodo>0){
            $.ajax({
                type:'POST',
                dataType:'json',
                url: urlj+'registro_academico/procesos/cargar_notasxperiodo',
                data: {grupo:grupo, periodo:periodo},
                cache:false,
                beforeSend: function(){
                    $("#tipo_nota").attr("placeholder", "Cargando...");
                    $("#tipo_nota").select2();
                },
                error: function(jqXHR, textStatus, errorThrown){
                    console.log(jqXHR);
                    console.log(textStatus);
                    console.log(errorThrown);
                    crear_alerta('error','Error', 'Ocurrió un error al cargar los las evaluaciones');
                },
                success: function(data){
                    if(data != ''){
                       $("#tipo_nota").attr("placeholder", "Seleccione");
                       $("#tipo_nota").html(data.opt);
                       $("#tipo_nota").select2();
                    }
                }
            });
        }else{
            $("#tipo_nota").attr("placeholder", "Seleccione");
            $("#tipo_nota option:first").attr('selected','selected');
            $("#tipo_nota").select2();
        }
          
    });

    

    $("#btnConsultar").click(function(event){
        var area = $("#slcArea").val();
        var grupo = $("#grupos").val();
        var periodo = $("#slcPeriodos").val();
        var nota = $("#tipo_nota").val();
        var valid = $("#valid").val();
        var proyeccion = $("#slcProyeccion").val();

        if(area>0 && proyeccion>0 && grupo>0 && periodo>0 && nota>=0){
            wait.start();
            $.ajax({
                type:'POST',
                dataType:'json',
                url: urlj+'registro_academico/procesos/procesar_notas',
                data: {area:area, grupo:grupo, periodo:periodo, nota:nota, valid: valid, proyeccion: proyeccion},
                cache:false,
                error: function(jqXHR, textStatus, errorThrown){
                    wait.close();
                    console.log(jqXHR);
                    console.log(textStatus);
                    console.log(errorThrown);
                    crear_alerta('error','Error', 'Ocurrió un error al cargar a los alumnos');
                },
                success: function(data){
                    wait.close();
                    if(data != ''){
                       var fecha_ini = data.fecha_ini;
                       var fecha_fin = data.fecha_fin;
                       var fecha_limite = data.limite;
                       var actual = data.actual;
                       var valida = data.valida;
                       var fecha_maxima = data.maxima;
                       
                       $("#detalle_notas").html(data.html);

                        if( ((fecha_ini!='' && fecha_fin!='') || fecha_maxima!='') && valida<=0){
                            verifica_fecha(fecha_ini, fecha_fin, actual, fecha_limite, fecha_maxima);
                        }else{
                            if(valida<=0){
                                verifica_fecha(null, null, actual, fecha_limite);
                            }
                        }
                    }
                }
            }); 
        }else{
            crear_alerta('error', 'Ingreso de notas', 'Debe agregar los campos requeridos.');
        }
    });

    $(".nota_det").live('focusout', function(event){
        var cont = $(this).data('cont');
        var nota = $(this).val();
        var alumno = $(this).data('alm');


        if(parseFloat(nota)>10){
            crear_alerta('error', 'Ingreso de notas', 'La nota no debe ser mayor a 10');
        }else{
            var porc = $("#nota_"+cont).data('porc');
            var prom = $("#promedio_sin_"+alumno).val();

            if(nota>0){
                general = ((porc/100)*parseFloat(nota)); //+parseFloat(prom)
            }else{
                general = parseFloat(prom);
            }
            $("#prom_"+cont).val(general);

            var total=0;
            $('.prom_'+alumno).each(function( key, value) {
                total += parseFloat($(this).val());
            });

            $("#promedio_final_"+alumno).val(number_format(total, $("#decimales").val()));   
        }
    });


    $(document).on("keypress", ".TabOnEnter" , function(e){
        if( e.keyCode ==  13 )
        {
           var nextElement = $('[tabindex="' + (this.tabIndex+1)  + '"]');
           console.log( this , nextElement ); 
           if(nextElement.length )
             nextElement.focus()
           else
             $('[tabindex="1"]').focus();  
        }   
    });
   

        // Carga de dropdown grupos //
        function cargar_Alumnos(proyeccion){
            if(proyeccion>0){
                $.ajax({
                    type:'POST',
                    datatype: 'json',
                    url:urlj+"registro_academico/procesos/cargar_GruposxAreaAcademica",
                    data:{
                        id: proyeccion,
                        dropdown:1, 
                        dct:$("#dct_id").val()
                    },
                    beforeSend: function(){
                    $("#grupos").attr("placeholder", "Cargando...");
                    $("#grupos").select2();
                    },
                    error: function(jqXHR, textStatus, errorThrown){
                        console.log(jqXHR);
                        console.log(textStatus);
                        console.log(errorThrown);
                        crear_alerta('error','Error', 'Ocurrió un error al cargar los las evaluaciones');
                    },
                    success: function(data){
                        if(data != ''){
                            $("#grupos").attr("placeholder", "Seleccione");
                            $("#grupos").html(data).select2();
                        }
                    }
                });
            }else{
                $("#grupos, #slcPeriodos, #tipo_nota").attr("placeholder", "Seleccione");
                $("#grupos option:first").attr('selected','selected');
                $("#slcPeriodos option:first").attr('selected','selected');
                $("#tipo_nota option:first").attr('selected','selected');
                $("#grupos, #slcPeriodos, #tipo_nota").select2();
                $("#lblNivel").text('');
            }
               
        }

   

    function validar_notas(){
        var cont = 0;
       
        $(".nota_det").each(function(index){
            if(parseFloat($(this).val()) > 0){
                cont++;
            }
        });

        if(cont==0){
            crear_alerta('error', 'Ingreso de notas', 'Debe ingresar al menos una nota.');
            return false;
        }else{
            return true;
        }

    }

  
 
}); // End jQuery

   


    function verifica_fecha(fecha_ini, fecha_fin, actual, fecha_limite, fecha_max=null){

        //Convierto la fecha a Y-m-d
        var fecha_act = actual.split("-").reverse().join("-");
        var fecha_limit = fecha_limite.split("-").reverse().join("-");

        if(fecha_max!=null){
            var fecha_maxima = fecha_max.split("-").reverse().join("-");
        }

        if(fecha_ini!=null && fecha_fin!=null && fecha_max==''){
            var fecha_i = fecha_ini.split("-").reverse().join("-");
            var fecha_f = fecha_fin.split("-").reverse().join("-");

            if(Date.parse(fecha_act) > Date.parse(fecha_f) ) {
                $(".nota_det").attr('readonly', 'readonly');
                $("#crear").attr('disabled', true);
                crear_alerta('error', 'Procesamiento de notas', 'La el rango fechas de evaluación ha finalizado');
                return false;
            }else if(Date.parse(fecha_act) < Date.parse(fecha_i)){
                $(".nota_det").attr('readonly', 'readonly');
                $("#crear").attr('disabled', true);
                crear_alerta('error', 'Procesamiento de notas', 'La el rango fechas de evaluación no ha iniciado');
                return false;
            }else{
                $(".nota_det").removeAttr('readonly');
                return true;
            }
        }else if(fecha_limite!='' || fecha_max!=null){
            if(Date.parse(fecha_act) > Date.parse(fecha_limit) || Date.parse(fecha_act) > Date.parse(fecha_maxima) ) {
                $(".nota_det").attr('readonly', 'readonly');
                $("#crear").attr('disabled', true);
                crear_alerta('error', 'Procesamiento de notas', 'La fecha límite para ingresar notas ha vencido');
                return false;
            }else{
               $(".nota_det").removeAttr('readonly');
               return true; 
            }
        }



    }