$(document).ready(function() {
    var url = url_base_proyecto;

    $('select').select2();
    $('#tblSustituto').dataTable();
    $('#modal_sustituto select').select2('disable');
    $('#modal_sustituto input').attr('disabled', 'disabled');
    $('#modal_sustituto textarea').attr('disabled', 'disabled');

    $(document).on('change', '#slcArea', function() {
        if($('#slcArea').val()>0) {

            var url_ajax = url + "registro_academico/procesos/ajax_areaxnivel";
            $.ajax({
                     url: url_ajax,
                     type: 'POST',
                     data: {area: $(this).val()},
                     dataType: 'json',
                     beforeSend: function () {
                         wait.start('Cargando..');
                     },
                     error: function (xhr, status, error){
                      exportarError(xhr.responseText);
                      wait.close();
                  },
                      success: function (json) {
                        // console.log(json);
                        $('#slcNivel').html(json.niveles);
                        $('#slcNivel').val(0);
                        $('#slcNivel').select2();
                        $('#slcGrupo').val(0);
                        $('#slcGrupo').select2();
                        wait.close();
                  }

              });
        } else {
            $('#slcNivel').val(0);
            $('#slcNivel').select2();
            $('#slcGrupo').val(0);
            $('#slcGrupo').select2();
        }
    });

    $(document).on('change', '#slcNivel', function() {
        if($('#slcArea').val()>0) {

            var url_ajax = url + "registro_academico/procesos/ajax_obtener_grupos";
            $.ajax({
                     url: url_ajax,
                     type: 'POST',
                     data: {area: $("#slcArea").val(), nivel: $("#slcNivel").val()},
                     dataType: 'json',
                     beforeSend: function () {
                         wait.start('Cargando..');
                     },
                     error: function (xhr, status, error){
                      exportarError(xhr.responseText);
                      wait.close();
                  },
                      success: function (json) {
                        // console.log(json);
                        $('#slcGrupo').html(json.grupos);
                        
                        wait.close();
                  }

              });
        }
    });

    $(document).on('click', '#btnConsultar', function(event) {
        event.preventDefault();
        var url_ajax = url + "registro_academico/procesos/maestro_sustituto";

        area = $('#slcArea').val();
        nivel = $('#slcNivel').val();
        grupo = $('#slcGrupo').val();

        $("#dv_contenedor_sustituto").hide('slide',{
                    direction:'right'
                },
                400,function(){
                    $.ajax({
                       url: url_ajax,
                         type: 'POST',
                         data: {area: area, nivel:nivel, grupo:grupo},
                         dataType: 'text',
                         beforeSend: function () {
                             wait.start('Cargando..');
                         },
                         error: function (xhr, status, error){
                          exportarError(xhr.responseText);
                          wait.close();
                      },
                          success: function (json) {
                            // console.log(json);
                            wait.close();
                            var oTabla = $("#tblSustituto").dataTable();
                       
                            oTabla.fnDestroy();
                           // Hasta aqi termine y debo comprobar qe se muestre la tabla
                           $("#tbContenedorSustituto").html(json);
                           $("#dv_contenedor_sustituto").show("slide", {
                                    direction: 'left'
                            }, 400);
            
                            aplidarDataTable('tblSustituto');

                      }
                    });
                }
        );

    });

    $(document).on("click", ".maestro_sustituto",function(event) {
    //$(".maestro_sustituto").live("click", function(event) {
        event.preventDefault();

        id_stm=$(this).attr('href').split('#'); 
        // $("#id_stm_susituto").val(id_stm.pop());
        // console.log(id_stm[1]);
        $.ajax({
             url: url + "registro_academico/procesos/ajax_info_sustituto",
             type: 'POST',
             data: {sustituto: id_stm[1]},
             dataType: 'json',
             beforeSend: function () {
                 wait.start('Cargando..');
             },
             error: function (xhr, status, error){
              exportarError(xhr.responseText);
              wait.close();
          },
              success: function (json) {
                // console.log(json);
                
                // Información de los datos del sustituto
                $("#slcAreaSustituto").val(json.grupo[0].ard_nombre);
                $("#slcGrupoSustituto").val(json.grupo[0].gra_nombre);
                $("#lbldocente").text(json.sustituto[0].dct_emp_nombre+' '+json.sustituto[0].dct_emp_apellido);
                $("#lblcurso").text(json.grupo[0].mod_nombre);
                $("#lblPeriodo").text(json.fecha_inicio+'/'+json.fecha_fin);
                $("#lbldocenteSustituto").val(json.sustituto[0].dcts_emp_nombre+' '+json.sustituto[0].dcts_emp_apellido);
                $("#txtfechainicio").val(json.sustituto[0].fechaInicio);
                $("#txtfechafin").val(json.sustituto[0].fechaFin);
                $("#slcHorarioSustituir").val(json.horario);
                $("#lblAlumnosInscrito").text(json.n_alumnos);
                $("#lblSeccion").text(json.grupo[0].scc_nombre != null ? json.grupo[0].scc_nombre: '');
                $("#lblAula").text(json.grupo[0].aul_nombre != null ? json.grupo[0].aul_nombre: '');
                $("#txtObservacion").val(json.sustituto[0].stm_observacion);
                if (json.sustituto[0].stm_tipo_pago == 0) {
                    $("#slctipopago").val('No Pago');
                    // $("#slctipopago").select2();
                } else if (json.sustituto[0].stm_tipo_pago == 1) {
                    $("#slctipopago").val('Según Grupo');
                    // $("#slctipopago").select2(0);
                } else {
                    $("#slctipopago").val('Escalafón');
                    // $("#slctipopago").select2();
                }

                var estado_button = ($("#txtdocentetitular").prop("checked"))?1:0;
                if (json.sustituto[0].stm_pago_titular != estado_button) {
                    $("#txtdocentetitular").iButton('toggle')
                } 

                var estado_buttonsustituto = ($("#txtdocentesustituto").prop("checked"))?1:0;
                if (json.sustituto[0].stm_pago_sustituto != estado_buttonsustituto) {
                    $("#txtdocentesustituto").iButton('toggle');
                    $("#div_planillas").show();
                    $("#slcTipoPlanilla").val(json.sustituto[0].tpl_nombre);
                    $("#slcPlanilla").val(json.sustituto[0].pla_fecha_inicio+'-'+json.sustituto[0].pla_fecha_fin);
                } else{
                    $("#div_planillas").hide();
                }



                wait.close();
          }

      });

        // Para mostrar el modal de ver maestro sustituto
        $("#mostrar_modal").trigger('click');
    });


    $('#div_tipopago').hide();
    $('#div_escalafon').hide();

    $(".fecha").datepicker({dateFormat: 'yy-mm-dd',changeMonth: true, changeYear: true});
    $(".fecha").mask("9999-99-99");
    $(".fecha").attr('placeholder',"yyyy-mm-dd");

    $("#txtdocentesustituto").iButton({                
        change: function (element) {
            if (element.is(':checked')) {
                $('#div_tipopago').show('slow');
                $('#txtpagosustituto').val(1);
            } else {
                $('#div_escalafon').hide('slow');
                $('#div_tipopago').hide('slow');
                $('#txtpagosustituto').val(0);
            }
        }
    });
    $("#txtdocentetitular").iButton({                
        change: function (element) {
            if (element.is(':checked')) {
                $('#txtpagotitular').val(1);
            } else {
                $('#txtpagotitular').val(0);
            }
        }
    });

    //Cambia el nombre de OFF = NO y ON = SI
    $(".ibutton-container label").each(function(index, el) {
        if ($(this).text().trim() =='OFF') {
            $(this).text('NO');
        }else if($(this).text().trim() =='ON'){
            $(this).text('SI');
        }
    });

    $("#txtdocentetitular").iButton({
        change: function (element) {
            if (element.is(':checked')) {
                $('#div_tipopago').css('display', '');
            } else {
                $("#div_tipopago").css('display', 'none');
            }
        }
    });

});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}