$(document).ready(function () {
    var url = url_base_proyecto;

    setTimeout(function() {
        $("#slcProyeccion").trigger("change");
        $("#slcGrupo").trigger("change");
    }, 500);

    $("#frmAsistencia").validate({
        ignore: "",
        rules: {
            slcProyeccion: {required: true},
            slcGrupo: {required: true},
            fechaAsistencia: {required:true}
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });

    $('select').select2();
    $("#fechaAsistencia").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
    $("#fechaAsistencia").mask("99-99-9999");
    $("#fechaAsistencia").attr('placeholder',"dd-mm-yyyy");

    $(document).on('click','#btnG1',function(){
        $("#btnCrear").val(1);
    });

    $(document).on('click','#btnG2',function(){
        $("#btnCrear").val(2);
    });

    $(document).on('change', '#slcProyeccion', function(event) {
        var url_ajax = url_base_proyecto + 'registro_academico/procesos/ajax_area_grupo';
        $('#lblFrecuencia').text('');
        $('#lblSeccion').text('');
        $('#lblDocente').text('');

        if($("#slcProyeccion").val()>0){
          $.ajax({
               url: url_ajax,
               type: 'POST',
               data: {proyeccion: $(this).val()},
               dataType: 'json',
               beforeSend: function () {
                   wait.start('Cargando..');
               },
               error: function (xhr, status, error){
                exportarError(xhr.responseText);
                wait.close();
            },
                success: function (json) {
                    $('#iptarea').val(json.ard_proyeccion);
                    $('#slcGrupo').html(json.option);                  
                    wait.close();
            }
          });
        }else{
            $("#slcGrupo").attr("placeholder", "Seleccione");
            $("#slcGrupo option:first").attr('selected','selected');
            $("#slcGrupo").select2();
        }


    });

    $(document).on('change', '#slcGrupo', function(event) {
        var url_ajax = url_base_proyecto + 'registro_academico/procesos/ajax_grupo_asistencia';

        if ($(this).val()>0) {
            $.ajax({
                 url: url_ajax,
                 type: 'POST',
                 data: {grado: $(this).val()},
                 dataType: 'json',
                 beforeSend: function () {
                     wait.start('Cargando..');
                 },
                 error: function (xhr, status, error){
                  exportarError(xhr.responseText);
                  wait.close();
              },
                  success: function (json) {
                      // console.log(json);
                      html = '';
                      if (json.docente === null) {
                        $('#lblDocente').text('');

                      } else {
                        $('#lblDocente').text(json.docente);
                        $('#txtdocente').val(json.docenteId);
                      }
                      if (json.seccion === null) {
                        $('#lblSeccion').text('');
                      } else {
                        $('#lblSeccion').text(json.seccion);
                      }
                      var cantiH = json.frecuencia.length;
    
                      palabra = json.frecuencia[0].dia_nombre[0]+'-'+json.frecuencia[cantiH-1].dia_nombre[0];
                      palabra += ' '+json.frecuencia[0].hrg_inicio+' a '+json.frecuencia[0].hrg_fin;

                      $('#lblFrecuencia').text(palabra);

                      // $('#tbContenedorAsistencia').html(json.alumnos);
                      if (json.alumnos.length>0) {
                        for (var i = 0; i < json.alumnos.length; i++) {
                            html += '<tr>';
                            html += '<td><input type="hidden" name="idAlm[]" value="'+json.alumnos[i].alm_id+'">'+json.alumnos[i].alm_codigo+'</td>';
                            html += '<td>'+json.alumnos[i].alm_nombre+' '+json.alumnos[i].alm_apellido+'</td>';
                            html += '<td style="text-align:center;"><input type="checkbox" id="'+i+'" value="1" checked class="styled cbxAsistencia" /><input type="hidden" id="cbx_'+i+'" name="asistencia[]" value="1"></td>';
                            html += '<td><div id="div_'+i+'" style="display:none;text-align:center;"><select name="inasistencia[]" id="slc'+i+'" class="slcInasistencia" placeholder="Seleccione" style="display:none;width:200px;">'+json.inasistencia+'</select></div></td>';
                            html += '</tr>';
                         } 
                      } else {
                        html = '<tr><td colspan="4" style="text-align:center;">No Se encontrarón Resultados</td></tr>';
                      }
                      $('#tbContenedorAsistencia').html(html);
                      $('.slcInasistencia').select2();
                      wait.close();
              }

          });
        } else {
            $('#lblFrecuencia').text('');
            $('#lblSeccion').text('');
            $('#lblDocente').text('')
        }

    });

    // Live en change checkbox
    $('.cbxAsistencia').live('click', function(event) {
        if (this.checked) {
            // console.log($(this).attr("id"));
            $("#cbx_"+$(this).attr("id")).val(1);
            $('#div_'+$(this).attr("id")).css('display','none');
        }
        else {
            // console.log($(this).attr("id"));
            $("#cbx_"+$(this).attr("id")).val(0);
            $('#div_'+$(this).attr("id")).css('display','');
        }

    });

    // Cambio de Select
    $('#fechaAsistencia').blur(function(event) {
        setTimeout(function() {
            // console.log($('#fechaAsistencia').val());
            var url_ajax = url_base_proyecto + 'registro_academico/procesos/validar_fecha_asistencia';
            if ($('#slcProyeccion').val()>0 && $('#slcGrupo').val()>0) {
                $.ajax({
                     url: url_ajax,
                     type: 'POST',
                     data: {fechaAsistencia: $('#fechaAsistencia').val(), proyeccion: $('#slcProyeccion').val(), grupo: $('#slcGrupo').val()},
                     dataType: 'json',
                     beforeSend: function () {
                         wait.start('Cargando..');
                     },
                     error: function (xhr, status, error){
                      exportarError(xhr.responseText);
                      wait.close();
                     },
                      success: function (json) {
                          
                        if (json.registro.length) {
                            
                        } else {
                            $('#fechaAsistencia').val('');
                            crear_alerta('warning','Día Incorrecto','El día de asistencia debe estar en el rango asignado');
                        }
                        if (json.asistencias>0) {
                            $('#fechaAsistencia').val('');
                            crear_alerta('error','Error Asistencia','Ya se ha registrado una asistencia este día');
                        }

                        wait.close();
                  }

              });
            } else {
                crear_alerta('error', 'Error', 'Debe seleccionar una Proyección y Grupo');
                $('#fechaAsistencia').val('')
            }
        }, 1000);
    });

});