$(document).ready(function () {
    window.gSateliteWhite.jsSelect();
    $("#btnagregar").hide();
    $("#btninscripcion").hide();


    $("#slcAlumno").select2({
        placeholder: "Buscar Alumno",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'registro_academico/procesos/get_alumnos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (alumno) {
                return {
                    alumno: alumno
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.alumno,
                        'text': item.alm_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('text');
                callback({id: valor, text: texto});
            }
        }
    });
    
    /*Busqueda*/
    $("#btnConsultar").click(function(){
        var alumno = $("#slcAlumno").val();

        if(alumno>0){
            $("#slcAlumno_error").text('');

            $("#dv_contenedor_evaluacion").hide('slide',{
                direction:'right'
            },
            400,function(){
                $.ajax({
                    type:'post',
                    url:window.gSateliteWhite.baseUrl('registro_academico/procesos/inscripcion'),
                    data:{alumno:alumno},
                    beforeSend:function(){
                        wait.start();
                    },
                    success:function(result){
                        wait.close();
                        var oTabla = $("#tblEvaluacion").dataTable();

                        oTabla.fnDestroy();
                        $("#tbContenedorEvaluacion").html(result);

                        $("#dv_contenedor_evaluacion").show("slide", {
                            direction: 'left'
                        }, 500);
                        aplicarDataTable('tblEvaluacion');

                        $("#btnagregar").attr('href', urlj+'registro_academico/procesos/alumno_inscripcion/0/'+alumno);
                        $("#btnagregar").show('slow');
                        $("#btninscripcion").attr('href', urlj+'registro_academico/procesos/impresion_inscripcion/'+alumno);
                        $("#btninscripcion").show('slow');

                    }
                });
            }
            );

        }else{
            $("#slcAlumno_error").text('Campo requerido');
            $("#btnagregar").hide();
        }
    });

    $("#slcAlumno").change(function(event) {
        var alm = $(this).val();
        if(alm<=0){
            $("#btnagregar").hide();
        }
    });

    $(".asociarAlumno").fancybox({
        width: '40%',
        height: '55%',
        autoSize: false,
        closeClick: false,
        closeBtn : false,
        helpers: {
            overlay: { closeClick: false }
        },
        type: 'inline',
        beforeLoad: function () {
            var base = $(this.element[0]).attr('data-lxp');
            var nomb = $(this.element[0]).attr('data-nme');
            var moda = $(this.element[0]).attr('data-mod');
            $("#id_lxp").val(base);
            $("#nombreMod").val(nomb);
            $('#slcMod').val(moda);
            $('#slcMod').select2();
            $("#divSlcMod .select2-search-choice-close").css("display","none");
        },
        beforeClose: function () {
            $("#id_lxp").val('');
            $("#nombreMod").val('');
        },
        afterClose: function() {
            $("#btnConsultar").trigger('click');
        }
    });

    $(".listaCuotas").fancybox({
        width: '45%',
        height: '55%',
        autoSize: false,
        closeClick: false,
        closeBtn : false,
        helpers: {
            overlay: { closeClick: false }
        },
        type: 'inline',
        beforeLoad: function () {
            var lxp = $(this.element[0]).attr('data-lxp');
            var listas = llenarlistas(lxp);

        },
        beforeClose: function () {
            $("#lxp_id").val("");
        },
        afterClose: function() {
            $("#btnConsultar").trigger('click');
        }
    });

    $("#btnUpdtLits").click(function(event){
        event.preventDefault();
        alerta_confirm_ajax(actaliza_cmc, 1,'Confirmación de Actualización','¿Realmente desea actualizar los valores cálculos?');
    });

    $("body").on("change", "#slcMod", function(){
        let lxp = $("#id_lxp").val();
        let mod = $("#slcMod").val();
        if (lxp != "") {
            $.ajax({
                type:'post',
                url: urlj + 'registro_academico/procesos/chng_mod_stud',
                data:{
                    lxp:lxp,
                    mod:mod
                },
                beforeSend:function(){
                    wait.start();
                },
                success:function(result){
                    wait.close();
                }
            });
        }
    });


});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function llenarlistas(lxp) {
    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: urlj + 'registro_academico/procesos/getListaCuota',
        data:{idlxp:lxp},
        success:function(data){
            $("#lxp_id").val(lxp);
            if (data.error > 0) {
                crear_alerta('error','','No hay cuotas que apliquen');
                setTimeout(function() {$.fancybox.close();}, 1000);
            } else {
                $('#nwlista').html(data.select);
                $('#nwlista').select2();
                $("#divSlcLip .select2-search-choice-close").css("display","none");
            }
        }
    });
}

function actaliza_cmc() {
    var lxp = $("#lxp_id").val();
    var tlp = $("#nwlista").val();
    if (lxp > 0 && tlp > 0) {
        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: urlj + 'registro_academico/procesos/actualiza_lip_cmc',
            data:{
                idlxp:lxp,
                idtlp:tlp
            },
            beforeSend:function(){
                wait.start();
            },
            success:function(data){
                wait.close();
                if (data.error > 0) {
                    crear_alerta('error','','No existe un precio definido en la lista');
                    return false;
                } else {
                    crear_alerta('success','','Se aplicó el cambio correctamente');
                    setTimeout(function() {$.fancybox.close();}, 1000);
                }
            }
        });
    } else {
        crear_alerta("error", "", "No se reconocen los datos a procesar");
        return false;
    }
}