jQuery(document).ready(function () {
    window.gSateliteWhite.jsSelect();
    $('select option[value=0]').val('');
    $('select').select2();

    /************************ Carga de grados según área seleccionada ***************/
    $("#slcProyeccion").on("change",function(event) {
      var id_area = $("#slcProyeccion option:selected").data('ard_id');
      var area = $("#slcProyeccion option:selected").data('area');
      var proyeccion = $("#slcProyeccion").val();
      $("#hdnArea").val(id_area);
      $("#lblArea").text(area);

        if(proyeccion>0){
            $.ajax({
                type: "POST",
                url : 'mostrar_grados_area',
                data : {area: id_area, proyeccion: proyeccion},
                beforeSend: function(){
                    $("#slcGrado").attr("placeholder", "Cargando...");
                    $("#slcGrado").select2();
                },
                success: function(data) {
                    $("#slcGrado").attr("placeholder", "Seleccione");
                    $("#slcGrado").html(data);
                    $("#slcGrado").select2();
                }
            });
        }else{
            $("#slcGrado").html('<option value=""></option>')
            $("#slcGrado").attr("placeholder", "Seleccione");
            $("#slcGrado option:first").attr('selected','selected');
            $("#slcGrado").select2();
        }
    });

    /************************ Carga de alumnos según grado seleccionado ***************/
    $("#slcGrado").change(function(event){
        var grado= $(this).val();
        var area = $("#hdnArea").val();

        $("#grupo_error").text('');

        if(area>0 && grado > 0){
            $.ajax({
              type: 'POST',
              dataType: 'json',
              url:  window.gSateliteWhite.baseUrl('registro_academico/consultas/cargar_alumnos_grupo'),
              data: {area: area, grado: grado},
              beforeSend: function(){
                $("#slcAlumnos").attr("placeholder", "Cargando...");
                $("#slcAlumnos").select2();
              },
              success: function (data) {
                $("#slcAlumnos").attr("placeholder", "Seleccione");
                $("#slcAlumnos").html(data);
                $("#slcAlumnos").select2();
              }
            });
        }else{
            $("#slcAlumnos").html('<option value=""></option>')
            $("#slcAlumnos").attr("placeholder", "Seleccione");
            $("#slcAlumnos option:first").attr('selected','selected');
            $("#slcAlumnos").select2();
         
        }

    });


    $("#ver_detalle").click(function (event)
    {
        var proyeccion = $("#slcProyeccion").val();
        var grado = $("#slcGrado").val();
        var alumnos = $("#slcAlumnos").val();
      
        if(proyeccion>0 || grado>0 ){
            consultarAjax(proyeccion, grado, alumnos);
        }else{
            crear_alerta('error','Error', 'Debe seleccionar la información a filtrar');
        }
    }); // Fin if consultar_datos

   
    $("#excel_en").click(function(event){
        event.preventDefault();
        tipo=$(this).attr('value');
        $("#tipo_reporte").val(tipo)
        $("#excel").trigger('click');
    });

    $("#exportar").val(0);

    $(".exportar").click(function(event){
        event.preventDefault();
        if($("#exportar").val()==1){
            $("#frm-plan").submit();
        }else{
            crear_alerta('error','Información', 'Debe filtrar la información a buscar');
        }
    });

}); // End jQuery

function consultarAjax(proyeccion, grado, alumnos) {
    wait.start();
   
    $("#contenedor_consulta").hide("slide", {
        direction: 'right'
    }, 400, function () { // Después de ocultar div enviar el ajax
        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: urlj+'registro_academico/consultas/informe_notas',
            data: {proyeccion: proyeccion, grado: grado, alumnos: alumnos},
            success: function (data) {
                $("#contenedor_consulta").html(data.resultado);
                wait.close();
                $("#ver_detalle").removeAttr('disabled');
                $("#exportar").val(1);

                $("#filtro_proyeccion").val(data.proyeccion);
                $("#filtro_grado").val(data.grado);
                $("#filtro_alumnos").val(data.alumnos);

                $("#contenedor_consulta").show("slide", {
                    direction: 'left'
                }, 500);
            },
            error: function (xhr, status, error) {
                wait.close();
                console.log(xhr);
                console.log(status);
                console.log(error);
                crear_alerta('error', 'Error', 'Hubo un problema al realizar la operación');
            }
        });
    });
}