jQuery(document).ready(function(){
    window.gSateliteWhite.jsSelect();

     $("#slcAlumno").select2({
        placeholder: "Buscar Alumno",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'registro_academico/procesos/get_alumnos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (alumno) {
                return {
                    alumno: alumno
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.alumno,
                        'text': item.alm_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('text');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#slcAlumno").change(function(event) {
      var alumno = $(this).val();
      if(alumno>0){
        $.ajax({
            url: 'get_fecha_alumno',
            type: 'POST',
            data: {alumno: alumno}, 
            success:function(data) {
              $("#lblFecha").text(data);
              wait.close();
            }
          });
      }else{
        $("#lblFecha").text('');
      }
    });

    $("#buscar").click(function() {
      $('#tipo_reporte').val(0);
      if($("#slcAlumno").val()>0){
        wait.start();
          $.ajax({
            url: 'historial_alumno',
            type: 'POST',
            dataType: 'json',
            data: {slcAlumno: $("#slcAlumno").val()}, 
            success:function(data) {
              var oTable = $('#datagried1').dataTable();
              oTable.fnDestroy();

              $("#consulta_table").html(data);

              $('#datagried1').dataTable({
                  "iDisplayLength":10,
                  "bAutoWidth": false,
                  "aLengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
                  'oLanguage':{
                      'sLengthMenu': 'Mostrando _MENU_ entradas'
                  }
              });
              wait.close();
              $(".botones_export_print").show('slow');
            }
          });
      }else{
        crear_alerta('error', 'Alumno', 'El alumno es requerido');
      }
      
    });


}); // End jQuery

