$(document).ready(function(){
  window.gSateliteWhite.jsSelect();
  $("#slcArea, #slcEstado").select2();
      
  $("#direccion").val(1);
  $("#guardar").mouseover(function(){
    $("#direccion").val(1);
    if($("#txtNombre").val().trim()!='') {
      validar_nombre();
    } 
  });

  $("#guardar_volver").mouseover(function(){
    $("#direccion").val(2);
    if($("#txtNombre").val().trim()!='') {
      validar_nombre();
    }   
  });

  $("#txtNombre").on('blur', function(event) {
     validar_nombre();
  });

  $("#txtOrden").on('blur', function(event) {
    if($(this).val()>0 && $("#txtOrden").val()!=''){
      validar_orden();
    }
  });

  $("#slcArea").change(function(event) {
    if($(this).val()>0 && $("#txtOrden").val()!=''){
      validar_orden();
    }
  });

	 // Validar campos y enviar POST
    $("#frm-nuevo_modulo").validate({
      ignore:"",
      rules: {
          txtNombre: {required:true },
          slcArea: {required:true, min: 1},
          slcEstado:{required:"#slcEstado:visible", min:0}
      },
      messages:{
          txtNombre: "El campo Nombre es requerido",
          slcArea: "El campo Área es requerido",
      },
      ignore: ".select2-container",
      errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
      },
      submitHandler: function(form){ 
        if($("#slcEstado").val() != '' && $("#error_nombre").val()<=0){
          form.submit(); 
        }
      }  
		});

  $("#slcEstado").change(function(event){
    if( $("#slcEstado").val()!=''){
      $("#slcEstado_error").text('');
    }
   
  });

  $("#cancel").click(function(event){
      event.preventDefault();
      alerta_confirm(urlj+'registro_academico/mantenimientos/grados','Alerta de confirmación','Los datos que ingresaste no han sido guardados. <br> ¿Éstas seguro que quieres regresar a la lista?');
  });
}); // End document ready

  function validar_nombre(){
      nombre=$("#txtNombre").val();
      id=$("#id_grd").val();

      $.ajax({
        dataType:'json',
        type:'post',
        data:{nombre:nombre,id:id},
        url: urlj+'registro_academico/mantenimientos/validar_grado',
        success: function(data){
         
          if (data.id > 0) {
            $("#txtNombre").val('');
            crear_alerta('error', 'Nombre único', 'El campo Nombre del grado debe ser único');
            $("#error_nombre").val(1);
            return false;
          }else{
            $("#error_nombre").val('');
            return true;
          }  
        }
    });
  }

  function validar_orden(){
      orden=$("#txtOrden").val();
      area=$("#slcArea").val();
      id=$("#id_grd").val();

      $.ajax({
        dataType:'json',
        type:'post',
        data:{orden:orden,id:id, area: area},
        url: urlj+'registro_academico/mantenimientos/validar_orden_grado',
        success: function(data){
          if (data.id > 0) {
            $("#txtOrden").val('');
            crear_alerta('error', 'Orden', 'El Orden del grado ya está asignado.');
            $("#error_nombre").val(1);
            return false;
          }else{
            $("#error_nombre").val('');
            return true;
          }  
        }
    });
  }


  

 