$(document).ready(function(){

    $("input[type='text']").addClass("todo_mayuscula");
    $("textarea").addClass("todo_mayuscula");
    $("select").addClass("todo_mayuscula");

    $("#unidades").select2();
    
    $("#slccategoria").select2({
        placeholder:'Buscar categoría',
        minimumInputLength: 3,
        ajax: {
            url:urlj+'registro_academico/mantenimientos/consultar_categoria',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (categoria) {
              return {
                  categoria: categoria
              };
            },
            results: function (data) {
              var myResults = [];
              $.each(data, function (index, item) {
                  myResults.push({
                      'id': item.tia_id,
                      'text': (item.tia_codigo+' - '+item.tia_nombre)
                  });
              });
              return {
                  results: myResults
              };
          } 
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

     $("#slcProducto").select2({
        placeholder: "Buscar Producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'registro_academico/procesos/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    producto: producto
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.prod_nombre
                    });
                });
                
                return {
                    results: myResults
                };
                
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
           
            if($("#idsJson").length>0){
              $("#slcProducto").val('');
              callback($.parseJSON($("#idsJson").val()));
            }else{
              var idElemento = element[0].id;
              var valor = $("#" + idElemento).val();
              if (valor !== "") {
                  var texto = $("#" + idElemento).data('nombre');
                  callback({id: valor, text: texto});
              }
            }
        }
    });

    $("#slcProducto").on('change', function() {
        var productoId = $(this).val();
        if (productoId) {
            $.ajax({
                url: urlj + 'registro_academico/mantenimientos/get_precio_sugerido',
                dataType: 'json',
                type: 'POST',
                data: { producto_id: productoId },
                success: function(data) {
                    if (data && data.art_precio_sugerido !== null) {
                        $("#txtPrecio").val(parseFloat(data.art_precio_sugerido).toFixed(2));
                    } else {
                        $("#txtPrecio").val('');
                    }
                },
                error: function() {
                    $("#txtPrecio").val('');
                    $("#report-error").html('Error al obtener el precio del producto.').slideDown('slow');
                    setTimeout(function() { $("#report-error").slideUp('slow'); }, 5000);
                }
            });
        } else {
            $("#txtPrecio").val('');
        }
    });

    $("#btnAgregarProducto").click(function() {
        var productoId = $("#slcProducto").val();
        var productoText = $("#slcProducto").select2('data') ? $("#slcProducto").select2('data').text : '';
        var precio = $("#txtPrecio").val().trim();
        var existencias = $("#txtExistencias").val().trim();
        var editIndex = $("#editIndex").val();

        var errors = [];
        if (!productoId) errors.push("Seleccione un producto.");
        if (!precio || isNaN(precio) || parseFloat(precio) <= 0) errors.push("Ingrese un precio válido.");
        if (!existencias || isNaN(existencias) || parseInt(existencias) < 0) errors.push("Ingrese una cantidad de existencias válida.");

        if (errors.length > 0) {
            $("#report-error").html(errors.join("<br>")).slideDown('slow');
            setTimeout(function() { $("#report-error").slideUp('slow'); }, 5000);
            return;
        }

        var productos = JSON.parse($("#productosData").val() || "[]");

        if (editIndex === "-1") {
            productos.push({
                id: parseInt(productoId),
                text: productoText,
                precio: parseFloat(precio).toFixed(2),
                existencias: parseInt(existencias)
            });
        } else {
            productos[editIndex] = {
                id: parseInt(productoId),
                text: productoText,
                precio: parseFloat(precio).toFixed(2),
                existencias: parseInt(existencias)
            };
        }

        $("#productosData").val(JSON.stringify(productos));

        actualizarTablaProductos();

        $("#slcProducto").select2('val', '');
        $("#txtPrecio").val('');
        $("#txtExistencias").val('');
        $("#editIndex").val('-1');
        $("#btnAgregarProducto").text('Agregar');
    });

    $(document).on('click', '.btnEditProducto', function() {
        var row = $(this).closest('tr');
        var index = row.data('index');
        var productos = JSON.parse($("#productosData").val() || "[]");
        var producto = productos[index];
        
        $("#slcProducto").select2('data', {
          id: producto.id,
          text: producto.text
        });

        $("#txtPrecio").val(producto.precio);
        $("#txtExistencias").val(producto.existencias);
        $("#editIndex").val(index);
        $("#btnAgregarProducto").text('Actualizar');
    });

    $(document).on('click', '.btnDelProducto', function() {
        var row = $(this).closest('tr');
        var index = row.data('index');
        var productos = JSON.parse($("#productosData").val() || "[]");
        productos.splice(index, 1);
        $("#productosData").val(JSON.stringify(productos));
        actualizarTablaProductos();
    });

    function actualizarTablaProductos() {
        var productos = JSON.parse($("#productosData").val() || "[]");
        var tbody = $("#tbProductos");
        tbody.empty();

        $.each(productos, function(index, prod) {
            var row = `
                <tr data-index="${index}">
                    <td><label class="text tables-input select-text">${prod.text}</label></td>
                    <td><label class="text tables-input select-text">${prod.precio}</label></td>
                    <td><label class="text tables-input select-text">${prod.existencias}</label></td>
                    <td>
                        <button type="button" class="btn btn-warning btn-mini btnEditProducto" style="height:30px;width:50px;">Editar</button>
                        <button type="button" class="btn btn-danger btn-mini btnDelProducto" style="height:30px;width:50px;">Eliminar</button>
                    </td>
                </tr>`;
            tbody.append(row);
        });
    }

    actualizarTablaProductos();

    if ($('#report-success').is (':visible')) 
        {
         setTimeout(function(){
            $("#report-success").hide('slow');
         },7000);
        }

        $("#estado").select2();

      $("#direccion").val(1);
      
      $("#guardar").mouseover(function(){
      $("#direccion").val(1);
      if($("#nombre").val().trim()!='') {
        validar_nombre();
      }
      if($("#txtCodigo").val().trim()!='') {
        var codigo = $("#txtCodigo").val();
        var id = $("#id_mod").val();
        validar_codigo_modulo(codigo, id);
      }
    });

    $("#guardar_volver").mouseover(function(){
      $("#direccion").val(2);
      if($("#nombre").val().trim()!='') {
        validar_nombre();
      }
      if($("#txtCodigo").val().trim()!='') {
        var codigo = $("#txtCodigo").val();
        var id = $("#id_mod").val();
        validar_codigo_modulo(codigo, id);
      }
    });

	// Validar campos y enviar POST
    $("#frm-nuevo_modulo").validate({
      ignore:"",
      rules: {
          // admin_contrato:{required:true, min:1},
          txtCodigo: {required:true },
          nombre: {required:true },
          unidades: {required:true, min: 1},
          slccategoria: {required:true }

      },
      messages:{
          txtCodigo: "El campo código es requerido",
          nombre: "El campo Nombre del nivel es requerido",
          unidades: "El campo Unidades es requerido",
          slccategoria: "El campo Categoria es requerido",
      },
   
      ignore: ".select2-container",
      errorPlacement: function (error, element) {
          var nombre=$(element).attr("id");
          $(element).removeClass('error');

          var codigo = $("#txtCodigo").val();
          var id = $("#id_mod").val();
          
          if($("#report-error").is(":visible")){
            $("#report-error").slideUp('slow');
          }

          if($(".alert-success").is(":visible")){
            $(".alert-success").hide();
          }

          $("#report-error").slideDown('slow');
          $("#report-error").html(error);
         // $("#report-error label").removeClass('error');
          $("#report-error label").css({'font-size':'12px','color':'#b94a48'});
            
          if($("#estado").val() < 0 || $("#estado").val()==''){ 
            if($(".estado").length<=0){
             $("#report-error").append("<p class='estado'>El campo Estado es requerido</p>");
            }
            $("#error_nombre").val(1);
          }
          
          validar_nombre();
          validar_codigo_modulo(codigo, id);
      },
      submitHandler: function(form){ 
        validar_nombre();
        var codigo = $("#txtCodigo").val();
        var id = $("#id_mod").val();
        validar_codigo_modulo(codigo, id);
            estado=$("#estado").val();
            if($("#estado").val() < 0 || $("#estado").val()==''){ 
              if($(".alert-success").is(":visible")){
                $(".alert-success").hide();
              }
              if($(".estado").length<=0){
                $("#report-error").append("<p class='estado'>El campo Estado es requerido</p>");
              }
                $("#error_nombre").val(1);
                $("#report-error").slideDown('slow');
        
                $("#report-error label").css({'font-size':'12px','color':'#b94a48'});
            }
        setTimeout(function(){
         
          if($("#error_nombre").val()=='' && $("#estado").val() != '' ){
              form.submit(); 
          }
        },400);
      }  
		});

$("#estado").change(function(event){
  if($("#report-error").is(":visible")){
      $("#report-error p").remove();
      if( $("#report-error p").length<=0 && $("#report-error label").length<=0 && $("#report-error .error").length<=0){
        $("#report-error").hide();
      }
  }
});

$("#txtCodigo").live('blur', function(event) {
   var codigo = $("#txtCodigo").val();
   var id = $("#id_mod").val();

   validar_codigo_modulo(codigo, id);

});


  $("#cancel").click(function(event){
      event.preventDefault();
      alerta_confirm(urlj+'registro_academico/mantenimientos/gestion_modulos','Alerta de confirmación','Los datos que ingresaste no han sido guardados. <br> ¿Éstas seguro que quieres regresar a la lista?');
  });


}); // End document ready


  function validar_nombre(){
      nombre=$("#nombre").val();
      id=$("#id_mod").val();
      $.ajax({
      dataType:'json',
      type:'post',
      data:{nombre:nombre,id:id},
      url: urlj+'registro_academico/mantenimientos/validar_modulo',
      success: function(data){
        id_emp=data.id;
        
        if (data.id > 0) {
         

          if($("#report-error").is(":visible")){
            $("#report-error").slideUp('slow');
          }
        $("#report-error").slideDown('slow').html('El campo Nombre del nivel debe ser único');
          if($("#estado").val() < 0 || $("#estado").val()==''){ 
              if($(".estado").length<=0){

                $("#report-error").append("<p class='estado'>El campo Estado es requerido</p>");
                $("#error_nombre").val(1);
              }
          }
        $("#report-error label").css({'font-size':'12px'});
        if ($('#report-error').is (':visible')) 
          {
            $('.alert-success').hide();
          }
         setTimeout(function(){
          $("#report-error").hide('slow');
          
         },7000);


        $("#error_nombre").val(1);
       // $('#enviarCont').attr('disabled', false);
          return false;
        }else{
          $("#error_nombre").val('');
        }  
      }
    });
  }


  function validar_codigo_modulo(codigo, id=null){
     $.ajax({
      dataType:'json',
      type:'post',
      data:{codigo:codigo,id:id},
      url: urlj+'registro_academico/mantenimientos/validar_codigo_modulo',
      success: function(data){
        if(data.id>0){
          $("#txtCodigo").val(data.codigo);
          $("#txtCodigo").addClass('error');
          crear_alerta('error', 'Error', 'El código ingresado ya existe');
        }
      }           
    });

  }