jQuery(document).ready(function(){
        
    $("#nivel, #area, #frecuencia, #proyeccion").select2();
    $("input[type='text']").addClass("todo_mayuscula");
    $("textarea").addClass("todo_mayuscula");

    $(".duplicar_grupo").live('click',function(event) {
        event.preventDefault();
        nombre=$(this).data('nombre');
        $("#grupo_label").text(nombre);

        id_grupo=$(this).attr('href').split('/');
        $("#id_grupo_duplicar").val(id_grupo.pop());
        $("#mostrar_modal").trigger('click');
        
    });

    $("#area").change(function(event) {
        var area=$(this).val();
        
        if($(this).val()>0) {
            $.ajax({
               url: urlj + "registro_academico/procesos/cargar_select_proyeccion",
                 type: 'POST',
                 data: {area: area},
                 dataType: 'json',
                beforeSend: function () {
                  $("#proyeccion").attr("placeholder","Cargando..."); 
                  $("#proyeccion").attr('disabled', 'disabled');
                  $("#proyeccion").select2();
                },
                error: function (xhr, status, error){
                  exportarError(xhr.responseText);
                },
                success: function (json) {
                  wait.close();
                  $('#proyeccion').html(json);
                  $("#proyeccion").attr("placeholder","Seleccione");
                  $("#proyeccion").removeAttr('disabled');
                  $("#proyeccion").select2();
                }
            });

            $.ajax({
                url: urlj + "registro_academico/procesos/get_frecuencias",
                type: 'POST',
                data: {area: area},
                dataType: 'json',
                beforeSend: function () {
                  $("#frecuencia").attr("placeholder","Cargando..."); 
                  $("#frecuencia").attr('disabled', 'disabled');
                  $("#frecuencia").select2();
                },
                 error: function (xhr, status, error){
                  exportarError(xhr.responseText);
                  wait.close();
                },
                  success: function (json) {
                    $('#frecuencia').html(json);
                    $("#frecuencia").attr("placeholder","Seleccione");
                    $("#frecuencia").removeAttr('disabled');
                    $("#frecuencia").select2();
                }
            });
        } else {
            $("#proyeccion").val(0);
            $("#proyeccion").select2();
            $("#frecuencia").val();
            $("#frecuencia").select2();
        }

    });

    $("#proyeccion").change(function(event){
        var proyeccion = $("#proyeccion").val();

        $.ajax({
            url: urlj + "registro_academico/procesos/cargar_proyeccion_nivel",
            type: 'POST',
            data: {proyeccion: proyeccion},
            dataType: 'json',
             beforeSend: function () {
              $("#nivel").attr("placeholder","Cargando..."); 
              $("#nivel").attr('disabled', 'disabled');
              $("#nivel").select2();
            },
             error: function (xhr, status, error){
              exportarError(xhr.responseText);
              wait.close();
            },
            success: function (json) {
              $('#nivel').html(json);
              $("#nivel").attr("placeholder","Seleccione");
              $("#nivel").removeAttr('disabled');
              $("#nivel").select2();

            }
        });
    });

    $("#nivel").change(function(event) {
        var nivel = $(this).val();
        var area = $("#area").val();
        $.ajax({
                type: 'post',
                dataType: 'json',
                url:  window.gSateliteWhite.baseUrl('registro_academico/mantenimientos/get_horarioxnivel'),
                data: {nivel:nivel, area:area},
                success: function (data) {
                    console.log(nivel);
                    console.log(area);
                    $('#horario').html(data.horarios);
                    $("#horario").select2();
                }
            });
    });

    $("#consultar").click(function(event){
        event.preventDefault();

        var area = $("#area").val();
        var nivel = $("#nivel").val();
        var frecuencia = $("#frecuencia").val();
        var proyeccion = $("#proyeccion").val();
        var fecha = $("#fecha").val();
            wait.start();
            $("#contenedor_index").hide("slide", {
                direction: 'right'
                }, 400, function() { //despues de ocultar div enviar el ajax
                    $.ajax({
                        type: 'post',
                        url:  window.gSateliteWhite.baseUrl('registro_academico/procesos/gestion_grupos'),
                        data: {area:area, nivel:nivel, frecuencia:frecuencia, fecha:fecha, proyeccion:proyeccion},
                        success: function (data) {
                            var oTable = $('#datagried1').dataTable();  
                            oTable.fnDestroy();
                            $("#consulta_table").html(data);
                            $('#datagried1').dataTable({"iDisplayLength": 5, "sPaginationType": "full_numbers"});
        var contador=1;
         while(contador<4){
            $("#datagried" +contador+ "_length select").html("<option value='5'>5</option>");
            $("#datagried" +contador+ "_length select").append("<option value='10'>10</option>");
            $("#datagried" +contador+ "_length select").append("<option value='15'>15</option>");
            $("#datagried" +contador+ "_length select").append("<option value='20'  selected='selected' >20</option>");
            contador++;
    }
   setTimeout(function(){
        $('#datagried1_length select').trigger('change');
   },200);
                        $('#datagried1').css('width','100%');
                        wait.close();
                        $("#contenedor_index").show("slide", {
                            direction: 'left'
                        }, 500);
                        
                    }
            });
        });
   
    });


    $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            width:'100%',
            closeBtn: true,
            height: '100%'
        });
    });


}); // End jQuery

function duplicar_grupos() {
    cantidad=$("#cantidad_grupos").val();
    id_grupo =  $("#id_grupo_duplicar").val();
    $.ajax({
        type: 'POST',
        dataType: 'json',
        url:  window.gSateliteWhite.baseUrl('registro_academico/procesos/duplicar_grupo'),
        data: {'id_grupo':id_grupo,'cantidad':cantidad},
        success: function (data) {
            if(data.exito>0){
                location.reload();
            } else {
                crear_alerta('error','Error','Ocurrió un error al duplicar lo(s) grupo(s)<br>Verificar que la cantidad sea mayor a cero <br> * Favor intentarlo de nuevo');
            }
        }
    });
}