$(document).ready(function () {
    gSateliteWhite.jsSelect();
    $('select option[value=0]').val('');

    $("#slcAlumno").select2({
        placeholder: "Buscar Alumno",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'registro_academico/procesos/get_alumnos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (alumno) {
                return {
                    alumno: alumno
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.alumno,
                        'text': item.alm_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('text');
                callback({id: valor, text: texto});
            }
        }
    });

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');
    $("#slcEstado").select2();

    $("#form_reporte_personal_factura").validate({
        ignore:"",
        rules: {
            txtFechaIni:{ required:true},
            txtFechaFin:{ required:true}
            //slcCategoria:{ required:true,min:1}
            //slcVendedor:{ required:true,min:1},
            //slcPago:{ required:true,min:1}
        }, 
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });

    $("#imprimir_factura").live("click", function(){
      $("#form_reporte_personal_factura").attr('action','imprimir_reporte_acumulado_factura_mensual_categoria/')
      var tipo = 'excel';
      var fecha_fin = $("#txtFechaFin").val();
      var arreglo_fecha = fecha_fin.split("-");
      var fecha_ini = '01-'+arreglo_fecha[1]+'-'+arreglo_fecha[2];

      $("#txtFechaIni").val(fecha_ini);

      $("#txtCategoria").val($("#slcCategoria option:selected").text());

      if(!$("#form_reporte_personal_factura").valid()){
        crear_alerta('error','Alerta','Campos con * son requeridos.');
        return false;
      }
      if(fecha_ini !='' && fecha_fin != ''){
          if(!verifica_fecha(fecha_ini,fecha_fin)){
             crear_alerta('error','Alerta','Verifique el período de fechas.');
             return false;
          }
      }

      $("#tipo_reporte").val(tipo);
      $("#form_reporte_personal_factura").submit();

    })

    $("#imprimir_factura_pdf").live("click", function(){
      $("#form_reporte_personal_factura").attr('action','imprimir_reporte_acumulado_factura_mensual_categoria/')
      var tipo = 'pdf';
      //var fecha_ini = $("#txtFechaIni").val();
      var fecha_fin = $("#txtFechaFin").val();

      var arreglo_fecha = fecha_fin.split("-");
      var fecha_ini = '01-'+arreglo_fecha[1]+'-'+arreglo_fecha[2];

      $("#txtFechaIni").val(fecha_ini);

      $("#txtCategoria").val($("#slcCategoria option:selected").text());

      if(!$("#form_reporte_personal_factura").valid()){
        crear_alerta('error','Alerta','Campos con * son requeridos.');
        return false;
      }
      if(fecha_ini !='' && fecha_fin != ''){
          if(!verifica_fecha(fecha_ini,fecha_fin)){
             crear_alerta('error','Alerta','Verifique el período de fechas.');
             return false;
          }
      }

      $("#tipo_reporte").val(tipo);
      $("#form_reporte_personal_factura").submit();
    })

    /*Busqueda*/
    $("#btnConsultar").click(function(){
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var alumno    = $("#slcAlumno").val();


        if ($.trim(alumno) == '') {
            if(!$("#form_reporte_personal_factura").valid()){
                crear_alerta('error','Alerta','Campos con * son requeridos.');
                return false;
            }
        } else {
            $("#txtFechaIni_error").text('');
            $("#txtFechaFin_error").text('');
        }

        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
               crear_alerta('error','Alerta','Verifique el período de fechas.');
               return false;
            }
        }

        $("#dv_contenedor_reg").hide('slide',{
                direction:'right'
            },
            400,function(){
                $.ajax({
                   type:'post',
                   url:window.gSateliteWhite.baseUrl('registro_academico/procesos/gestion_alumnos/1'),
                   data:{fecha_ini:fecha_ini, fecha_fin:fecha_fin, alumno:alumno},
                   beforeSend:function(){
                       wait.start();
                   },
                   success:function(result){
                       $('#encabezado').show();
                        $("#datagried").html(result);
                        aplidarDataTable('tabla_alum')
                        $("#control").show();
                        wait.close();
                        $("#dv_contenedor_reg").show("slide", {
                           direction: 'left'
                        }, 500);
                   }
                });
            }
        );

   });
   
   
   $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            //width:'100%',
            closeBtn: true
        });
    });

    $('.eliminar').live('click', function(event) {
        event.preventDefault();
        alerta_confirm_ajax(eliminar_registro, $(this).attr("id"), "Alerta confirmación", "¿Éstas seguro que quieres Inactivar al Alumno?");
    });

    $('.activar').live('click', function(event) {
        event.preventDefault();
        alerta_confirm_ajax(activar_registro, $(this).attr("id"), "Alerta confirmación", "¿Éstas seguro que quieres Activar al Alumno?");
    });


    function eliminar_registro(id) {        
        window.location.href = urlj + "registro_academico/procesos/inactivar_alumno/"+id;
    }

    function activar_registro(id) {        
        window.location.href = urlj + "registro_academico/procesos/inactivar_alumno/"+id+'/'+1;
    } 

});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    /*if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#txtFechaFin").addClass('error');
        $("#txtFechaFin_error").text("Verifique las fechas del período");
        return false;
    }*/

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#txtFechaFin").addClass('error');
        $("#txtFechaFin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) <= Date.parse(fecha_f)) {
        $("#txtFechaFin").removeClass('error');
        $("#txtFechaFin_error").text('');
        return true;
    }
}