$(document).ready(function() {
    $(".fecha").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
    $(".fecha").mask("99-99-9999");
    $(".fecha").attr('placeholder',"dd-mm-yyyy");
    $('select').select2();
    $('.exportar').hide();

    //  Validacion para funcionar por peticion POST con recargar pagina
    // $("#frm_filtro").validate({
    //     ignore: "",
    //     rules: {
    //         slcTipoDiploma: {required: true},
    //         slcAreas: {required: true},
    //         slcProyeccion: {required: true},
    //         slcGrupo: {required: true}
    //     },
    //     ignore: ".select2-container",
    //     errorPlacement: function (error, element) {
    //         var nombre=$(element).attr("id");
    //         $('#'+nombre+'_error').text('Campo requerido');
    //     },
    //     submitHandler: function(form) {
    //         form.submit();
    //     }
    // });

    $("#checkTodos").change(function () {
          $("input:checkbox").prop('checked', $(this).prop("checked"));
    });

    $(document).on('change', '#slcTipoDiploma', function() {
        $('#filtro_tipo_diploma').val($(this).val());
    });

    $(document).on('change', '#slcAreas', function() {
        $("#slcProyeccion").val(0);
        $("#slcProyeccion").select2();
        if ($(this).val()>0) {
            $.ajax({
                type:'post',
                dataType:'json',
                url:window.gSateliteWhite.baseUrl('registro_academico/consultas/get_areaxproyeccion'),
                data:{ area:$(this).val() },
                beforeSend:function(){
                    $("#slcProyeccion").attr("placeholder","Cargando..."); 
                    $("#slcProyeccion").attr('disabled', 'disabled');
                    $("#slcProyeccion").select2();
                },
                success:function(data){
                    // console.log(data);
                    $("#slcProyeccion").html(data.select);
                    $("#slcProyeccion").attr("placeholder","Seleccione");
                    $("#slcProyeccion").removeAttr('disabled');
                    $("#slcProyeccion").select2();
                }
            });
        } else {
            $("#slcProyeccion").val(0);
            $("#slcProyeccion").select2();
        }
        $('#filtro_area').val($(this).val());
    });

    $(document).on('change', '#slcProyeccion', function() {
        $("#slcGrupo").val(0);
        $("#slcGrupo").select2();
        if ($(this).val()>0) {
            $.ajax({
                type:'post',
                dataType:'json',
                url:window.gSateliteWhite.baseUrl('registro_academico/consultas/ajax_grupoxproyeccion'),
                data:{ proyeccion:$(this).val() },
                beforeSend:function(){
                    $("#slcGrupo").attr("placeholder","Cargando..."); 
                    $("#slcGrupo").attr('disabled', 'disabled');
                    $("#slcGrupo").select2();
                },
                success:function(data){
                    $("#slcGrupo").html(data);
                    $("#slcGrupo").attr("placeholder","Seleccione");
                    $("#slcGrupo").removeAttr('disabled');
                    $("#slcGrupo").select2();
                }
            });

        } else {
            $("#slcGrupo").val(0);
            $("#slcGrupo").select2();
        }

        $('#filtro_proyeccion').val($(this).val());

    });

    $(document).on('change', '#slcGrupo', function() {
        $('#filtro_grupo').val($(this).val());
    });

    $(document).on('change', '#txtFecha', function() {
        fecha = $("#txtFecha").val();
        $("#filtro_fecha").val(fecha);
    });

    


    $(document).on('click', '#btnConsultar', function(event) {
        event.preventDefault();

        if ( $('#slcTipoDiploma').val() != '' && $('#slcAreas').val() != '' && $('#slcProyeccion').val() != '' && $('#slcGrupo').val() != '') {
            $.ajax({
                 url:  urlj + "registro_academico/consultas/generacion_diplomas/1",
                 type: 'POST',
                 data: { tipo_diploma: $('#slcTipoDiploma').val(), area: $('#slcAreas').val(), proyeccion: $('#slcProyeccion').val(), grupo: $('#slcGrupo').val() },
                 dataType: 'text',
                 beforeSend: function () {
                     wait.start('Cargando..');
                 },
                 error: function (xhr, status, error){
                  // exportarError(xhr.responseText);
                  wait.close();
                  },
                  async: false,
                  success: function (json) {
                    wait.close();
                    // console.log(json);
                    $('.exportar').show('slow');
                    $("#tblContenedor").dataTable().fnDestroy();
                    $("#tbContenedor").html(json);
                    aplidarDataTable('tblContenedor');
                    $("#exportar").val(1);
                    
              }

            });

        } else {
            crear_alerta('error','Información', 'Debe filtrar la información a buscar(Obligatorios Tipo de Diploma, Area, Proyección y Grupo)');
        }

    });

    $(document).on('click', '.imprimir', function() {
         if (this.checked) $('#id_'+$(this).prop('id')).val(1);
        else $('#id_'+$(this).prop('id')).val(0);
    });

    $(document).on('change','.imprimirDiplomas', function() {
        $('#filtro_impresion').val($(this).val());
    });

    $("#exportar").val(0);

    $(".exportar").click(function(event){
      event.preventDefault();

        var areas = $("#slcAreas").val();
        var frecuencia = $('#slcFrecuencia').val();
        

        $('#filtro_areas').val(areas);
        $('#filtro_frecuencia').val(frecuencia);
        
      if($("#exportar").val()==1){
        $("#frm_contenedor").submit();
      }else{
        crear_alerta('error','Información', 'Debe filtrar la información a buscar');
      }
    });

});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}