jQuery(document).ready(function() {
    $("#fecha").datepicker({ dateFormat: 'yy-mm-dd', changeMonth: true, changeYear: true });
    $("#fecha").mask("9999-99-99");
    $("#fecha").attr('placeholder', "yyyy-mm-dd");

    $("#nivel, #area, #frecuencia, #proyeccion, #slcProyeccion, #slcGrupo").select2();

    $("#area").change(function(event) {
        var area = $(this).val();

        if ($(this).val() > 0) {
            $.ajax({
                url: urlj + "registro_academico/procesos/cargar_select_proyeccion",
                type: 'POST',
                data: { area: area },
                dataType: 'json',
                beforeSend: function() {
                    wait.start('Cargando..');
                },
                error: function(xhr, status, error) {
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function(json) {
                    wait.close();
                    $('#proyeccion').html(json);
                    $("#proyeccion").select2();
                }
            });

            $.ajax({
                url: urlj + "registro_academico/procesos/get_frecuencias",
                type: 'POST',
                data: { area: area },
                dataType: 'json',
                beforeSend: function() {
                    wait.start('Cargando..');
                },
                error: function(xhr, status, error) {
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function(json) {
                    wait.close();
                    $('#frecuencia').html(json);
                    $("#frecuencia").select2();
                }
            });
        } else {
            $("#proyeccion").val(0);
            $("#proyeccion").select2();
            $("#frecuencia").val();
            $("#frecuencia").select2();
        }

    });

    $("#proyeccion").change(function(event) {
        var proyeccion = $("#proyeccion").val();

        $.ajax({
            url: urlj + "registro_academico/procesos/cargar_proyeccion_nivel",
            type: 'POST',
            data: { proyeccion: proyeccion },
            dataType: 'json',
            beforeSend: function() {
                wait.start('Cargando..');
            },
            error: function(xhr, status, error) {
                exportarError(xhr.responseText);
                wait.close();
            },
            success: function(json) {
                // console.log(json);
                wait.close();
                $('#nivel').html(json);
                $("#nivel").select2();

            }
        });
    });

    $("#nivel").change(function(event) {
        var nivel = $(this).val();
        var area = $("#area").val();
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.gSateliteWhite.baseUrl('registro_academico/mantenimientos/get_horarioxnivel'),
            data: { nivel: nivel, area: area },
            success: function(data) {
                console.log(nivel);
                console.log(area);
                $('#horario').html(data.horarios);
                $("#horario").select2();
            }
        });
    });

    $("#consultar").click(function(event) {
        event.preventDefault();
        var area = $("#area").val();
        var nivel = $("#nivel").val();
        var frecuencia = $("#frecuencia").val();
        var proyeccion = $("#proyeccion").val();
        var fecha = $("#fecha").val();
        wait.start();
        $("#contenedor_index").hide("slide", {
            direction: 'right'
        }, 400, function() { //despues de ocultar div enviar el ajax
            $.ajax({
                type: 'post',
                url: window.gSateliteWhite.baseUrl('registro_academico/procesos/finalizar_grupo'),
                data: { area: area, nivel: nivel, frecuencia: frecuencia, fecha: fecha, proyeccion: proyeccion },
                success: function(data) {
                    var oTable = $('#tblGrupo').dataTable();
                    oTable.fnDestroy();
                    $("#tbContenedorGrupo").html(data);
                    $('#tblGrupo').dataTable({ "iDisplayLength": 5, "sPaginationType": "full_numbers" });
                    var contador = 1;
                    while (contador < 4) {
                        $("#tblGrupo" + contador + "_length select").html("<option value='5'>5</option>");
                        $("#tblGrupo" + contador + "_length select").append("<option value='10'>10</option>");
                        $("#tblGrupo" + contador + "_length select").append("<option value='15'>15</option>");
                        $("#tblGrupo" + contador + "_length select").append("<option value='20'  selected='selected' >20</option>");
                        contador++;
                    }

                    setTimeout(function() {
                        $('#datagried1_length select').trigger('change');
                    }, 200);

                    $('#tblGrupo').css('width', '100%');
                    wait.close();
                    $("#contenedor_index").show("slide", {
                        direction: 'left'
                    }, 500);
                }
            });
        });
    });


    $(".a_finaliza").live('click', function(event) {
        id = $(this).data('id');
        element1 = $('#toHide').hide();
        element2 = $('#toHide2').hide();
        element3 = $('#toHideB').hide();
        btnA = $('#toHideA').hide();
        btnB = $('#toHideB').hide();


        if (id > 0) {
            $("#hdnGrupo").val(id);
            $.ajax({ //obtiene info del grupo seleccionado
                type: 'POST',
                dataType: 'json',
                url: window.gSateliteWhite.baseUrl('registro_academico/procesos/cargar_info_grupo'),
                data: { id: id },
                beforeSend: function() {
                    wait.start();

                },
                success: function(data) {
                    wait.close();
                    $("#lblProyeccion").text(data.pyc_actual);
                    $("#lblNivel").text(data.mod_nombre);
                    $("#slcProyeccion").attr("placeholder", "Seleccione");
                    $("#slcProyeccion").html(data.proyecciones);
                    $("#slcProyeccion").select2();
                    $("#hdnGrupo").val(data.gra_id);
                    $("#hdnArea").val(data.ard_id);
                    $("#hdnGrado").val(data.grd_id);

                    if (data.grd_id > 0) {
                        crear_alerta('info', 'Finalizar grupo', 'Al procesar se finalizarán todas las materias del grado <b>' + data.nombre + '</b>')
                    }

                    $.ajax({ //verifica si el grupo tiene carga academica
                        type: 'POST',
                        dataType: 'json',
                        url: window.gSateliteWhite.baseUrl('registro_academico/procesos/check_grupo_finalizar'),
                        data: { id_grado: data.gra_id, proyeccion: data.ard_id },
                        beforeSend: function() {
                            wait.start();
                        },
                        success: function(resp) {
                            wait.close();
                            if (resp == 1) {
                                $('#toHide').show(element1);
                                $('#toHide2').show(element2);
                                $('#toHideA').show(element3);
                            } else {
                                $('#toHideB').show(element3);
                            }
                        }
                    });
                }
            });
        } else {
            $("#slcProyeccion, #slcGrupo").attr("placeholder", "Seleccione");
            $("#slcProyeccion option:first, #slcGrupo option:first").attr('selected', 'selected');
            $("#slcProyeccion, #slcGrupo").select2();

        }
    });

    $("#slcProyeccion").change(function(event) {
        id = $(this).val();
        grupo = $("#hdnGrupo").val();
        area = $("#hdnArea").val();

        if (id > 0) {
            $.ajax({
                type: 'POST',
                dataType: 'json',
                url: window.gSateliteWhite.baseUrl('registro_academico/procesos/get_gruposxproyeccion'),
                data: { pyc: id, grupo: grupo, area: area },
                beforeSend: function() {
                    $("#slcGrupo").attr("placeholder", "Cargando...");
                    $("#slcGrupo").select2();
                },
                success: function(data) {
                    $("#slcGrupo").attr("placeholder", "Seleccione");
                    $("#slcGrupo").html(data);
                    $("#slcGrupo").select2();
                }
            });
        } else {
            $("#slcGrupo, #slcProyeccion").attr("placeholder", "Seleccione");
            $("#slcGrupo option:first").attr('selected', 'selected');
            $("#slcProyeccion option:first").attr('selected', 'selected');
            $("#slcGrupo, #slcProyeccion").select2();

        }
    });


    $("#procesar").click(function(event) {
        pyc = $("#slcProyeccion").val();
        grupo = $("#slcGrupo").val();
        grupo_ant = $("#hdnGrupo").val();
        area = $("#hdnArea").val();
        grado = $("#hdnGrado").val();

        if (pyc <= 0 || grupo <= 0) {
            crear_alerta('error', 'Error', 'Debe seleccionar los campos requeridos');
        } else {
            procesar_cierre(pyc, grupo, grupo_ant, grado);
        }

    });

    $("#cerrar").click(function(event) {

        alerta_confirm_ajax(procesar_cierrex, 1, 'Cierre de grupo', 'Confirme que desea cerrar el grupo!')

    });

    function procesar_cierrex(elemento) {
        grupo_ant = $("#hdnGrupo").val();
        grupo = "";
        pyc = $("#hdnArea").val();
        grado = "";
        procesar_cierre(pyc, grupo, grupo_ant, grado);
    }

}); // End jQuery

function cargar_pensum(id_area, alumno = null) {
    if ($("#slcFactura").val() <= 0) {
        $.ajax({
            type: "POST",
            url: urlj + "registro_academico/procesos/cargar_pensum_inscripcion",
            data: { id: id_area, alumno: alumno },
        }).done(function(html) {
            $("#slcNivel").html(html).select2();
            $("#slcNivel").select2();
        });
    }
}

function procesar_cierre(pyc, grupo, grupo_ant, grado) {
    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: window.gSateliteWhite.baseUrl('registro_academico/procesos/procesar_fin_grupo'),
        data: { pyc: pyc, grupo: grupo, grupo_ant: grupo_ant, grado: grado },
        beforeSend: function() {
            wait.start();
        },
        success: function(data) {
            console.log(data);
            if (data > 0) {
                $.fancybox.close();
                wait.close();
                crear_alerta('success', 'Finalizar grupo', 'Los datos fueron procesados correctamente');
                $("#consultar").trigger('click');
            } else {
                wait.close();
                crear_alerta('error', 'Finalizar grupo', 'No hay inscripciones registradas en el pensum');
            }
        }
    });
}