$(document).ready(function(){
    gSateliteWhite.jsSelect();

    $(".datePicker").attr('placeholder',"dd-mm-yyyy"); 
    $(".datePicker").mask("99-99-9999");
    $(".datePicker").datepicker({
      dateFormat: 'dd-mm-yy', 
      changeMonth: true, 
      changeYear: true,
      showButtonPanel: true
    });

    $("#slcProyeccion").change(function(event) {
        if($(this).val()>0){
            var inicio = $("#slcProyeccion option:selected").data('inicio');
            var fin = $("#slcProyeccion option:selected").data('fin');

            $("#txtInicio_pyc").val(inicio);
            $("#txtFin_pyc").val(fin);

            $("#lblFechaIni").text('Inicio: '+inicio);
            $("#lblFechaFin").text('Fin: '+fin);
        }else{
            $("#txtInicio_pyc").val('');
            $("#txtFin_pyc").val('');

            $("#lblFechaIni").text('');
            $("#lblFechaFin").text('');
        }
       
    });

    $("#txtFecha_ini,#txtFecha_fin").change(function(event) { 
        var inicio_gra = $("#txtFecha_ini").val();
        var fin_gra = $("#txtFecha_fin").val();
        var fecha_ini_pro = $("#txtInicio_pyc").val();
        var fecha_fin_pro = $("#txtFin_pyc").val();

        if(inicio_gra!='' && fin_gra!=''){
            verifica_fecha(inicio_gra,fin_gra);
            if(verifica_fecha(inicio_gra,fin_gra)){
                verifica_fecha_proyeccion(inicio_gra, fin_gra, fecha_ini_pro, fecha_fin_pro)
            }
        }

    });


        $("#frm_duplicar").validate({
            ignore: "", 
            rules:{
                slcProyeccion:{ required:true, min:1 },
                txtFecha_ini: { required:true},
                txtFecha_fin: { required:true},
            }, 
            messages: { 
                slcProyeccion: "Campo requerido",
                txtFecha_ini: "Campo requerido",
                txtFecha_fin: "Campo requerido"
            },
            errorPlacement: function (error, element) {
                var nombre=$(element).attr("id");
                var inicio_gra = $("#txtFecha_ini").val();
                var fin_gra = $("#txtFecha_fin").val();
                var fecha_ini_pro = $("#txtInicio_pyc").val();
                var fecha_fin_pro = $("#txtFin_pyc").val();
                
                $('#'+nombre+'_error').html(error);
                    
                if($("table#datagried tbody#detalles tr .grupo_sel").length<=0){
                    crear_alerta('error', 'Error', 'Debe seleccionar al menos un grupo');
                }

                if(inicio_gra!='' && fin_gra!=''){
                    verifica_fecha(inicio_gra,fin_gra);
                    if(verifica_fecha(inicio_gra,fin_gra)){
                        verifica_fecha_proyeccion(inicio_gra, fin_gra, fecha_ini_pro, fecha_fin_pro)
                    }
                }
            },
            submitHandler: function(form){  
                var inicio_gra = $("#txtFecha_ini").val();
                var fin_gra = $("#txtFecha_fin").val();
                var fecha_ini_pro = $("#txtInicio_pyc").val();
                var fecha_fin_pro = $("#txtFin_pyc").val();

                if($("table#datagried tbody#detalles tr .grupo_sel").length<=0){
                    crear_alerta('error', 'Error', 'Debe seleccionar al menos un grupo');
                }else{
                    if(inicio_gra!='' && fin_gra!=''){
                        if(verifica_fecha(inicio_gra,fin_gra)){
                            if(verifica_fecha_proyeccion(inicio_gra, fin_gra, fecha_ini_pro, fecha_fin_pro)){
                                form.submit(); 
                            }
                        }
                    }

                }
            } 
        });

    $("#cancelar").click(function(event){
        alerta_confirm_ajax(regresar,data,'Confirmar eliminar registro','Los datos que insertaste no han sido guardados. ¿Éstas seguro que quieres regresar a la lista?');
    });

});//End jQuery

    function regresar(){
        window.location.href=urlj+'registro_academico/mantenimientos/proyecciones';
    }

    function applyStyle() {
        $(":checkbox").iButton({
            labelOn: "<span class='icon16 icomoon-icon-checkmark-2 white'></span>",
            labelOff: "<span class='icon16 icomoon-icon-cancel-3 white'></span>",
        });
    }



   function verifica_fecha(fecha_ini, fecha_fin){
        //Convierto la fecha a Y-m-d
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");

        if(Date.parse(fecha_i) == Date.parse(fecha_f)){ $("#txtFecha_fin_error").text(''); return true;}
        
        if(Date.parse(fecha_i) > Date.parse(fecha_f)){
          $("#txtFecha_fin").addClass('error');
          $("#txtFecha_fin_error").text("Verifique las fechas del período");
          return false;
        }

        if(Date.parse(fecha_i) < Date.parse(fecha_f)){
          $("#txtFecha_fin").removeClass('error');
          $("#txtFecha_fin_error").text('');
          return true;
        }
    }

    function verifica_fecha_proyeccion(fecha_ini, fecha_fin, fecha_ini_pro, fecha_fin_pro){
        //Convierto la fecha a Y-m-d
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");

        //Fechas de proyección
        var fecha_ip = fecha_ini_pro.split("-").reverse().join("-"); // Inicio
        var fecha_fp = fecha_fin_pro.split("-").reverse().join("-"); // Fin

       
          if(Date.parse(fecha_i) >= Date.parse(fecha_ip) && Date.parse(fecha_f) <= Date.parse(fecha_fp)){
            $("#txtFecha_fin").removeClass('error');
              $("#txtFecha_fin_error").text('');
              return true;
          }else{
            $("#txtFecha_fin").val('');
            crear_alerta('error', 'Error', 'El rango de fechas debe seleccionarse de acuerdo al período de proyección.');
            return false;
          }
          
        
        
    }
