$(document).ready(function() {
    $('select').select2();

    $(".exportar").hide();

    $(document).on('change', '#slcArea', function() {
        var area = $(this).val(); 
        if(area>0){
            $.ajax({
                type:'post',
                dataType:'json',
                url:window.gSateliteWhite.baseUrl('registro_academico/procesos/get_frecuencias'),
                data:{area:area},
                beforeSend:function(){
                    $("#slcFrecuencia").attr("placeholder", "Cargando...");
                    $("#slcFrecuencia").select2();
                },
                success:function(data){
                    $("#slcFrecuencia").html(data);
                    $("#slcFrecuencia").attr("placeholder", "Seleccione");
                    $("#slcFrecuencia").select2();                  
                }
            });
        }else{
            $("#slcFrecuencia").attr("placeholder", "Seleccione");
            $("#slcFrecuencia").html('<option value=""></option>');
            $("#slcFrecuencia option:first").attr('selected','selected');
            $("#slcFrecuencia").select2();  
        }
    });

    $(document).on('click', '#btnConsultar', function(event) {
        event.preventDefault();

        var area = $('#slcArea').val();
        var frecuencia = $('#slcFrecuencia').val();

        if (area != '' && frecuencia != '') {
            $.ajax({
                 url:  urlj + "registro_academico/consultas/disponibilidad_docente/1",
                 type: 'POST',
                 data: {area: area, frecuencia: frecuencia},
                 dataType: 'text',
                 beforeSend: function () {
                     wait.start('Cargando..');
                 },
                 error: function (xhr, status, error){
                  exportarError(xhr.responseText);
                  wait.close();
              },
                  success: function (json) {

                    console.log(json);
                    $('.exportar').show('slow');
                    $("#tblContenedor").dataTable().fnDestroy();
                    $("#tbContenedor").html(json);
                    aplidarDataTable('tblContenedor');
                    $("#exportar").val(1);
                    wait.close();
              }

            });
        } else {
            crear_alerta('error','Información', 'Debe filtrar la información a buscar');
        }

    });

    $("#exportar").val(0);

    $(".exportar").click(function(event){
      event.preventDefault();
        var area = $('#slcArea').val();
        var frecuencia = $('#slcFrecuencia').val();

        $('#filtro_area').val(area);
        $('#filtro_frecuencia').val(frecuencia);
      if($("#exportar").val()==1){
        $("#frm_contenedor").submit();
      }else{
        crear_alerta('error','Información', 'Debe filtrar la información a buscar');
      }
    });

});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}