$(document).ready(function() {
    var urlj = url_base_proyecto;
    $("select").select2();
    fechaEntera();
        
    $('#slc_tipo').on('change', function (e) {
        tipo = $("#slc_tipo").val();
        if(tipo == "1"){
            $( ".input-fecha-inicio, .input-fecha-fin" ).datepicker( "option", "dateFormat", "dd-mm" );
        } else {
            $( ".input-fecha-inicio, .input-fecha-fin" ).datepicker( "option", "dateFormat", "dd-mm-yy" );
        }
    });

    $(".input-fecha-fin").datepicker({
        closeText: 'Cerrar',
        prevText: '<Ant',
        nextText: 'Sig>',
        currentText: 'Hoy',
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        dateFormat: 'dd-mm-yy',
        onSelect: function(dateStr) {
            var dateStr = $(".input-fecha-fin").val();
            $('#fecha_fin_hidden').val(changeDate(dateStr));
            tipo = $("#slc_tipo").val();
            if(tipo == "1"){
                $( ".input-fecha-fin" ).datepicker( "option", "dateFormat", "dd-mm" );
                var f = $.datepicker.parseDate("dd-mm", dateStr);
            } else {
                $( ".input-fecha-fin" ).datepicker( "option", "dateFormat", "dd-mm-yy" );
                var f = $.datepicker.parseDate("dd-mm-yy", dateStr);
            }
           
            $(".input-fecha-fin").datepicker('setDate', f);
          }
    });

    
    $("#diasnolaborales").validate({
		ignore:"",
		rules: {
			fecha_inicio: { required:true},
			tipo: { required:true},
			nombre: { required:true},
			// descripcion: { required:true}
		}, 
		ignore: ".select2-container",
		errorPlacement: function (error, element) {
			var nombre=$(element).attr("id");
			$('#'+nombre+'_error').html(error);
			$('#'+nombre+'_error').text('Campo requerido');
		},
		submitHandler: function(form) {			
			form.submit();
		}
	});
    
    $('.enviar_formulario').live('click',function(event){
        if($('#fecha_inicio').val() == ""){
            $('#fecha_inicio_error').text('Campo requerido');
            $('#fecha_inicio').addClass('error');
        }

        if($('#nombre').val() == ""){
            $('#nombre_error').text('Campo requerido');
            $('#nombre').addClass('error');
        }

        if($('#descripcion_desde').val() == ""){
            $('#descripcion_desde_error').text('Campo requerido');
            $('#descripcion_desde').addClass('error');
        }

        if(!$('#slc_tipo').val()){
            $('#slc_tipo_error').text('Campo requerido');
            $('#slc_tipos').addClass('error');
        }
	})

});

function fechaEntera() {
    $(".input-fecha-inicio").datepicker({
        closeText: 'Cerrar',
        prevText: '<Ant',
        nextText: 'Sig>',
        currentText: 'Hoy',
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        dateFormat: 'dd-mm-yy',
        onSelect: function(dateStr) {
            var dateStr = $(".input-fecha-inicio").val();
            $('#fecha_inicio_hidden').val(changeDate(dateStr));
            $('#fecha_fin_hidden').val(changeDate(dateStr));
            //var f = new Date(dateStr[2], dateStr[1] - 1, dateStr[0]);
            tipo = $("#slc_tipo").val();
            if(tipo == "1"){
                $( ".input-fecha-inicio, .input-fecha-fin" ).datepicker( "option", "dateFormat", "dd-mm" );
                var f = $.datepicker.parseDate("dd-mm", dateStr);
            } else {
                $( ".input-fecha-inicio, .input-fecha-fin" ).datepicker( "option", "dateFormat", "dd-mm-yy" );
                var f = $.datepicker.parseDate("dd-mm-yy", dateStr);
            }
           
            console.log(f);
            
            $(".input-fecha-fin").datepicker('setDate', f);
          }
    });

    //$(".input-fecha-inicio, .input-fecha-fin").mask("dd-mm-yy");
}

function changeDate(date) {
    //var date= '21-01-2019';   

    var d=new Date(date.split("-").reverse().join("-"));
    var mm=d.getMonth()+1;
    var yy=new Date().getFullYear();

    tipo = $("#slc_tipo").val();
    if(tipo == "1"){
        var dd=d.getDate()+1;
    } else {
        var dd=d.getDate()+1;
    }
    var fecha = yy+"-"+mm+"-"+dd;
    //alert(yy+"/"+mm+"/"+dd);

    return fecha;
}