$(document).ready(function(){
	window.gSateliteWhite.jsSelect();
	var pathArray = window.location.pathname.split( '/' );
	var urlj=url_base_proyecto;

	$('#slcProyeccion').change(function(){
		var area = $("#slcProyeccion option:selected").data('area');
		var proyeccion = $("#slcProyeccion").val();
		$("#lblArea").text(area);

		if(proyeccion>0){
			$.ajax({
		        type:'post',
		        data: {proyeccion: proyeccion},
		        url: urlj+'registro_academico/consultas/get_nivelxproyeccion',
		        beforeSend: function(){
		          $("#slcNivel").attr("placeholder","Cargando..."); 
		          $("#slcNivel").select2();
		        },
		        success: function(data){
		          $("#slcNivel").html(data);
		          $("#slcNivel").attr("placeholder","Seleccione");
		          $("#slcNivel").select2();
		          $("#slcNivel").trigger('change');
		          $("#slcNivel_error").text('');
		        }
		    });
		}else{
				$("#slcNivel").attr("placeholder","Seleccione");
		        $("#slcNivel").html('<option value=""></oprion>');
		        $("#slcNivel option[value=0]").val('');
		        $("#slcNivel").select2();
		        $("#slcNivel_error").text('');
		}
	});


	$('#slcNivel').change(function(){
		var proyeccion = $("#slcProyeccion").val();
		var nivel = $("#slcNivel").val();

		if($(this).val()){
			$.ajax({
		        type:'post',
		        data: {proyeccion: proyeccion, nivel: nivel},
		        url: urlj+'registro_academico/consultas/get_alumnoxnivel',
		        beforeSend: function(){
		          $("#slcAlumno").attr("placeholder","Cargando..."); 
		          $("#slcAlumno").select2();
		        },
		        success: function(data){
		          $("#slcAlumno").html(data);
		          $("#slcAlumno").attr("placeholder","Seleccione");
		          $("#slcAlumno").select2();
		          $("#slcAlumno_error").text('');
		        }
		    });
		}else{
			$("#slcAlumno").attr("placeholder","Seleccione");
		    $("#slcAlumno").html('<option value=""></oprion>');
		    $("#slcAlumno option[value=0]").val('');
		    $("#slcAlumno").select2();
		    $("#slcAlumno_error").text('');
		}

	});

	$("#slcTipoForm").change(function(event) {
		var formato = $("#slcTipoForm").val();
		if($(this).val()){
			$.ajax({
		        type:'post',
		        data: {formato: formato},
		        url: urlj+'registro_academico/consultas/get_tipo_constancia',
		        beforeSend: function(){
		          $("#slcTipoCons").attr("placeholder","Cargando..."); 
		          $("#slcTipoCons").select2();
		        },
		        success: function(data){
		          $("#slcTipoCons").html(data);
		          $("#slcTipoCons").attr("placeholder","Seleccione");
		          $("#slcTipoCons").select2();
		          $("#slcTipoCons_error").text('');
		        }
		    });
		}else{
			$("#slcTipoCons").attr("placeholder","Seleccione");
		    $("#slcTipoCons").html('<option value=""></oprion>');
		    $("#slcTipoCons option[value=0]").val('');
		    $("#slcTipoCons").select2();
		    $("#slcTipoCons_error").text('');
		}
	});


	$('#constancia_form').validate({
		ignore:"",
		rules:{
			slcProyeccion:{required:true, min:1},
			slcNivel:{required:true, min:1},
			slcAlumno:{required:true, min:1},
			slcTipoForm:{required:true, min:1},
			slcTipoCons:{required:true, min:1},
		},
		ignore: ".select2-container",
		messages:{
			slcProyeccion:"Campo requerido",
			slcNivel:"Campo requerido",
			slcAlumno:"Campo requerido",
			slcTipoForm:"Campo requerido",
			slcTipoCons: "Campo requerido"
		},
		errorPlacement: function (error, element) {
			var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
		},
		submitHandler:function(form){
			form.submit();
		}
});



	 
}); // End jQuery
