$(document).ready(function() {
    var url = url_base_proyecto;
    $('select').select2();
    $("#tblCierre").dataTable();

    $("#frm_filtro").validate({
        ignore: "",
        rules: {
            slcProyeccion: {required: true}
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });

    $(document).on('change', '#slcProyeccion', function() {
        var docente = $("#slcDocente").val();
        var url_ajax = url + "registro_academico/procesos/ajax_proyeccion_docente";
        //ajax_proyeccion_nivel
        if ($(this).val()>0) {
            $.ajax({
                 url: url_ajax,
                 type: 'POST',
                 data: {proyeccion: $(this).val()},
                 dataType: 'text',
                 beforeSend: function () {
                     wait.start('Cargando..');
                 },
                 error: function (xhr, status, error){
                  exportarError(xhr.responseText);
                  wait.close();
              },
                  success: function (json) {
                    $('#slcDocente').html(json);
                    wait.close();
              }

          });

            $.ajax({
              url: url + "registro_academico/procesos/ajax_proyeccion_nivel",
              type: 'POST',
              data: {proyeccion: $(this).val(), docente: docente},
              dataType: 'text',
              beforeSend: function () {
                wait.start('Cargando..');
              },
              error: function (xhr, status, error){
                exportarError(xhr.responseText);
                wait.close();
              },
              success: function (json) {
                $('#slcNivel').html(json);
                wait.close();
              }
            });
        } else {
            $('#slcNivel').html('<option value=""></option>');
        }
    });

    $(document).on('change', '#slcDocente', function() {
        var docente = $("#slcDocente").val();
            $.ajax({
              url: url + "registro_academico/procesos/ajax_proyeccion_nivel",
              type: 'POST',
              data: {proyeccion: $("#slcProyeccion").val(), docente: docente},
              dataType: 'text',
              beforeSend: function () {
                wait.start('Cargando..');
              },
              error: function (xhr, status, error){
                exportarError(xhr.responseText);
                wait.close();
              },
              success: function (json) {
                $('#slcNivel').html(json);
                wait.close();
              }
            });
    });

    $(document).on('click', '#btnConsultar', function(event) {
        event.preventDefault();
        var url_ajax = url + "registro_academico/procesos/cierre_curso";
        if($('#slcProyeccion').val()>0 || $('#slcDocente').val()>0) {
            var proyeccion = $('#slcProyeccion').val();
            var docente = $('#slcDocente').val();
            $("#filtro_proyeccion").val(proyeccion);
            $("#filtro_docente").val(docente);

            $("#dv_contenedor_cierre").hide('slide',{
                    direction:'right'
                },
                400,function(){
                    $.ajax({
                       url: url_ajax,
                         type: 'POST',
                         data: {proyeccion: $('#slcProyeccion').val(), docente:$('#slcDocente').val()},
                         dataType: 'text',
                         beforeSend: function () {
                             wait.start('Cargando..');
                         },
                         error: function (xhr, status, error){
                          exportarError(xhr.responseText);
                          wait.close();
                      },
                          success: function (json) {
                            // console.log(json);
                            wait.close();
                           // Hasta aqui termine y debo comprobar qe se muestre la tabla
                           $("#tbContenedorCierre").html(json);
                           $("#tblCierre").dataTable();
                           $("#dv_contenedor_cierre").show("slide", {
                                    direction: 'left'
                            }, 400);

                           $("#exportar").val(1);
                           

                      }
                    });
                }
            );

        } else {
            $(this).submit();
        }
    });

    $("#exportar").val(0);

    $(".exportar").click(function(event){
      event.preventDefault();
      if($("#exportar").val()==1){
        $("#frm_cierre").submit();
      }else{
        crear_alerta('error','Información', 'Debe filtrar la información a buscar');
      }
    });
    
}); // End jQuery

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}