$(document).ready(function () {
    $('#slcProyeccion').select2();
    $('#slcArea').select2();
    $('#slcGrupo').select2();

    $("#filtrar_consultaAsis").validate({
        ignore: "",
        rules: {
            proyeccion: {required: true},
            area: {required: true},
            grupo: {required: true}
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });

    $('#slcProyeccion').change(function(event) {
        event.preventDefault();
        url_ajax = window.satelite.base_url('registro_academico/procesos/select_areas_academica');

        if ($(this).val()>0) {
            $.ajax({
                 url: url_ajax,
                 type: 'POST',
                 data: {proyeccion:$(this).val()},
                 dataType: 'json',
                beforeSend: function () {
                  $("#slcArea").attr("placeholder","Cargando..."); 
                  $("#slcArea").attr('disabled', 'disabled');
                  $("#slcArea").select2();
                },
                error: function (xhr, status, error){
                  exportarError(xhr.responseText);
                  wait.close();
                },
                success: function (json) {
                  $('#slcArea').html(json.areas);                 
                  $("#slcArea").attr("placeholder","Seleccione");
                  $("#slcArea").removeAttr('disabled');
                  $("#slcArea").select2();
                     
              }

          });
        } else {
            $("#slcArea").val(0);
            $("#slcArea").select2();
            $("#slcGrupo").val(0);
            $("#slcGrupo").select2();

        }

    });

    $('#slcArea').change(function(event) {
        event.preventDefault();
        url_ajax = window.satelite.base_url('registro_academico/procesos/select_grupo_asistencia');

        if ($(this).val()>0 && $('#slcProyeccion').val()>0) {
            $.ajax({
                url: url_ajax,
                type: 'POST',
                data: {area: $(this).val(), proyeccion: $('#slcProyeccion').val()},
                dataType: 'json',
                beforeSend: function () {
                    $("#slcGrupo").attr("placeholder","Cargando..."); 
                    $("#slcGrupo").attr('disabled', 'disabled');
                    $("#slcGrupo").select2();
                 },
                 error: function (xhr, status, error){
                  exportarError(xhr.responseText);
                  wait.close();
              },
                  success: function (json) {
                    $('#slcGrupo').html(json.grupos);                
                    $("#slcGrupo").attr("placeholder","Seleccione"); 
                    $("#slcGrupo").removeAttr('disabled', 'disabled');
                    $("#slcGrupo").select2();
              }

          });
        } else {
            
        }

    });

    $(document).on('click', '#btnConsultar', function(event) {
        event.preventDefault();
        if ($('#slcProyeccion').val()>0) {
            $('#slcProyeccion_error').text('');
            if ($('#slcArea').val()>0) {
                $('#slcArea_error').text('');
                if ($('#slcGrupo').val()>0) {
                    $('#slcGrupo_error').text('');
                    
                    url_ajax = window.satelite.base_url('registro_academico/procesos/asistencia_grupo');
                    $.ajax({
                         url: url_ajax,
                         type: 'POST',
                         data: {proyeccion: $('#slcProyeccion').val(), area: $('#slcArea').val(), grupo: $('#slcGrupo').val()},
                         dataType: 'json',
                         beforeSend: function () {
                             wait.start('Cargando..');
                         },
                         error: function (xhr, status, error){
                          exportarError(xhr.responseText);
                          wait.close();
                      },
                          success: function (json) {
                              $('#tbContenedorAsistencia').html(json.html);                 
                              wait.close();
                      }

                  });
                    

                } else {
                    $('#slcGrupo_error').text('Campo requerido');   
                }
            } else {
                $('#slcArea_error').text('Campo requerido');  
                $('#slcGrupo_error').text('Campo requerido');   
            }
        } else {
            $('#slcProyeccion_error').text('Campo requerido');
            $('#slcArea_error').text('Campo requerido'); 
            $('#slcGrupo_error').text('Campo requerido');
        }
        
    });

    $("#slcGrupo").on("change", function() {
        var grupo = $(this).val();
        var url = url_base_proyecto + "registro_academico/procesos/lista_asistencia";
        if (grupo != "") {
            $("#btnAgregar").attr("href", url + "/" + grupo);
            // console.log("Se ha cambiado el grupo");
        } else {
            $("#btnAgregar").attr("href", url);
        }
    });

});