$(document).ready(function() {
    $('select').select2();
    $(".fecha").datepicker({dateFormat: 'yy-mm-dd',changeMonth: true, changeYear: true});
    $(".fecha").mask("9999-99-99");
    $(".fecha").attr('placeholder',"yyyy-mm-dd");

    $(".exportar").hide();

    $(document).on('change', '#txtfechaInicio', function(event) {
        validar_fecha_inicio_fin('txtfechaInicio', 'txtfechaFin');

        f1 = $('#txtfechaInicio').val();
        f2 = $('#txtfechaFin').val();

        if (f1 != '' && f2 != '') {
            var aFecha1 = f1.split('-');
            var aFecha2 = f2.split('-');

            var fecha_armada_1 = aFecha1[0] + '-' + aFecha1[1] + '-' + aFecha1[2] + ' 00:00:00';
            var fecha_armada_2 = aFecha2[0] + '-' + aFecha2[1] + '-' + aFecha2[2] + ' 23:00:00';

            var fecha_inicio = Date.parse(fecha_armada_1);
            var fecha_fin = Date.parse(fecha_armada_2);

            var diff = fecha_fin - fecha_inicio;
            var diferencia = Math.round(diff / (1000 * 60 * 60 * 24));

            if (diferencia <= 18) {
                // console.log('menos de 18');
            } else{
                crear_alerta('error', 'Información', 'No debe exceder más de 18 dias');
                $('#txtfechaInicio').val('');
                $('#txtfechaFin').val('');
            }
        }

        $("#filtro_fechaInicio").val($(this).val());
    });

    $(document).on('change', '#txtfechaFin', function(event) {
        validar_fecha_inicio_fin('txtfechaInicio', 'txtfechaFin');
        
        f1 = $('#txtfechaInicio').val();
        f2 = $('#txtfechaFin').val();

        if (f1 != '' && f2 != '') {
            var aFecha1 = f1.split('-');
            var aFecha2 = f2.split('-');

            var fecha_armada_1 = aFecha1[0] + '-' + aFecha1[1] + '-' + aFecha1[2] + ' 00:00:00';
            var fecha_armada_2 = aFecha2[0] + '-' + aFecha2[1] + '-' + aFecha2[2] + ' 23:00:00';

            var fecha_inicio = Date.parse(fecha_armada_1);
            var fecha_fin = Date.parse(fecha_armada_2);

            var diff = fecha_fin - fecha_inicio;
            var diferencia = Math.round(diff / (1000 * 60 * 60 * 24));

            if (diferencia <= 18) {
                // console.log('menos de 18');
            } else{
                crear_alerta('error', 'Información', 'No debe exceder más de 18 dias');
                $('#txtfechaInicio').val('');
                $('#txtfechaFin').val('');
            }
        }
        
        $("#filtro_fechaFin").val($(this).val());
    });

    $(document).on('change', '#slcProyeccion', function() {

        var proyeccion = $(this).val(); 
        if(proyeccion>0){
            $("#filtro_proyeccion").val(proyeccion);
            $.ajax({
                type:'post',
                dataType:'json',
                url:window.gSateliteWhite.baseUrl('registro_academico/consultas/ajax_cargar_area'),
                data:{proyeccion:proyeccion},
                beforeSend:function(){
                    
                },
                success:function(data){
                    // console.log(data);
                    if (data.length > 0) {
                        $("#lblarea").text(data[0].ard_nombre);
                        $("#txtarea").val(data[0].ard_id);
                        $("#filtro_area").val(data[0].ard_id);
                    }
                }
            });
            $.ajax({
                type:'post',
                dataType:'json',
                url:window.gSateliteWhite.baseUrl('registro_academico/consultas/ajax_grupoxproyeccion'),
                data:{area:$("#txtarea").val(), proyeccion: $('#slcProyeccion').val()},
                beforeSend:function(){
                    
                },
                success:function(data){
                    // console.log(data);
                    if (data.length > 0) {
                        $("#slcGrupo").html(data);
                    } else {
                        $("#slcGrupo").val(0);
                        $("#slcGrupo").select2();
                    }
                }
            });
            $("#lbldocente").text('');
            $("#slcGrupo").val(0);
            $("#slcGrupo").select2();
        }else{
            $("#lblarea").text('');
            $("#txtarea").val();
            $("#slcGrupo").val(0);
            $("#slcGrupo").select2();
            $("#lbldocente").text('');

        }
    });
    $(document).on('click', '#btnConsultar', function(event) {
        event.preventDefault();

        var proyeccion = $('#slcProyeccion').val();
        var area = $('#txtarea').val();
        var grupo = $('#slcGrupo').val();
        var fechaInicio = $('#txtfechaInicio').val();
        var fechaFin = $('#txtfechaFin').val();

        if (grupo != '' && proyeccion != '' && fechaInicio != '' && fechaFin != '') {
            $.ajax({
                 url:  urlj + "registro_academico/consultas/asistencia_alumnos/1",
                 type: 'POST',
                 data: {area: area, grupo: grupo, proyeccion:proyeccion, fechaInicio:fechaInicio, fechaFin:fechaFin},
                 dataType: 'text',
                 beforeSend: function () {
                     wait.start('Cargando..');
                 },
                 error: function (xhr, status, error){
                  exportarError(xhr.responseText);
                  wait.close();
              },
                  success: function (json) {
                    wait.close();
                    // console.log(json);
                    $('.exportar').show('slow');
                    // $("#tblContenedor").dataTable().fnDestroy();
                    $("#dv_contenedor").html(json);
                    aplidarDataTable('tblContenedor');
                    $("#exportar").val(1);
                    
              }

            });
        } else {
            crear_alerta('error','Información', 'Debe filtrar la información a buscar(Obligatorios Proyeccion, Grupo, Fecha Inicio, Fecha Fin)');
        }

    });

    $("#exportar").val(0);

    $(".exportar").click(function(event){
      event.preventDefault();
        var proyeccion = $("#slcProyeccion").val();
        var area = $('#txtarea').val();
        var grupo = $('#slcGrupo').val();

        $('#filtro_proyeccion').val(proyeccion);
        $('#filtro_area').val(area);
        $('#filtro_grupo').val(grupo);
      if($("#exportar").val()==1){
        $("#frm_contenedor").submit();
      }else{
        crear_alerta('error','Información', 'Debe filtrar la información a buscar');
      }
    });

    $("body").on("change", "#slcGrupo", function() {
        var grupo = $(this).val();
        if (grupo > 0) {
            $.ajax({
                type:'post',
                dataType:'json',
                url:window.gSateliteWhite.baseUrl('registro_academico/consultas/ajax_cargar_docentexgrado'),
                data:{grupo: grupo},
                beforeSend:function(){
                    
                },
                success:function(data){
                    if($.trim(data.docente) != "") {
                        $("#lbldocente").text(data.docente);
                    }                    
                }
            });            
        } else {
            $("#lbldocente").text('');
        }
    });
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}
