$(document).ready(function() {
    $('select').select2();
    $('.exportar').hide();

    $(document).on('change', '#slcProyeccion', function() {
        var proyeccion = $(this).val(); 
        if(proyeccion>0){
            $("#filtro_proyeccion").val(proyeccion);
            $.ajax({
                type:'POST',
                url:window.gSateliteWhite.baseUrl('registro_academico/consultas/ajax_get_areas'),
                data:{proyeccion:proyeccion},
                beforeSend:function(){
                    wait.start();
                },
                success:function(data){
                    wait.close();
                    $("#txtarea").html(data);
                    $("#txtarea").select2();
                }
            });
        }else{
            $("#filtro_proyeccion, #filtro_area, #filtro_grupo").val("");
            $("#txtarea, #slcGrupo").html("<option></option>");
            $("#txtarea").select2();
            $("#slcGrupo").select2();
        }
    });

    $(document).on('change', '#txtarea', function() {
        if ($(this).val() > 0) {
            $("#filtro_area").val($(this).val());
            $.ajax({
                type:'post',
                dataType:'json',
                url:window.gSateliteWhite.baseUrl('registro_academico/consultas/ajax_grupoxproyeccion'),
                data:{area:$("#txtarea").val(), proyeccion: $('#slcProyeccion').val()},
                beforeSend:function(){
                    wait.start();
                },
                success:function(data){
                    wait.close();
                    if (data.length > 0) {
                        $("#slcGrupo").html(data);
                    } else {
                        $("#slcGrupo").html("<option></option>");
                    }
                    $("#slcGrupo").select2();
                }
            });
        } else {
            $("#filtro_area, #filtro_grupo").val("");
            $("#slcGrupo").html("<option></option>");
            $("#slcGrupo").select2();
        }
    });

    $(document).on('change', '#slcGrupo', function() {
        if ($(this).val() > 0) {
            $("#filtro_grupo").val($(this).val());
        } else {
            $("#filtro_grupo").val("");
        }
    });

    $(document).on('click', '#btnConsultar', function(event) {
        event.preventDefault();
        var proyeccion = $('#slcProyeccion').val();
        var area = $('#txtarea').val();
        var grupo = $('#slcGrupo').val();
        if (proyeccion != '') {
            $.ajax({
                url:  urlj + "registro_academico/consultas/alumnosxarea_grupo/1",
                type: 'POST',
                data: {area: area, grupo: grupo, proyeccion:proyeccion},
                dataType: 'json',
                beforeSend: function () {
                    wait.start('Cargando..');
                },
                error: function (xhr, status, error){
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function (json) {
                    $('.exportar').show('slow');
                    $("#tblContenedor").dataTable().fnDestroy();
                    $("#dv_contenedor").html(json.detalle);
                    console.log(json.tipo);
                    if(json.tipo>0){
                        $("#talonario_cuotas").show('slow');
                    }else{
                        $("#talonario_cuotas").hide();
                    }
                    aplidarDataTable('tblContenedor');
                    $("#exportar").val(1);
                    wait.close();
              }

            });
        } else {
            crear_alerta('error','Información', 'Debe filtrar la información a buscar');
        }

    });

    $("#exportar").val(0);

    $(".exportar").click(function(event){
        event.preventDefault();
        var proyeccion = $("#slcProyeccion").val();
        var area = $('#txtarea').val();
        var grupo = $('#slcGrupo').val();
        $('#filtro_proyeccion').val(proyeccion);
        $('#filtro_area').val(area);
        $('#filtro_grupo').val(grupo);
        if($("#exportar").val()==1){
            $("#frm_contenedor").submit();
        }else{
            crear_alerta('error','Información', 'Debe filtrar la información a buscar');
        }
    });

});




    function mostrar_fancy_box(valor){
        $.fancybox( $("#divform"+valor).html(), {
                'width'  : 900,           // set the width
                'height' : 500,           // set the height
                'onStart': function() { $("#divform"+valor).css("display","block"); },            
                'onClosed': function() { $("#divform"+valor).css("display","none"); }
        });    
    }

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}