$(document).ready(function() {
    $(".fecha").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
    $(".fecha").mask("99-99-9999");
    $(".fecha").attr('placeholder',"dd-mm-yyyy");

    $(".exportar").hide();

    $(document).on('change', '#txtfechaDesde', function(event) {
        validar_fecha_inicio_fin('txtfechaDesde', 'txtfechaHasta');
    });

    $(document).on('change', '#txtfechaHasta', function(event) {
        validar_fecha_inicio_fin('txtfechaDesde', 'txtfechaHasta');
    });

    $(document).on('click', '#btnConsultar', function(event) {
        event.preventDefault();

        var fechaDesde = $('#txtfechaDesde').val();
        var fechaHasta = $('#txtfechaHasta').val();

        if (fechaDesde != '' && fechaHasta != '') {
            $.ajax({
                 url:  urlj + "registro_academico/consultas/alumnos_con_beneficio/1",
                 type: 'POST',
                 data: {fechaDesde: fechaDesde, fechaHasta: fechaHasta},
                 dataType: 'text',
                 beforeSend: function () {
                     wait.start('Cargando..');
                 },
                 error: function (xhr, status, error){
                  exportarError(xhr.responseText);
                  wait.close();
              },
                  success: function (json) {

                    console.log(json);
                    $('.exportar').show('slow');
                    $("#tblContenedor").dataTable().fnDestroy();
                    $("#tbContenedor").html(json);
                    aplidarDataTable('tblContenedor');
                    $("#exportar").val(1);
                    wait.close();
              }

            });
        } else {
            crear_alerta('error','Información', 'Debe filtrar la información a buscar');
        }

    });

    $("#exportar").val(0);

    $(".exportar").click(function(event){
      event.preventDefault();
        var fechaDesde = $('#txtfechaDesde').val();
        var fechaHasta = $('#txtfechaHasta').val();

        $('#filtro_fechaDesde').val(fechaDesde);
        $('#filtro_fechaHasta').val(fechaHasta);
      if($("#exportar").val()==1){
        $("#frm_contenedor").submit();
      }else{
        crear_alerta('error','Información', 'Debe filtrar la información a buscar');
      }
    });

});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}