jQuery(document).ready(function($) {
	window.gSateliteWhite.jsSelect();

	$("#chkFactura").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        change: function (element) {
            if (element.is(':checked')) {
            	$("#id_check").val(1);
                $("#slcFactura option:first").attr('selected','selected')
                $("#slcFactura").select2();

                $("#slcFactura").select2('disable'); 
            } else {
            	$("#id_check").val(0);
                $("#slcFactura").select2('enable');
            }
        }
    });

    $("#chkModalidad").iButton({
        'labelOn': "Educ. Virtual",
        'labelOff': "Presencial",
        'resizeHandle': false,
        change: function (element) {
            if (element.is(':checked')) {
                $("#hdnModalidadEdu").val(1);
            } else {
                $("#hdnModalidadEdu").val(0);
            }
        }
    });
  
    $("#chkUbicacion").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        change: function (element) {
            if (element.is(':checked')) {
                $("#id_ubic").val(1);
                cargar_pensum($("#slcArea").val(), $("#slcAlumno").val(), 1, 1, $("#slcProyeccion").val());
            } else {
                $("#id_ubic").val(0);
                cargar_pensum($("#slcArea").val(), $("#slcAlumno").val(), null, 1, $("#slcProyeccion").val());
            }
        }
    });
     window.setTimeout(function(){ 
        $("#chkActivos").iButton('destroy');
        $("#chkActivos").iButton({
            'labelOn': 'Si',
            'labelOff': 'No',
            change: function (element) {
                if (element.is(':checked')) {
                    $("#id_activos").val(1);
                } else {
                    $("#id_activos").val(2);
                }
            var id_alm = $("#slcAlumno").val(); 
            var area = $("#slcAreaHist").val();
            var activo = $("#id_activos").val();
        
            if(id_alm>0){
                cargar_historial(id_alm, area, activo);
            }else{
                $("#contenedor_historial").html('');
            }

            }
        });

    });


	$("#slcAlumno").select2({
        placeholder: "Buscar Alumno",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'registro_academico/procesos/get_alumnos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (alumno) {
                return {
                    alumno: alumno
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.alumno,
                        'text': item.alm_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('text');
                callback({id: valor, text: texto});
            }
        }
    });



	$("#slcAlumno").change(function(event) {
		var id_alm = $(this).val(); 
        var area = $("#slcAreaHist").val();
        var activo = $("#id_activos").val();
        var areaP = $("#slcArea").val();

        //lxa_id

        if(id_alm>0){
            cargar_facturas(id_alm, areaP);
            cargar_historial(id_alm, area, activo);
            cargar_areaxalumno(id_alm);
            //cargar_proyeccionxalumno(id_alm);
        }else{
            $("#contenedor_historial").html('');
            $("#slcFactura").removeAttr('disable');
            $("#slcFactura").select2();
            $("#hdnBeca").val(0);
        }
	});

    if($("#slcAlumno").val()>0){
        $("#slcAlumno").trigger('change');
     }

    $("#slcAreaHist").change(function(event) {
        var id_alm = $("#slcAlumno").val(); 
        var area = $("#slcAreaHist").val();
        var activo = $("#id_activos").val();

        if(id_alm>0){
            cargar_historial(id_alm, area, activo);
        }else{
            $("#contenedor_historial").html('');
        }
    });

    $("#slcProyeccion").change(function(event) {
      var proyeccion = $(this).val();
      var alumno = $("#slcAlumno").val();

      if(proyeccion>0){
        if(alumno>0){
            wait.start();
            $.ajax({
              type: "POST",
              dataType:'json',
              url: urlj+"registro_academico/procesos/get_info_proyeccion",
              data: { proyeccion: proyeccion, alumno: alumno, flag_inscripcion: 1 },
              beforeSend: function(){

                $("#slcArea").attr("placeholder", "Cargando...");
                $("#slcArea").select2();
              },
              success: function(data){

                if (data.flag_no_cumple_max_inscripcion) {
                    crear_alerta('warning', 'Fecha de inscripción', 'La fecha máxima de inscripción ha sido sobrepasada');
                }

                $("#slcArea").html(data.areas);
                $("#slcArea").attr("placeholder", "Seleccione");
                $("#slcArea").select2();  
                
                $("#contenedor_detalle").html('');

                wait.close();
              }
            });
        }else{
            crear_alerta('info', 'Alumno', 'Debe seleccionar un alumno');

            $("#slcProyeccion option:first").attr('selected', 'selected');
            $("#slcProyeccion").select2();
            $("#slcFrecuencia").html('<option value=""></option>');
            $("#slcFrecuencia option:first").attr('selected', 'selected');
            $("#slcFrecuencia").select2();

            $("#slcArea").attr("placeholder", "Seleccione");
            $("#slcArea").html('<option value=""></option>');
            $("#slcArea option:first").attr('selected','selected');
            $("#slcArea").select2();
        }
      }else{

        $("#div_grado").show();

        $("#slcNivel").attr("placeholder","Seleccione");
        $("#slcNivel").html('<option value=""></option>');
        $("#slcNivel").select2();
        $("#slcNivel").trigger('change');

        $("#slcFrecuencia").html('<option value=""></option>');
        $("#slcFrecuencia option:first").attr('selected', 'selected');
        $("#slcFrecuencia").select2();

        $("#slcArea").attr("placeholder", "Seleccione");
        $("#slcArea").html('<option value=""></option>');
        $("#slcArea option:first").attr('selected','selected');
        $("#slcArea").select2();
      }
    });

    $("#slcArea").change(function(event) {
        var area = $(this).val();
        var alumno = $("#slcAlumno").val();
        var proyeccion = $("#slcProyeccion").val();
        var examen = $("#id_ubic").val();
  
        if(area>0){
              wait.start();
              $.ajax({
                type: "POST",
                dataType:'json',
                url: urlj+"registro_academico/procesos/get_info_area",
                data: {area: area, alumno: alumno},
                beforeSend: function(){

                    $("#slcGrado").attr("placeholder", "Cargando...");
                    $("#slcGrado").select2();

                    $("#slcNivel").attr("placeholder", "Cargando...");
                    $("#slcNivel").select2();

                    $("#slcFrecuencia").attr("placeholder", "Cargando...");
                    $("#slcFrecuencia").select2();

                },
                success: function(data){

                    if(data.edad_alumno) {
                        if ((data.edad_minima && data.edad_alumno < data.edad_minima) || (data.edad_maxima && data.edad_alumno > data.edad_maxima)) {
                            crear_alerta('info', 'Alumno', 'El alumno esta fuera del rango de edad permitido');
                            $("#slcArea").select2("val",'');
                            wait.close();
                            return false;
                        }
                    }
                    
  
                    if(data.verificar_flag_curso) {
                        $("#div_grado").hide();

                        $("#slcGrado").attr("placeholder","Seleccione");
                        $("#slcGrado").html('<option value=""></option>');
                        $("#slcGrado").select2();
                    } else {
                        $("#div_grado").show();

                        $("#slcGrado").attr("placeholder","Seleccione"); 
                        $("#slcGrado").html(data.grados);
                        $("#slcGrado").select2();
                    }
                  
                    cargar_pensum(area, alumno, examen, 1, proyeccion);
                    cargar_frecuencia(area);

                    cargar_facturas(alumno, area);
                    $("#contenedor_detalle").html('');
    
                    wait.close();
                }
              });
        }else{

            $("#slcGrado").attr("placeholder","Seleccione");
            $("#slcGrado").html('<option value=""></option>');
            $("#slcGrado").select2();

            $("#div_grado").show();

            $("#slcNivel").attr("placeholder","Seleccione");
            $("#slcNivel").html('<option value=""></option>');
            $("#slcNivel").select2();
            $("#slcNivel").trigger('change');
    
            $("#slcFrecuencia").html('<option value=""></option>');
            $("#slcFrecuencia option:first").attr('selected', 'selected');
            $("#slcFrecuencia").select2();
        }
    });


    $("#slcFrecuencia").change(function(event) {
        var frecuencia = $(this).val();
        var nivel = $("#slcNivel option:selected").attr('pen');
        var area = $("#slcArea").val();
        var proyeccion = $("#slcProyeccion").val();
        var alumno = $("#slcAlumno").val();
        var grupo = $("#slcGrupo").val();
        var id_frh = $("#slcGrupo option:selected").data('frh');

        if(frecuencia>0){
            $.ajax({
                url: urlj + "registro_academico/procesos/validar_horario_alumno",
                type: 'POST',
                async: false,
                data: {frecuencia: frecuencia, alumno:alumno, proyeccion: proyeccion},
                dataType: 'json',
                beforeSend: function () {
                    wait.start('Cargando..');
                },
                error: function (xhr, status, error){
                  exportarError(xhr.responseText);
                  wait.close();
                },
                success: function (json) {
                    estado = parseInt(json.exito);
                    if(estado>0){
                        crear_alerta('error', 'Frecuencia', 'El alumno ya esta inscrito en ese horario en otro grupo.');
                        $("#slcFrecuencia option:first").attr('selected', 'selected');
                        $("#slcFrecuencia").select2();
                    }
                    wait.close();
                }
            });

            $.ajax({
                type:'post',
                dataType:'json',
                url:window.gSateliteWhite.baseUrl('registro_academico/procesos/get_detalles_frecuencia'),
                data:{frecuencia:frecuencia},
                success:function(data){
                    $("#contenedor_frecuencia").html(data);                 
                }
            });
            
            if(nivel>0 && area>0 && frecuencia != id_frh){
                cargar_gruposxnivel(nivel, area, frecuencia, proyeccion);
            }
        }else{
            $("#contenedor_frecuencia").html('');
        }
    });

     $("#slcFactura").change(function(){
            var factura = $(this).val();
            var alumno = $("#slcAlumno").val();
            var area = $("#slcArea").val();
            var tipo = $("#id_ubic").val();
            var beca = $("#hdnBeca").val();
            
            if($.trim(factura) == '' && beca != 0){
                factura = beca;
            }
            if($.trim(factura) != ""){
                if(area!=''){
                    $.ajax({
                        dataType: 'json',
                        type: 'post',
                        data: {alumno: alumno, factura: factura, area:area, tipo:tipo, beca:beca},
                        url: urlj + 'registro_academico/procesos/mostrar_niveles',
                        success: function (data) {
                            if(data.complete){
                                $("#slcNivel").html(data.select);
                                $("#slcNivel").select2();
                            }
                        }
                    });
                }else{
                    crear_alerta('info', 'Área', 'Debe seleccionar la proyección.');
                    $("#slcNivel").html('<option value=""></option>');
                    $("#slcFactura").html('<option value=""></option>');
                    $("#slcNivel, #slcFactura").select2();
                }
            }else{
                $("#slcNivel").html('<option value=""></option>');
                $("#slcNivel").select2();
            }
        });

     $("#slcGrado").change(function(event) {
        if($(this).val()>0){
            grado = $(this).val();
            $("#id_grado").val(grado);

            $.ajax({
                dataType: 'json',
                type: 'post',
                data: {grado: grado},
                url: urlj + 'registro_academico/procesos/validar_cupos',
                success: function (data) {
                    if (data.complete == true) {
                        inscritos = data.inscritos;
                        preinscritos = data.preinscritos;
                        crear_alerta('error', 'Grupo Académico Completo', 'Ya superó la cantidad máxima de alumnos \n Inscritos: '+inscritos+' \n Pre-inscritos: '+preinscritos);
                        return false;
                    } 
                }
            });

            $.ajax({
                type: "POST",
                dataType:'json',
                url: urlj+"registro_academico/procesos/get_cargos_grd",
                data: {grado: grado},
                success: function(data){
                    $("#contenedor_detalle").html(data.html);
                    $("#id_cfg").val(data.cfg_id);
                    console.log($("#id_cfg").val());
                    wait.close();
                }
            });

            cargar_tipo_listado_precio(grado, 'grado');

            $("#slcFrecuencia").select2('disable');
            $("#slcNivel").select2('disable');
            $("#slcGrupo").select2('disable');
        }else{
            $("#slcFrecuencia").select2('enable');
            $("#slcNivel").select2('enable');
            $("#slcGrupo").select2('enable');
        }
    });



    $("#slcNivel").change(function(event) {
        if($(this).val()>0){
            $("#slcGrado").select2('disable');
            var nivel = $("#slcNivel option:selected").attr('pen');
            var area = $("#slcArea").val();
            var proyeccion = $("#slcProyeccion").val();
            cargar_gruposxnivel(nivel, area, null, proyeccion);

            cargar_tipo_listado_precio(nivel, 'curso');
        }else{
            $("#slcGrado").select2('enable');
            $("#slcGrupo option:first").attr('selected', 'selected');
            $("#slcGrupo").html('<option value=""></option>');
            $("#slcGrupo").select2();

            $("#slcFrecuencia option:first").attr('selected', 'selected');
            $("#slcFrecuencia").select2();

            $("#lblAula").text('');
            $("#lblSeccion").text('');
        }
    });

    $("#slcGrupo").change(function(event) {
      var grupo = $(this).val();
      var materia = $("#slcNivel").val(); 

      if(grupo>0){
        wait.start();
        $.ajax({
          type: "POST",
          dataType:'json',
          url: urlj+"registro_academico/procesos/get_info_grupo",
          data: {grupo: grupo},
          beforeSend: function(){
            $("#lblAula").text('');
            $("#lblSeccion").text('');
          },
          success: function(data){
            $("#lblAula").text(data.aula ?? '');
            $("#lblSeccion").text(data.seccion ?? '');
            //$("#id_grado").val(data.grado);
            $("#slcFrecuencia option[value="+data.frecuencia+"]").attr('selected', 'selected');
            $("#slcFrecuencia").select2();
            $("#slcFrecuencia").trigger('change');
            wait.close();
          }
        });


        $.ajax({
            dataType: 'json',
            type: 'post',
            data: {grupo: grupo},
            url: urlj + 'registro_academico/procesos/validar_cupos',
            success: function (data) {
                if (data.complete == true) {
                    inscritos = data.inscritos;
                    preinscritos = data.preinscritos;
                    crear_alerta('error', 'Grupo Académico Completo', 'Ya superó la cantidad máxima de alumnos \n Inscritos: '+inscritos+' \n Pre-inscritos: '+preinscritos);

                    return false;
                } 
            }
        });

        $.ajax({
            type: "POST",
            dataType:'json',
            url: urlj+"registro_academico/procesos/get_cargos_grd",
            data: {grupo: grupo, materia: materia},
            success: function(data){
                $("#contenedor_detalle").html(data.html);
                $("#id_cfg").val(data.cfg_id);
                //console.log($("#id_cfg").val());
                wait.close();
            }
        });

      }else{
        $("#lblAula").text('');
        $("#lblSeccion").text('');
        $("#contenedor_detalle").html('');
      }
    });


    $("#frm_inscripcion").validate({
		ignore: ".select2-container",
		rules: {
			slcAlumno:{ required:true, min:1},
			slcProyeccion:{ required:true, min:1},
			slcEstadoReg: { required:true, min:1},
            slcArea: { required: true, min: 1 },
			/*slcNivel: {required:true, min:1},
            slcFrecuencia: {required:true, min:1},
            slcGrupo: {required:true, min:1}*/
		}, 
		messages: {
			slcAlumno: "Campo requerido",
			slcProyeccion: "Campo requerido",
			slcEstadoReg: "Campo requerido",
            slcArea: "Campo requerido"
			/*slcNivel: "Campo requerido",	
            slcFrecuencia: "Campo requerido", 
            slcGrupo: "Campo requerido"*/
		},
		errorPlacement: function (error, element) {
			var nombre = $(element).attr("id");
            var grado = $("#slcGrado").val();
            var frecuencia = $("#slcFrecuencia").val();
            var nivel = $("#slcNivel").val();
            var grupo = $("#slcGrupo").val();
			$('#'+nombre+'_error').text('Campo requerido');	
            /****************************** Validar dropdowns ************************************/
            if(grado<=0 && nivel<=0){
                crear_alerta('error', 'Inscripción de alumno', 'Debe seleccionar un grado o curso.');
                wait.close();
                return false;
            }
            /*if(nivel<=0 || frecuencia<=0 || grupo <= 0 ){
                crear_alerta('error', 'Inscripción de alumno', 'Debe completar los campos requeridos.');
                return false;
            }*/
            /************************************ Validar factura *********************************/
			if($("#slcEstadoReg").val()==2 && $("#id_check").val()==0 && $("#slcFactura").val()<=0){
                $("#slcFactura_error").text('Campo requerido');
                wait.close();            
                return false;
            }
        },
        submitHandler: function(form) {	
            var grado = $("#slcGrado").val();
            var frecuencia = $("#slcFrecuencia").val();
            var nivel = $("#slcNivel").val();
            var grupo = $("#slcGrupo").val();
            var area = $("slcArea").val();
            /****************************** Validar dropdowns ************************************/
            if(grado<=0 && nivel<=0){
                crear_alerta('error', 'Inscripción de alumno', 'Debe seleccionar un grado o curso.');
                wait.close();
                return false;
            }
            /*if(nivel<=0 || frecuencia<=0 || grupo <= 0){
                crear_alerta('error', 'Inscripción de alumno', 'Debe completar los campos requeridos.');
                return false;
            }*/
            /********************************** Validar factura ***********************************/
			if($("#slcEstadoReg").val()==2 && $("#id_check").val()==0 && $("#slcFactura").val()<=0){
                $("#slcFactura_error").text('Campo requerido');
                wait.close();
                return false;
            }else{
                $("#slcFactura_error").text('');
                form.submit();
            }
        }
	});

    $(document).on('change', '#slcEstadoReg', function() {
        if ($(this).val() > 0) {
            if ($(this).val() == 1) {
                if ($("#chkFactura").prop('checked') == false) {
                    $("#chkFactura").iButton('toggle');
                    $("#id_check").val(1);
                }
            }

            if ($(this).val() == 2) {
                if ($("#chkFactura").prop('checked') == true) {
                    $("#chkFactura").iButton('toggle');
                    $("#id_check").val(0);
                }
            }
        }
    });

});//End jQuery

function cargar_pensum(id_area, alumno=null, examen=null, verif_grupo=null, proyeccion=null){
    if($("#slcFactura").val()<=0){
        $.ajax({
            type: "POST",
            dataType: "json",
            url: urlj+"registro_academico/procesos/cargar_pensum_inscripcion",
            data: {id: id_area, alumno: alumno, examen: examen, verif_grupo: verif_grupo, proyeccion: proyeccion},
        beforeSend:function(){
            /*$("#slcGrado").attr("placeholder","Cargando..."); 
            $("#slcGrado").select2();*/

            $("#slcNivel").attr("placeholder","Cargando..."); 
            $("#slcNivel").select2();
        },
        success:function(data){
            /*$("#slcGrado").attr("placeholder","Seleccione"); 
            $("#slcGrado").html(data.pensum_grd);
            $("#slcGrado").select2();*/

            $("#slcNivel").attr("placeholder","Seleccione"); 
            $("#slcNivel").html(data.pensum);
            $("#slcNivel").select2();

            $("#slcGrupo").html('<option value=""></option>');
            $("#slcGrupo").select2();
            $("#lblAula, #lblSeccion").text('');
        }
        });
    }
}



function cargar_frecuencia(id_area){
    $.ajax({
        type: "POST",
        url: urlj+"registro_academico/procesos/cargar_frecuencia",
        data: {area: id_area},
        beforeSend:function(){
            $("#slcFrecuencia").attr("placeholder","Cargando..."); 
            $("#slcFrecuencia").select2();
        },
        success:function(html){
            $("#slcFrecuencia").attr("placeholder","Seleccione");
            $("#slcFrecuencia").html(html);
            $("#slcFrecuencia").select2();
        }
    });
}

function cargar_historial(id_alm=null, area=null, activo=null){
    $.ajax({
        type:'post',
        url:window.gSateliteWhite.baseUrl('registro_academico/procesos/get_historial_alumno'),
        data:{id_alm: id_alm, area: area, activo: activo},
        beforeSend:function(){
            wait.start('Espere un momento... Obteniendo historial del alumno');
        },
        success:function(data){
            $("#contenedor_historial").html(data);                      
            wait.close();
        }
    });
}

function cargar_areaxalumno(alumno){
    $.ajax({
        type: "POST",
        dataType: 'json',
        url: urlj+"registro_academico/procesos/cargar_areas_alumno",
        data: {alumno: alumno},
    }).done(function(html){
        $("#slcAreaHist").html(html.option).select2();
        $("#slcAreaHist").select2();

        if(html.becado>0){
            crear_alerta('info', 'Alumno', 'El alumno posee beca.');
            $("#slcFactura").select2('disable');
            $("#hdnBeca").val(1);
        }
    });
}

function cargar_facturas(alumno, area){
    $.ajax({
        type: "POST",
        dataType: 'json',
        url: urlj+"registro_academico/procesos/cargar_facturas_alumno",
        data: {alumno: alumno, area: area},
    }).done(function(html){
        $("#slcFactura").html(html.facturas).select2();
        $("#slcFactura").select2();

        if(html.becado>0){
            crear_alerta('info', 'Alumno', 'El alumno posee beca.');
            $("#hdnBeca").val(1);
            $("#slcFactura").select2('disable');
        }
    });
}

function cargar_gruposxnivel(nivel, area, frecuencia=null, proyeccion=null){
    $.ajax({
        type: "POST",
        url: urlj+"registro_academico/procesos/cargar_gruposxnivel",
        data: {nivel: nivel, area: area, frecuencia: frecuencia, proyeccion: proyeccion},
        beforeSend:function(){
            $("#slcGrupo").attr("placeholder","Cargando..."); 
            $("#slcGrupo").select2();
        },
        success:function(data){
            $("#slcGrupo").attr("placeholder","Seleccione");
            $("#slcGrupo").html(data);
            $("#slcGrupo").select2();
        }
    });
}

/*function cargar_proyeccionxalumno(alumno){
    $.ajax({
        type: "POST",
        dataType: 'json',
        url: urlj+"registro_academico/procesos/cargar_proyeccionxalumno",
        data: {alumno: alumno},
    }).done(function(html){
            $("#slcProyeccion").html(html.proyeccion).select2();
            $("#slcProyeccion").select2();
    });
}*/

function cargar_tipo_listado_precio(id, tipo) {
    $.ajax({
        type: "POST",
        url: urlj+"registro_academico/procesos/cargar_tipo_listado_precio",
        dataType:'json',
        data: {id: id, tipo: tipo},
        beforeSend:function(){
            $("#slcListaPrecio").attr("placeholder","Cargando..."); 
            $("#slcListaPrecio").select2();
        },
        success:function(data){

            if(data.existencias_tlp == 1) {
                $("#slcListaPrecio").attr("placeholder", "Seleccione");
                $("#slcListaPrecio").html(data.tipo_listado_precios);
                $("#slcListaPrecio").select2();
                $("#crear", "#crear_v").prop('disabled', false);
            } else {
                crear_alerta('error', 'Lista de precio.', 'No se encontraron listados de precios relacionados al ' + tipo +'. Por favor debe de registrar uno');
                $("#slcListaPrecio").attr("placeholder","Seleccione");
                $("#slcListaPrecio").html('<option value=""></option>');
                $("#slcListaPrecio").select2();
                $("#crear", "#crear_v").prop('disabled', true);
            }

            
        }
    });
}

