jQuery(document).ready(function($) {
	window.gSateliteWhite.jsSelect();

	$(".fecha").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
   $(".fecha").mask("99-99-9999");

   $("#chkEmple").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        change: function (element) {
            if (element.is(':checked')) {
            	$("#id_check").val(2);
            } else {
            	$("#id_check").val(1);
            }
        }
    });

    if($("#txt_idPcf").length>0 && $("#id_check").val()==1){
    	$("#chkEmple").attr( "checked" );
 		$("#chkEmple").iButton('repaint');
 	}


    $("#frm_practica").validate({
		ignore: ".select2-container",
		rules: {
			txtFecha_ini:{ required:true},
			txtFecha_fin:{ required:true},
			slcLugar: { required:true, min:1},
			txtObjetivo: { required:true},
			txtPlaza: {required:true},
		}, 
		messages: {
			txtFecha_ini: "Campo requerido",
			txtFecha_fin: "Campo requerido",
			slcLugar: "Campo requerido",
			txtObjetivo: "Campo requerido",
			txtPlaza: "Campo requerido"
		},
		errorPlacement: function (error, element) {
			var nombre=$(element).attr("id");
			$('#'+nombre+'_error').text('Campo requerido');
		},
		submitHandler: function(form) {	
		    form.submit();	
		}
	});

});//End jQuery


