$(document).ready(function(event) {
    var url = url_base_proyecto;
    $("select").select2();
    $(".fecha").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
    $(".fecha").mask("99-99-9999");
    $(".fecha").attr('placeholder',"dd-mm-yyyy");

    $("#frm_agregarhorariosupervisor").validate({
        ignore: "",
        rules: {
            slcSupervisor: {required: true},
            txtfechainicio: {required: true},
            txtfechafin: {required: true},
            slcRemunerada: {required: true}
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });

    $(document).on('change', '#slcEscalafon', function(event) {
        var escalafon = $(this).val();
        if (escalafon>0) {
            // Escalafon para supervisor
            $.ajax({
                     url: url + "registro_academico/procesos/ajax_escalafon",
                     type: 'POST',
                     data: {escalafon: $(this).val()},
                     dataType: 'json',
                     beforeSend: function () {
                         wait.start('Cargando..');
                     },
                     error: function (xhr, status, error){
                      exportarError(xhr.responseText);
                      wait.close();
                  },
                      success: function (json) {

                        $('#txtValorEscalafon').val(json.monto);
                        $('#txtValorEscalafon').attr("readonly", "readonly");
                        
                        wait.close();
                  }

              });
        } else {
            $('#txtValorEscalafon').val("");
            $('#txtValorEscalafon').removeAttr("readonly");
        }
    });

    $(document).on('change', '#txtfechainicio', function(event) {
        validar_fecha_inicio_fin('txtfechainicio', 'txtfechafin', 'La Fecha de inicio debe ser menor a la fecha fin');
    });

    $(document).on('change', '#txtfechafin', function(event) {
        validar_fecha_inicio_fin('txtfechainicio', 'txtfechafin', 'La Fecha de inicio debe ser menor a la fecha fin');

    });

    $(document).on("click", "#btnAgregar", function(event) {
        if($("#txtfechainicio").val().trim() != "" && $("#txtfechafin").val().trim() != "") {
            event.preventDefault();
            dia_texto = $('#slcDias option:selected').text();
            dia_valor = $('#slcDias').val();

            var dias = cuentaDiasSemana($("#txtfechainicio").val(), $("#txtfechafin").val(), dia_valor);

            horario_texto = $('#slcHorario option:selected').text();
            horario_valor = $('#slcHorario').val();

            horas_valor = $('#txthoras').val();

            html_acciones  = '<div class="controls center"><a href="#"  title="Borrar" class="tip eliminar_frecuencia" ><span class="icon12 icomoon-icon-remove"></span></a>';
            html_acciones  += '</div>';

            if(dia_valor>0 && horario_valor>0) {
                if ($("#"+dia_valor+"_"+horario_valor).length <= 0) { 
                    tr_html = "<tr id='"+dia_valor+"_"+horario_valor+"'>";
                    tr_html += "<td><input type='hidden' value='"+dias+"' name='diaTotal[]'><input type='hidden' value='"+dia_valor+"' name='dia[]'>"+dia_texto+"</td>";
                    tr_html += "<td><input type='hidden' value='"+horario_valor+"' name='horarios[]'>"+horario_texto+"</td>";
                    tr_html += "<td><input type='hidden' value='"+horas_valor+"' name='horas[]'>"+horas_valor+"</td>";
                    tr_html += "<td>"+html_acciones+"</td></tr>";
                    $("#tr_no_registros").remove();
                    $("#contenedor_frecuencia").append(tr_html);

                } else {
                    crear_alerta('error','Error', 'Frecuencia de Supervisor ya ha sido agregada');
                }
            } else {
                crear_alerta('error','Error', 'Campo de Día y Horario Son obligatorios');
            }
        } else {
            crear_alerta('error','Error', 'Debe seleccionar fecha inicio y fin para proceder');
        }   
    });

    $(document).on("change", "#slcHorario", function(event) {
        var horas = $("#slcHorario").val();

        if(horas>0) {
            $.ajax({
                 url: url + "registro_academico/procesos/ajax_horarios",
                 type: 'POST',
                 data: {horario: $(this).val()},
                 dataType: 'json',
                 beforeSend: function () {
                     wait.start('Cargando..');
                 },
                 error: function (xhr, status, error){
                  exportarError(xhr.responseText);
                  wait.close();
              },
                  success: function (json) {
                    var horaInicio = json.horario_inicio.split(":");
                    var horaFin = json.horario_fin.split(":");

                    $("#txthoras").val(Math.abs(parseInt(horaFin[0]-horaInicio[0]))+"."+Math.abs(parseInt(horaFin[1]-horaInicio[1])));
                    
                    wait.close();
              }

            });
        }
        
    });

    $(".eliminar_frecuencia").live('click',function (event) {
        event.preventDefault();
        $(this).parent().parent().parent().remove();        
        if ($("#contenedor_frecuencia tr").length <= 0) {
            $("#contenedor_frecuencia").append('<tr id="tr_no_registros"><td colspan="3" align="center"><center>No se encontraron registros</center></td></tr>');
        }
    });

     //Modal para eliminar
    $(document).on("click", "#btnCancelar", function (event) {
        alerta_confirm_ajax(verificar_alert, "", "Alerta confirmación", "¿Éstas seguro que quieres regresar a la lista de horarios?");
    });

});

// validar hora inicio y hora fin
function validar_hora_inicio_fin(id_hora_desde,id_hora_hasta,texto_alerta) { 
     texto_alerta = typeof texto_alerta !== 'undefined' ? texto_alerta : 'La hora de desde debe ser menor a la hora hasta';
     if($("#"+id_hora_desde).length >0 && $("#"+id_hora_hasta).length >0 ) {
         var hora_desde = $("#"+id_hora_desde).val();
         var hora_hasta = $("#"+id_hora_hasta).val();
         if(hora_desde != '' && hora_hasta != '') {
            
            if(hora_desde.indexOf(':') != -1){
                h_1 = hora_desde.split(':');
                h_2 = hora_hasta.split(':');
            } 

            if (h_1[0].length==2 ) { //el año va en la primera posición
              var h1 = new Date(h_1[0], h_1[1]); 
              var h2 = new Date(h_2[0], h_2[1]);
             } 
              
             if( ( h2 < h1 ) ){
                 crear_alerta('error','Error en horas',texto_alerta);
                 $("#"+id_hora_desde).val('');
                 $("#"+id_hora_hasta).val('');
             }
         }

     }
 }

// Calcular la cantidad de dias entre dos fechas
// Ejemplo: var f1 = '10/09/2014';
//          var f2='15/10/2014';
//          alert(restaFechas(f1,f2));
function calcular_dias_entre_fechas(f1,f2) {
    var aFecha1; 
    var aFecha2;

     if(f1.indexOf('/') != -1){
        aFecha1 = f1.split('/');
        aFecha2 = f2.split('/');
    } else {
        aFecha1 = f1.split('-');
        aFecha2 = f2.split('-');
    }
 
     var fFecha1 = Date.UTC(aFecha1[2],aFecha1[1]-1,aFecha1[0]); 
     var fFecha2 = Date.UTC(aFecha2[2],aFecha2[1]-1,aFecha2[0]); 
     var dif = fFecha2 - fFecha1;
     var dias = Math.floor(dif / (1000 * 60 * 60 * 24)); 
     return dias;
 }

function verificar_alert() {        
    window.location.href = urlj + "registro_academico/procesos/horarios_supervisor";        
} 

function cuentaDiasSemana(f1, f2, dia){
    // Saber que dia es de la semana
    day =0;
    switch (dia) {
        case 7:
            // Domingo
            day = 0;
            break;
        case 1:
            // Lunes
            day = 1;
            break;
        case 2:
            // Martes
            day = 2;
            break;
        case 3:
            // Miercoles
            day = 3;
            break;
        case 4:
            // Jueves
            day = 4;
            break;
        case 5:
            // Viernes
            day = 5;
            break;
        case 6:
            // Sabado
            day = 6;
    }

    var aFecha1; 
    var aFecha2;

     if(f1.indexOf('/') != -1){
        aFecha1 = f1.split('/');
        aFecha2 = f2.split('/');
    } else {
        aFecha1 = f1.split('-');
        aFecha2 = f2.split('-');
    }

    var inicio = new Date(aFecha1[2],aFecha1[1]-1,aFecha1[0]); //Fecha inicial
    var fin = new Date(aFecha2[2],aFecha2[1]-1,aFecha2[0]); //Fecha final
    var timeDiff = Math.abs(fin.getTime() - inicio.getTime());
    var diffDays = Math.ceil(timeDiff / (1000 * 3600 * 24)); //Días entre las dos fechas
    var cuenta = 0; //Número de Sábados y Domingos
    var array = new Array(diffDays);

    for (var i=0; i <= diffDays; i++) {
        if (inicio.getDay() == day) {
            cuenta++;
        }
        inicio.setDate(inicio.getDate() + 1);
    }

   return cuenta;
}