window.gSateliteWhite.jsSelect();
var pathArray = window.location.pathname.split( '/' );
var urlj=url_base_proyecto;
jQuery(document).ready(function($) {
        $("#chbxpluriclase").iButton({                
            change: function (element) {
                if (element.is(':checked')) {
                    $('#txtpluriclase').val(1);
                    $("#slcFrecuencia").trigger("change");

                } else {
                    $('#txtpluriclase').val(0);
                    $('#slcDocente').val(0);
                    $('#slcDocente').select2();
                    validar_docente();
                    $("#slcFrecuencia").trigger("change");
                }
            }
        });

        // Cambia el nombre de OFF = NO y ON = SI
        $(".ibutton-container label").each(function(index, el) {
            if ($(this).text().trim() =='OFF') {
                $(this).text('NO');
            }else if($(this).text().trim() =='ON'){
                $(this).text('SI');
            }
        });

        $(".fecha").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
        $(".fecha").mask("99-99-9999");
        $(".fecha").attr('placeholder',"dd-mm-yyyy");

        if($("#gra_id").length>0){
            $("#slcArea").select2('disable');
        }
        
        $("#slcAula").change(function(event) {
            var aula       = $(this).val();
            var frecuencia = $("#slcFrecuencia").val();
            wait.start();
            if(aula>0){
                // Obtener los cupos
                $.ajax({
                    type: "POST",
                    dataType:'json',
                    url: urlj+"registro_academico/mantenimientos/maximo_alumnos",
                    data: {aula: aula},
                    success: function(data){
                        if(data.cupo>0){
                            $("#txtCupoMin").val(data.minimo);
                            $("#txtCupoMax").val(data.cupo);
                            wait.close();
                        }else{
                            $("#txtCupoMin").val('');
                            $("#txtCupoMax").val('');
                            wait.close();
                        } 
                    }
                });
            }else{
                $("#txtCupoMin").val('');
                $("#txtCupoMax").val('');
                wait.close();
            }
            validar_docente();
        });

        /*$("#slcArea").change(function(event) {
            var area = $(this).val();
            // console.log(area);
            if(area>0){
                $.ajax({
                    type: "POST",
                    dataType:'json',
                    url: urlj+"registro_academico/procesos/get_subareas",
                    data: {area: area},
                    beforeSend: function(){
                        // console.log(data.area);
                        $("#slcSubarea").attr("placeholder", "Cargando...");
                        $("#slcSubarea").select2();
                    },
                    success: function(data){
                        $("#slcSubarea").html(data);
                        $("#slcSubarea").attr("placeholder", "Seleccione");
                        $("#slcSubarea").select2();  
                    }
                });
            }else{
                $("#slcSubarea").attr("placeholder", "Seleccione");
                $("#slcSubarea").html('<option value=""></option>');
                $("#slcSubarea option:first").attr('selected','selected');
                $("#slcSubarea").select2();
            }
        });*/


        $("#slcFrecuencia").change(function(event) {
            var frecuencia = $(this).val();
            wait.start();
            $.ajax({
                type: "POST",
                dataType:'json',
                url: urlj+"registro_academico/procesos/get_detalles_frecuencia",
                data: {frecuencia: frecuencia},
                success: function(data){
                    $("#contenedor_detalle").html(data);
                    wait.close();
                }
            });

            validar_docente();
        });

        $("#slcProyeccion").change(function(event) {
            var proyeccion = $(this).val();
            var area_slctd = ($("#gra_ard").length > 0) ? $("#gra_ard").val() : 0;
        var es_edicion = ($("#gra_id").length > 0 && $("#gra_id").val() > 0) ? true : false;
            if(proyeccion > 0){
                $.ajax({
                    type: "POST",
                    dataType:'json',
                    url: urlj+"registro_academico/procesos/get_info_proyeccion",
                    data: {
                        proyeccion: proyeccion,
                        grupo_acad: area_slctd
                    },
                    beforeSend: function(){
                        $("#slcArea").attr("placeholder", "Cargando...");
                        $("#slcArea").select2();
                    },
                    success: function(data){
                        let fecha = (data.maxima != null)?data.maxima:"";
                        $("#pyc_fecha_inicio").val(data.inicio);
                        $("#pyc_fecha_fin").val(data.fin);
                        $("#pyc_fecha_max").val(fecha);
                        $("#txtFecha_limit").text(fecha);
                        // Fecha sugerida en la creacion
                        var f = new Date();
                        if (data.inicio != null || data.inicio != "") {
                        if (es_edicion && $("#fecha_edicion_ini").val() != "") {
                            $("#txtFecha_ini").val($("#fecha_edicion_ini").val());
                        } else {
                            $("#txtFecha_ini").val(data.inicio);
                        }
                        } else {
                        if (es_edicion && $("#fecha_edicion_ini").val() != "") {
                            $("#txtFecha_ini").val($("#fecha_edicion_ini").val());
                        } else {
                            $("#txtFecha_ini").val(f.getDate() + "-" + (f.getMonth() +1) + "-" + f.getFullYear());
                        }
                    }
                        if (data.fin != null || data.fin != "") {
                        if (es_edicion && $("#fecha_edicion_fin").val() != "") {
                            $("#txtFecha_fin").val($("#fecha_edicion_fin").val());
                        } else {
                            $("#txtFecha_fin").val(data.fin);
                        }
                        } else {
                        if (es_edicion && $("#fecha_edicion_fin").val() != "") {
                            $("#txtFecha_fin").val($("#fecha_edicion_fin").val());
                        } else {
                            $("#txtFecha_fin").val(f.getDate() + "-" + (f.getMonth() +1) + "-" + f.getFullYear());
                        }
                    }
                        $("#slcArea").html(data.areas);
                        $("#slcArea").attr("placeholder", "Seleccione");
                        $("#slcArea").select2(); 
                        $(".area").trigger('change');
                    }
                });
            }else{
                $("#slcArea, #slcNivel").attr("placeholder", "Seleccione");
                $("#slcArea, #slcNivel").html('<option value=""></option>');
                $("#slcArea option:first").attr('selected','selected');
                $("#slcNivel option:first").attr('selected','selected');
                $("#slcArea, #slcNivel").select2();
            }
        });

        $("#slcArea").change(function(event) {
            var area = $(this).val();
            var grupo = 0;
            if($("#gra_id").length>0){
                grupo = $("#gra_id").val();
            }
            if(area>0){
                $.ajax({
                    type: "POST",
                    dataType:'json',
                    url: urlj+"registro_academico/procesos/get_info_area",
                    data: {area: area},
                    beforeSend: function(){
                        $("#slcGrado").attr("placeholder", "Cargando...");
                        $("#slcGrado").select2();
                    },
                    success: function(data){
                        if(data.verificar_flag_curso) {
                            $("#div_span_grado").hide();
                        } else {
                            $("#div_span_grado").show();
                            $("#slcGrado").html(data.grados);
                            $("#slcGrado").attr("placeholder", "Seleccione");
                            $("#slcGrado").select2(); 
                        }
                    }
                });
            }else{
                $("#div_span_grado").show();

                $("#slcGrado").html('<option value=""></option>');
                $("#slcGrado option:first").attr('selected', 'selected');
                $("#slcGrado").select2();
            }
        });

        if($("#slcProyeccion option:selected").val()>0){
            $("#slcProyeccion").trigger('change');
        }

        $("#slcDocente").change(function(event) {
            validar_docente();
        });

        $(".cupo").focusout(function(event){
            var minimo = $("#txtCupoMin").val();
            var maximo = $("#txtCupoMax").val();

            if(minimo>0 && maximo>0){
                if(parseFloat(minimo)>parseFloat(maximo)){
                    $("#txtCupoMax").addClass('error');
                    $("#txtCupoMax").val('');
                    crear_alerta('error', 'Error', 'El cupo mínimo no puede ser mayor al cupo máximo.');
                }else{
                    $("#txtCupoMax").removeClass('error');
                }
            }
        });
       
        $("#frm_grupo").validate({
            ignore: {
                slcSeccion,
                slcFrecuencia,
                slcDocente,
                slcAula,
                txtCupoMin,
                txtCupoMax
            },
            rules: {
                txtNombre:{ required:true},
                slcProyeccion: {required:true,min:1},
                slcArea: {required:true,min:1},
                slcNivel:{ required:true,min:1},
                txtFecha_ini:{ required:true},
                txtFecha_fin:{required:true},
            }, 
            messages: {
                txtNombre: "Campo requerido", 
                slcProyeccion: "Campo requerido",
                slcArea: "Campo requerido",
                slcNivel: "Campo requerido",
                txtFecha_ini: "Campo requerido",
                txtFecha_fin: "Campo requerido",
            },
            errorPlacement: function (error, element) {
                var nombre = $(element).attr("id");
                var valor = $(element).val();
                console.log('Element: '+nombre+' value:'+valor);
                $('#'+nombre+'_error').html(error);
                return false;
                /*if($("#estado").length>0  && $("#estado").val()==''){
                    $("#estado_error").text('Campo requerido');
                    return false;
                }
                if($("#slcAula").length>0  && $("#slcAula").val()==''){
                    $("#slcAula_error").text('Campo requerido');
                    return false;
                }
                fecha_ini=$("#txtFecha_ini").val();
                fecha_fin=$("#txtFecha_fin").val();
                fecha_ini_pro=$("#pyc_fecha_inicio").val();
                fecha_fin_pro=$("#pyc_fecha_fin").val();
                fecha_max_pro=$("#pyc_fecha_max").val();
                if((fecha_ini!='' || fecha_fin!='') && (!verifica_fecha(fecha_ini, fecha_fin) || !verifica_fecha_proyeccion(fecha_ini, fecha_fin, fecha_ini_pro, fecha_fin_pro, fecha_max_pro, true))){
                    return false;
                }*/
            },
            submitHandler: function(form) {
            validar_reg_unico($("#slcNivel").val(), $("#slcFrecuencia").val(), $("#slcSeccion").val(), $("#slcProyeccion").val());
                wait.start();
                fecha_ini=$("#txtFecha_ini").val();
                fecha_fin=$("#txtFecha_fin").val();
                fecha_ini_pro=$("#pyc_fecha_inicio").val();
                fecha_fin_pro=$("#pyc_fecha_fin").val();
                fecha_max_pro=$("#pyc_fecha_max").val();
            if($("#estado").length > 0){
                if ($("#estado").val()=='') {
                    wait.close();
                    $("#estado_error").text('Campo requerido');
                    return false;
                }
            }
                    if((fecha_ini!='' || fecha_fin!='') && (verifica_fecha(fecha_ini, fecha_fin) && verifica_fecha_proyeccion(fecha_ini, fecha_fin, fecha_ini_pro, fecha_fin_pro, fecha_max_pro, true)) && $("#error").val()<=0 ){
                $("#estado_error").text('');
                        wait.close();
                        form.submit();
                    }else{
                        wait.close();
                if ($("#error").val() > 0) {
                    crear_alerta('error', 'Error', 'Ya existe otro grupo con la misma proyección, frecuencia, nivel y sección');
                }
                        return false;
                    }
                }
        }); 

        $("#guardar").mouseover(function(event){
            $("#direccion").val(1);
        });
        $("#guardar_volver").mouseover(function(event){
            $("#direccion").val(2);
        });

        $(".area").change(function(){
            var area = $(this).val();
            $("#txtSelArea").val(area);
            cargar_pensum(area);
            cargar_frecuencia(area)
        });

        $("#nombre").blur(function(event){
        //    validar_grupo();
        });

        $("#slcNivel, #slcFrecuencia").change(function(event) {
            var nivel      = $("#slcNivel").val();
            var frecuencia = $("#slcFrecuencia").val();
            var pluriclase = $("#txtpluriclase").val();
            var proyeccion = $("#slcProyeccion").val();
            cargar_docente(nivel, frecuencia, pluriclase, proyeccion);
            obtener_horario_validado(null, frecuencia, pluriclase, proyeccion, nivel);
        });

        $("#slcProyeccion, #slcNivel, #slcFrecuencia, #slcSeccion").change(function(event) {
            var nivel = $("#slcNivel").val();
            var frecuencia = $("#slcFrecuencia").val();
            var proyeccion = $("#slcProyeccion").val();
            var seccion = $("#slcSeccion").val();
            if(nivel>0 && frecuencia>0 && proyeccion>0 ){
                validar_reg_unico(nivel, frecuencia, seccion, proyeccion);
            }
        });

        function generar_codigo(){
            var nivel = $("#slcNivel option:selected").text();
            var frecuencia = $("#slcFrecuencia option:selected").text();
            var codigo = $.trim(nivel + ' ' + frecuencia);
            $("#txtNombre").val(codigo);
        }

        $('body').on('change', '#slcNivel, #slcFrecuencia', function(){
            generar_codigo();
        })

});


    function verifica_fecha(fecha_ini, fecha_fin, valida=null){
        //Convierto la fecha a Y-m-d
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");
        if(Date.parse(fecha_i) == Date.parse(fecha_f)){ $("#txtFecha_fin_error").text(''); return true;}
        if(Date.parse(fecha_i) > Date.parse(fecha_f)){
            $("#txtFecha_fin").addClass('error');
            $("#txtFecha_fin_error").text("Verifique las fechas del período");
            return false;
        }
        if(Date.parse(fecha_i) < Date.parse(fecha_f)){
            $("#txtFecha_fin").removeClass('error');
            $("#txtFecha_fin_error").text('');
            return true;
        }
    }

    function verifica_fecha_proyeccion(fecha_ini, fecha_fin, fecha_ini_pro, fecha_fin_pro, fecha_max_pro, texto=false){
        //Convierto la fecha a Y-m-d
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");
        //Fechas de proyección
        var fecha_ip = fecha_ini_pro.split("-").reverse().join("-"); // Inicio
        var fecha_fp = fecha_fin_pro.split("-").reverse().join("-"); // Fin
        var fecha_mp = fecha_max_pro.split("-").reverse().join("-"); // Máxima
          if(Date.parse(fecha_i) >= Date.parse(fecha_ip) && Date.parse(fecha_f) <= Date.parse(fecha_fp)){
            $("#txtFecha_fin").removeClass('error');
              $("#txtFecha_fin_error").text('');
              return true;
          }else{
            if(texto==true){
              $("#txtFecha_fin").addClass('error');
              $("#txtFecha_fin_error").text("Verifique las fechas del período");
            }
            crear_alerta('error', 'Error', 'El rango de fechas debe seleccionarse de acuerdo al período de proyección.');
            return false;
          }
    }

    function cargar_pensum(id_area){
    var slctd = ($("#gra_pen").length > 0) ? $("#gra_pen").val() : 0;
        $.ajax({
                type: "POST",
                url: urlj+"registro_academico/mantenimientos/cargar_pensum",
        data: {
            id: id_area,
        },
              beforeSend: function () {
                $("#slcNivel").attr("placeholder","Cargando..."); 
                $("#slcNivel").attr('disabled', 'disabled');
                $("#slcNivel").select2();
              },
              success: function (html) {
                    $('#slcNivel').html(html);
                    $("#slcNivel").attr("placeholder","Seleccione");
                    $("#slcNivel").removeAttr('disabled');
                if (slctd > 0) {
                    $('#slcNivel').val(slctd).trigger('change');
                }
                    $("#slcNivel").select2();
              }
        });
    }

    function cargar_frecuencia(id_area){
        var slctd = ($("#gra_frh").length > 0) ? $("#gra_frh").val() : 0;
        $.ajax({
                type: "POST",
                url: urlj+"registro_academico/procesos/cargar_frecuencia",
                data: {area: id_area},
              beforeSend: function () {
                $("#slcFrecuencia").attr("placeholder","Cargando..."); 
                $("#slcFrecuencia").attr('disabled', 'disabled');
                $("#slcFrecuencia").select2();
              },
              success: function (html) {
                  $('#slcFrecuencia').html(html);
                  $("#slcFrecuencia").attr("placeholder","Seleccione");
                  $("#slcFrecuencia").removeAttr('disabled');
                if (slctd > 0) {
                    $('#slcFrecuencia').val(slctd).trigger('change');
                }
                  $("#slcFrecuencia").select2();
              }
        });
    }

    function cargar_docente(id_nivel=null, id_frecuencia=null, pluriclase=null, proyeccion=null){
        $.ajax({
            type: "POST",
            url: urlj+"registro_academico/procesos/cargar_docente",
            data: {nivel: id_nivel, frecuencia: id_frecuencia, edit: $("#gra_id").val(), pluriclase:pluriclase, proyeccion: proyeccion},
            beforeSend: function () {
                $("#slcDocente").attr("placeholder","Cargando..."); 
                $("#slcDocente").attr('disabled', 'disabled');
                $("#slcDocente").select2();
            },
            success: function (html) {
                $('#slcDocente').html(html);
                $("#slcDocente").attr("placeholder","Seleccione");
                $("#slcDocente").removeAttr('disabled');
                $("#slcDocente").select2();
            }
        });
    }

    function validar_docente(){
        wait.start();
        var pluriclase = $("#txtpluriclase").val();
        var frecuencia =  $("#slcFrecuencia").val();
        var aula =  $("#slcAula").val();
        var docente =  $("#slcDocente").val();
        var proyeccion = $("#slcProyeccion").val();
        var grupo = $("#gra_id").val();
        $.ajax({
            type: "POST",
            dataType:'json',
            url: urlj+"registro_academico/procesos/validar_docente",
            data: {proyeccion: proyeccion,frecuencia: frecuencia, docente: docente, aula: aula, grupo: grupo, pluriclase: pluriclase},
            success: function(data){
                wait.close();
            if(data.resp==1 && pluriclase != 1 && data.modalidad_aula == 0){
                /* GRUPO REPETIDO | NO PLURICLASE | AULA FISICA*/
                    crear_alerta('error', 'Error', 'El docente ya está asignado a la frecuencia y aula seleccionada');
                    $("#slcDocente").val(0);
                    $("#slcDocente").select2();
                    $("#slcAula").val(0);
                    $("#slcAula").select2();
                    if($("#gra_id").length<=0){
                        $("#slcFrecuencia").val(0);
                        $("#slcFrecuencia").select2();
                        $("#contenedor_detalle").html('');
                    }
            }else if(data.resp==2 && pluriclase != 1 && data.modalidad_aula == 0){
                /* MISMO DOCENTE EN OTRO GRUPO  */
                    crear_alerta('error', 'Error', 'El docente ya está asignado en otra aula para la frecuencia seleccionada');
                    $("#slcDocente").val(0);
                    $("#slcDocente").select2();
                    $("#slcAula").val(0);
                    $("#slcAula").select2();
                    if($("#gra_id").length<=0){
                        $("#slcFrecuencia").val(0);
                        $("#slcFrecuencia").select2();
                        $("#contenedor_detalle").html('');
                    }
            }else if(data.resp==3 && pluriclase != 1 && data.modalidad_aula == 0){
                /* YA ESTA OTRO GRUPO EN ESE AULA */
                    crear_alerta('error', 'Error', 'El aula ya está asignada a la frecuencia seleccionada');
                    $("#slcDocente").val(0);
                    $("#slcDocente").select2();
                    $("#slcAula").val(0);
                    $("#slcAula").select2();
                    if($("#gra_id").length<=0){
                        $("#slcFrecuencia").val(0);
                        $("#slcFrecuencia").select2();
                        $("#contenedor_detalle").html('');
                    }
                }
            }
        });
    }

    function validar_reg_unico(nivel, frecuencia, seccion, proyeccion){
        $.ajax({
          dataType:'json',
          type:'post',
          data:{nivel: nivel,frecuencia: frecuencia, seccion: seccion, proyeccion: proyeccion, edit: $("#gra_id").val()},
          url: urlj+'registro_academico/procesos/validar_grupo_unico',
          success: function(data){
            var modalidad = ($("#slcAula").val() > 0) ? $("#slcAula option:selected").data('modality') : 0;
           if(data>0){
                if (modalidad > 0) {
                    $("#error").val(0);
                } else {
                crear_alerta('error', 'Error', 'Ya existe otro grupo con la misma proyección, frecuencia, nivel y sección');
                $("#error").val(1);
                $("#contenedor_detalle").html('');
                $("#slcDocente option:first").attr('selected', 'selected');
                $("#slcDocente").select2();
                }
           }else{
              $("#error").val(0);
           }
          }
        });
    }

    function obtener_horario_validado(aula=null, frecuencia=null, pluriclase=null, proyeccion=null, nivel=null) {
        // Obtener las aulas que no estan ocupadas
        $.ajax({
            type: "POST",
            dataType:'json',
            url: urlj+"registro_academico/procesos/obtener_horario_validado",
            data: {aula: aula, frecuencia:frecuencia, pluriclase:pluriclase, proyeccion: proyeccion, grado: $("#gra_id").val(), nivel: nivel},
            beforeSend: function () {
                $("#slcAula").attr("placeholder","Cargando..."); 
                $("#slcAula").attr('disabled', 'disabled');
                $("#slcAula").select2();
                $("#slcSeccion").attr("placeholder","Cargando..."); 
                $("#slcSeccion").attr('disabled', 'disabled');
                $("#slcSeccion").select2();
                $("#slcSupervisor").attr("placeholder","Cargando..."); 
                $("#slcSupervisor").attr('disabled', 'disabled');
                $("#slcSupervisor").select2();
            },
            success: function(data){
                $("#slcAula").attr("placeholder","Seleccione"); 
                // $("#slcAula").append(data.aulas);
                // console.log(data.aulas);
                $("#slcAula").removeAttr('disabled');
                $("#slcAula").select2();
                $("#slcSeccion").attr("placeholder","Seleccione");
                // $("#slcSeccion").append(data.secciones);
                $("#slcSeccion").removeAttr('disabled');
                $("#slcSeccion").select2();
                $("#slcSupervisor").attr("placeholder","Seleccione"); 
                // $("#slcSupervisor").append(data.supervisores);
                $("#slcSupervisor").removeAttr('disabled');
                $("#slcSupervisor").select2();
            }
        });
    }