$(document).ready(function(event) {
    var url = url_base_proyecto;
    $('select').select2();

    $("#frm_graduciones").validate({
        ignore: "",
        rules: {
            txtnombre: {required: true},
            txtfechagraducion: {required: true}
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });

    $("#txtfechagraducion").datepicker({dateFormat: 'yy-mm-dd',changeMonth: true, changeYear: true});
    $("#txtfechagraducion").mask("9999-99-99");
    $("#txtfechagraducion").attr('placeholder',"yyyy-mm-dd");

    $(document).on("change", "#slcProyeccion", function(event) {
        var url_ajax = url + "registro_academico/procesos/ajax_proyeccion_alumnos";
        $.ajax({
                 url: url_ajax,
                 type: 'POST',
                 data: {proyeccion: $(this).val()},
                 dataType: 'json',
                 beforeSend: function () {
                     wait.start('Cargando..');
                 },
                 error: function (xhr, status, error){
                  exportarError(xhr.responseText);
                  wait.close();
              },
                  success: function (json) {
                      
                    $('#txtareaproyeccion').val(json.area);

                    if (json.alumnos.length>0) {
                        html = '<option value=""></option>';
                        for (var i = json.alumnos.length - 1; i >= 0; i--) {
                            // console.log(json.alumnos[i]);
                            html += '<option value="'+json.alumnos[i].alm_id+'">'+json.alumnos[i].alm_nombre+' '+json.alumnos[i].alm_apellido+'</option>';
                        }
                    } else {
                        html = '';
                    }
     
                    $('#slcAlumnos').html(html);

                    wait.close();
              }

          });
    });

    $(document).on("click", "#btnAdicionar", function(event) {
        event.preventDefault();
        proyeccion_texto = $('#slcProyeccion option:selected').text();
        proyeccion_valor = $('#slcProyeccion').val();
        alumnos = [];
        alumnos_texto = $('#slcAlumnos option:selected').each(function () {
            alumnos.push($(this).text());
        });

        alumnos_valor = $('#slcAlumnos').val();
        html_acciones  = '<div class="controls center"><a href="#"  title="Borrar" class="tip eliminar_graducion" ><span class="icon12 icomoon-icon-remove"></span></a>';
        html_acciones  += '</div>';

        if (proyeccion_valor>0 && alumnos_valor.length>0) {
            if ( $("#contenedor_graduaciones input[value='"+proyeccion_valor+"']").length <= 0 ) { 
                tr_html = "<tr>";
                tr_html += "<td><input type='hidden' value='"+proyeccion_valor+"' id='graduacion_proyeccion' name='graduacion_proyeccion[]'>"+proyeccion_texto+"</td>";
                tr_html += "<td><input type='hidden' value='"+alumnos_valor+"' id='alumnos_graducion' name='alumnos_graducion[]'>"+alumnos+"</td>";
                tr_html += "<td>"+html_acciones+"</td></tr>";
                $("#tr_no_registros").remove();
                $("#contenedor_graduaciones").append(tr_html);
            } else {
                crear_alerta('error','Error', 'Graduación ya ha sido agregado');
            }

        } else {
            crear_alerta('error','Error', 'Campo de Alumnos y Proyección Son obligatorios');
        }

    });

    $(".eliminar_graducion").live('click',function (event) {
        event.preventDefault();
        $(this).parent().parent().parent().remove();        
        if ($("#contenedor_graduaciones tr").length <= 0) {
            $("#contenedor_graduaciones").append('<tr id="tr_no_registros"><td colspan="3" align="center"><center>No se encontraron registros</center></td></tr>');
        }
    });

    //Modal para eliminar retornado
    $("#btnCancelar").click(function (event) {
        alerta_confirm_ajax(verificar_alert, "", "Alerta confirmación", "¿Éstas seguro que quieres regresar a la lista de Graduaciones?");
    });

    function verificar_alert() {        
        window.location.href = urlj + "registro_academico/procesos/graduaciones";        
    } 

    $(document).on('click','#btnG1',function(){
        $("#btnCrear").val(1);
    });

    $(document).on('click','#btnG2',function(){
        $("#btnCrear").val(2);
    });

});