jQuery(document).ready(function($) {
	window.gSateliteWhite.jsSelect();

	$(".fecha").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
   $(".fecha").mask("99-99-9999");

   

   var mascara = $("#mascara").val();
   var masc = mascara.replace(/#/g, '9');

   if(masc !=''){
   	$("#txtDuiPadre").mask(masc);
   	$("#txtDuiMadre").mask(masc);
   }

	$("#chkAntinguo").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        change: function (element) {
            if (element.is(':checked')) {
            	$("#id_check").val(2);
                $("#txtEstudiante_error").text('');
                $("#txtEstudiante").hide();
                $("#slcAlumno + .select2-container").show();
            } else {
            	$("#id_check").val(1);
            	$("#txtEstudiante_error").text('');
                $("#txtEstudiante").show();
                $("#slcAlumno + .select2-container ").hide();
            	$("#slcAlumno").select2('data', null);
            }
        }
    });

	$("#slcAlumno").select2({
        placeholder: "Buscar Alumno",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'registro_academico/procesos/get_alumnos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (alumno) {
                return {
                    alumno: alumno
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.alumno,
                        'text': item.alm_nombre
                    });
                });
               
                return {
                    results: myResults
                };
                
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('text');
                callback({id: valor, text: texto});
            }
        }
    });

     if($("#id_ene").length>0 && $("#id_check").val()==2){
    	$("#chkAntinguo").attr( "checked" );
 		$("#chkAntinguo").iButton('repaint');

 		$("#txtEstudiante").hide();
 		var text = $("#slcAlumno").data('text'); 
 		$("#slcAlumno + .select2-container").show();
 		//$("#slcAlumno + .select2-container .select2-choice > span").text(text);
 		//$("#slcAlumno").select2();
        $("#slcAlumno + .select2-container").show();
        
    }else{
	    $("#slcAlumno + .select2-container ").hide();
	    $("#slcAlumno").select2('data', null);
    }


	$("#slcAlumno").change(function(event) {
		var id_alm = $(this).val(); 
		$.ajax({
            type:'post',
            dataType:'json',
            url:window.gSateliteWhite.baseUrl('registro_academico/procesos/get_familiares_alm'),
            data:{id_alm:id_alm},
            beforeSend:function(){
                wait.start('Obteniendo los datos de los padres... Espere unos minutos');
            },
            success:function(result){
                wait.close();
                $("#hdnIdPadre").val(result.id_padre);
                $("#hdnIdMadre").val(result.id_madre);
                $("#txtEstudiante").val(result.nombre_alm);
                $("#txtPadre").val(result.nombre_padre);
                $("#txtDuiPadre").val(result.doc_padre);
                $("#txtMadre").val(result.nombre_madre);
                $("#txtDuiMadre").val(result.doc_madre);
                $("#txtResponsable").val(result.nombre_resp);
                $("#txtResponsable_error").text('');
                      
            }
        });

	});


    $("#frm_entrevista").validate({
		ignore: ".select2-container",
		rules: {
			txtEstudiante:{ required:true},
			txtFecha:{ required:true},
			txtMotivo: { required:true},
			txtResponsable: {required:true},
		}, 
		messages: {
			txtEstudiante: "Campo requerido",
			txtFecha: "Campo requerido",
			txtMotivo: "Campo requerido",
			txtResponsable: "Campo requerido"	
		},
		errorPlacement: function (error, element) {
			var nombre=$(element).attr("id");
			$('#'+nombre+'_error').text('Campo requerido');	

			if($("#estado").length>0  && $("#estado").val()==''){
              $("#estado_error").text('Campo requerido');
              return false;
            }
		},
		submitHandler: function(form) {	
			if($("#estado").length>0  && $("#estado").val()==''){
            wait.close();
              $("#estado_error").text('Campo requerido');
              return false;
            }else{
              $("#estado_error").text('');
                wait.close();
                form.submit();
            }

		    
		}
	});


});//End jQuery


