jQuery(document).ready(function($) {
	window.gSateliteWhite.jsSelect();

	$("#chbxPrerreq").iButton({                
        change: function (element) {
            if (element.is(':checked')) {
                $('#txtPrerreq').val(1);

            } else {
                $('#txtPrerreq').val(0);
            }
        }
    });

    //Cambia el nombre de OFF = NO y ON = SI
    $(".ibutton-container label").each(function(index, el) {
        if ($(this).text().trim() =='OFF') {
            $(this).text('NO');
        }else if($(this).text().trim() =='ON'){
            $(this).text('SI');
        }
    });

	$("#slcEmpleado").select2({
        placeholder: "Buscar Empleado",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'proyectos/procesos/get_empleados_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (empleado) {
                return {
                    empleado: empleado
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.empleado,
                        'text': item.emp_nombre
                    });
                });
               
                return {
                    results: myResults
                };
                
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('text');
                callback({id: valor, text: texto});
            }
        }
    });


	$("#slcEmpleado").change(function(event) {
		var empleado = $(this).val(); 
		
		if($("#dct_id").length>0){
			var docente = $("#dct_id").val();
		}else{ var docente = 0; }
		
		if(empleado>0){
			$.ajax({
	            type:'post',
	            dataType:'json',
	            url:window.gSateliteWhite.baseUrl('registro_academico/procesos/get_empleado'),
	            data:{empleado:empleado, docente :docente},
	            beforeSend:function(){
	                wait.start('Obteniendo los datos del empleado...  Espere unos minutos');
	            },
	            success:function(result){
	                wait.close();
	                if(result.docente<=0){
		                $("#lblProfesion").text(result.profesion);
		                $("#lblGenero").text(result.genero);
		                $(".docente_select").text(result.nombre);                      
	                }else{
	                	$("#lblProfesion").text('');
		                $("#lblGenero").text('');
		                $(".docente_select").text('');
		                crear_alerta('info', 'Docente registrado', 'El empleado ya se encuentra registrado como docente');
		                $("#slcEmpleado").select2('data', null);
		                 /*$("#slcProducto").select2("val", "");
                                $('#slcProducto').select2('open'); */
	                }
	            }
	        });
		}else{
			$("#lblProfesion").text('');
	        $("#lblGenero").text('');
	        $(".docente_select").text('');  
		}
	});

	$("#slcArea").change(function(event) {
		var area = $(this).val(); 
		if(area>0){
			$.ajax({
	            type:'post',
	            dataType:'json',
	            url:window.gSateliteWhite.baseUrl('registro_academico/procesos/get_frecuencias'),
	            data:{area:area},
	            beforeSend:function(){
	                $("#slcFrecuencia").attr("placeholder", "Cargando...");
            		$("#slcFrecuencia").select2();
	            },
	            success:function(data){
	                $("#slcFrecuencia").html(data);
		            $("#slcFrecuencia").attr("placeholder", "Seleccione");
		            $("#slcFrecuencia").select2();                  
	            }
	        });
		}else{
			$("#slcFrecuencia").attr("placeholder", "Seleccione");
	        $("#slcFrecuencia").html('<option value=""></option>');
	        $("#slcFrecuencia option:first").attr('selected','selected');
	        $("#slcFrecuencia").select2();  
		}
	});

	$("#slcFrecuencia").change(function(event) {
		frecuencia = $(this).val();
		if(frecuencia>0){
			$.ajax({
	            type:'post',
	            dataType:'json',
	            url:window.gSateliteWhite.baseUrl('registro_academico/procesos/get_detalles_frecuencia'),
	            data:{frecuencia:frecuencia},
	            success:function(data){
	                $("#contenedor_frecuencia").html(data);                 
	            }
	        });
		}else{
			$("#contenedor_frecuencia").html('');
		}
	});

	$("#agregar_fr").click(function(event){
        var estado = 1;  // Estado para controlar los horarios
		var area = $("#slcArea").val();
		var frecuencia = $("#slcFrecuencia").val();

		var areaText = $("#slcArea option:selected").text();
		var frecuenciaText = $("#slcFrecuencia option:selected").text();

		var optArea = $("#slcArea").html();
		var optFrecuencia = $("#slcFrecuencia").html();

        /* ******************************************************************************************** */
        /* Se quito esta validacion de recorrer las frecuencias para verificar los dias y horas */
        /* ******************************************************************************************** */
        // $("#contenedor_detalle_fr tr").each(function(e, a) {
        //     // console.log($(a).find("#detalle_f"+(e+1)).val());
        //     // console.log(frecuencia);
        //     var frecuenciaA = $(a).find("#detalle_f"+(e+1)).val();
        //     $.ajax({
        //         url: urlj + "registro_academico/procesos/validar_horario_docente",
        //         type: 'POST',
        //         async: false,
        //         data: {frecuenciaA: frecuenciaA, frecuenciaN:frecuencia},
        //         dataType: 'json',
        //         beforeSend: function () {
        //             wait.start('Cargando..');
        //         },
        //           error: function (xhr, status, error){
        //           exportarError(xhr.responseText);
        //           wait.close();
        //         },
        //           success: function (json) {
        //             // console.log(json);
        //             estado = parseInt(json.exito);
        //             wait.close();
        //       }
        //   });
        //     if (estado == 0) {
        //         return false;
        //     }
        // });
        /* ******************************************************************************************** */
        if(area > 0 && frecuencia > 0){
        	if($("#DHF"+area+frecuencia).length <= 0 ){
        		contador=parseInt($('#contador_det_frecuencia').val());
                tr='<tr class="dato'+contador+' tr_frecuencia" id="DHF'+area+frecuencia+'" data-corr="'+contador+'">';
                tr +='<td class="td-input first">';
                tr +='<input type="hidden" value="0" id="ids_fxd'+contador+'" name="ids_fxd[]">';
                tr +='<input type="hidden" value="'+area+'" id="detalle_a'+contador+'" name="detalle_a[]" >';
                tr +='<input type="hidden" value="'+frecuencia+'" id="detalle_f'+contador+'" name="detalle_f[]" >';
                tr +='<span id="area'+contador+'"> '+areaText+'</span> </td>'
                tr +='<td> <span id="frecuencia'+contador+'">'+frecuenciaText+'</span></td>'
                tr +='<td width="15%">'
                tr += '<button type="button" value="'+contador+'" id="eliminar'+contador+'"  class="btn btn-danger btn-mini delete_fila" style="width: 50px;float: left; margin-right:10%; height:30px; " >Eliminar</button></td>'
                tr +='</tr>';                        
                $("#contenedor_detalle_fr").append(tr);
                $("#validacion_det_frecuencia").val('lleno'); 
                $("#validacion_det_frecuencia").trigger('keyup');
                $("#contador_det_frecuencia").val((contador + 1));
                $("#slcArea option:first").attr('selected', 'selected');
                $("#slcFrecuencia").html('<option value=""></option>'); 
                $("#slcArea, #slcFrecuencia").select2();
            }else {
            	crear_alerta('error','Informaci&oacute;n','Ese detalle ya ha sido agregado'); 
            }
        }else{
        	crear_alerta('error', 'Error', 'Favor de seleccionar área y frecuencia');
        }
    }); 

	  //Eliminar Producto
    $(".delete_fila").live("click", function () {
        var parent = $(this).parent().parent();
        $("#" + parent[0].id).remove().delay(300);
    });

    /********************* formulario de disponibilidad de curso *********************************/

    $("#slcAreaN").change(function(event) {
		var area = $(this).val(); 
		if(area>0){
			$.ajax({
	            type:'post',
	            url:window.gSateliteWhite.baseUrl('registro_academico/procesos/cargar_pensum'),
	            data:{id:area},
	            beforeSend:function(){
	                $("#slcNivel").attr("placeholder", "Cargando...");
            		$("#slcNivel").select2();
	            },
	            success:function(data){
	                $("#slcNivel").html(data);
		            $("#slcNivel").attr("placeholder", "Seleccione");
		            $("#slcNivel").select2();                  
	            }
	        });
		}else{
			$("#slcNivel").attr("placeholder", "Seleccione");
	        $("#slcNivel").html('<option value=""></option>');
	        $("#slcNivel option:first").attr('selected','selected');
	        $("#slcNivel").select2();  
		}
	});


	$("#agregar_nivel").click(function(event){
		var area  = $("#slcAreaN").val();
		var nivel = $("#slcNivel").val();
		var pre   =  $("#txtPrerreq").val();
		var areaText = $("#slcAreaN option:selected").text();
		var nivelText = $("#slcNivel option:selected").text();

		if(pre>0){
			if(area>0 && nivel>0){
				if($("#DHM"+area+nivel).length <= 0 ){
					contador=parseInt($('#contador_det_nivel').val());
					$.ajax({
						type:'post',
			            dataType: 'json',
			            url:window.gSateliteWhite.baseUrl('registro_academico/procesos/get_prerrequisitos'), // clase de escalafón
			            data:{area:area, nivel: nivel, contador: contador, docente: $("#dct_id").val() },
			            beforeSend:function(){
			                wait.start('Espere un momento... cargando información');
			            },
			            success:function(data){
			            	wait.close(); 
			            	$("#contenedor_detalle_nivel").append(data.filas);
			            	$("#validacion_det_nivel").val('lleno'); 
			            	$("#validacion_det_nivel").trigger('keyup');
			            	$("#contador_det_nivel").val((data.cont));

			            	contador=parseInt($('#contador_det_nivel').val());
			            	tr='<tr class="dato'+contador+' " id="DHM'+area+nivel+'" data-corr="'+contador+'">';
			            	tr +='<td class="td-input first">';
			            	tr +='<input type="hidden" value="0" id="ids_mpd'+contador+'" name="ids_mpd[]">';
			            	tr +='<input type="hidden" value="'+area+'" id="detalle_arm'+contador+'" name="detalle_arm[]" >'
			            	tr +='<input type="hidden" value="'+nivel+'" id="detalle_n'+contador+'" name="detalle_n[]" >'
			            	tr +='<span id="area'+contador+'"> '+areaText+'</span> </td>'
			            	tr +='<td> <span id="frecuencia'+contador+'">'+nivelText+'</span></td>'
			            	tr +='<td width="15%">'
			            	tr += '<button type="button" value="'+contador+'" id="eliminar'+contador+'"  class="btn btn-danger btn-mini delete_fila" style="width: 50px;float: left; margin-right:10%; height:30px; " >Eliminar</button></td>'
			            	tr +='</tr>';
							$("#contenedor_detalle_nivel").append(tr);
							$("#validacion_det_nivel").val('lleno'); 
							$("#validacion_det_nivel").trigger('keyup');
						    $("#contador_det_nivel").val((contador+1));
			            }
			        });
			    }else {
				    crear_alerta('error','Informaci&oacute;n','Ese detalle ya ha sido agregado'); 
				}
			}else{
			  	crear_alerta('error', 'Error', 'Favor de seleccionar área y Curso/Nivel');
			}
		}else{
			if(area > 0 && nivel > 0){
				if($("#DHM"+area+nivel).length <= 0 ){
					contador=parseInt($('#contador_det_nivel').val());
					tr='<tr class="dato'+contador+' " id="DHM'+area+nivel+'" data-corr="'+contador+'" >';
					tr +='<td class="td-input first">';
					tr +='<input type="hidden" value="0" id="ids_mpd'+contador+'" name="ids_mpd[]">';
					tr +='<input type="hidden" value="'+area+'" id="detalle_arm'+contador+'" name="detalle_arm[]" >';
					tr +='<input type="hidden" value="'+nivel+'" id="detalle_n'+contador+'" name="detalle_n[]" >';
					tr +='<span id="area'+contador+'"> '+areaText+'</span> </td>';
					tr +='<td> <span id="frecuencia'+contador+'">'+nivelText+'</span></td>';
					tr +='<td width="15%">';
					tr += '<button type="button" value="'+contador+'" id="eliminar'+contador+'"  class="btn btn-danger btn-mini delete_fila" style="width: 50px;float: left; margin-right:10%; height:30px; " >Eliminar</button></td>';
					tr +='</tr>';;							
					$("#contenedor_detalle_nivel").append(tr);
					$("#validacion_det_nivel").val('lleno'); 
					$("#validacion_det_nivel").trigger('keyup');
				    $("#contador_det_nivel").val((contador + 1));
					$("#slcAreaN option:first").attr('selected', 'selected');
					$("#slcNivel").html('<option value=""></option>');	
					$("#slcAreaN, #slcNivel").select2();
				}else {
				    crear_alerta('error','Informaci&oacute;n','Ese detalle ya ha sido agregado'); 
				}
			}else{
			  	crear_alerta('error', 'Error', 'Favor de seleccionar área y Curso/Nivel');
			}
		}

  }); 


 /********************* formulario de Escalafón *********************************/

    $("#slcCategoria").change(function(event) {
		var categoria = $(this).val(); 
		if(categoria>0){
			$.ajax({
	            type:'post',
	            dataType: 'json',
	            url:window.gSateliteWhite.baseUrl('registro_academico/procesos/cargar_clase'), // clase de escalafón
	            data:{categoria:categoria},
	            beforeSend:function(){
	                $("#slcClase").attr("placeholder", "Cargando...");
            		$("#slcClase").select2();
	            },
	            success:function(data){
	                $("#slcClase").html(data);
		            $("#slcClase").attr("placeholder", "Seleccione");
		            $("#slcClase").select2();                  
	            }
	        });
		}else{
			$("#slcClase").attr("placeholder", "Seleccione");
	        $("#slcClase").html('<option value=""></option>');
	        $("#slcClase option:first").attr('selected','selected');
	        $("#slcClase").select2();  
		}
	});


	$("#agregar_escalafon").click(function(event){
		var categoria = $("#slcCategoria").val();
		var clase = $("#slcClase").val();

		var categoriaText = $("#slcCategoria option:selected").text();
		var claseText = $("#slcClase option:selected").text();

		if(categoria>0 && clase>0){ 
			if($("#DH"+categoria+clase).length <= 0 ){ 
				contador=parseInt($('#contador_det_nivel').val());
				tr='<tr class="dato'+contador+' " id="DH'+categoria+clase+'" data-corr="'+contador+'" >';
				tr +='<td class="td-input first">';
				tr +='<input type="" value="0" id="ids_exd'+contador+'" name="ids_exd[]">';
				tr +='<input type="hidden" value="'+categoria+'" id="detalle_cat'+contador+'" name="detalle_cat[]" >';
				tr +='<input type="hidden" value="'+clase+'" id="detalle_cl'+contador+'" name="detalle_cl[]" >';
				tr +='<span id="area'+contador+'"> '+categoriaText+'</span> </td>';
				tr +='<td> <span id="frecuencia'+contador+'">'+claseText+'</span></td>';
				tr +='<td width="15%">';
				tr += '<button type="button" value="'+contador+'" id="eliminar'+contador+'"  class="btn btn-danger btn-mini delete_fila" style="width: 50px;float: left; margin-right:10%; height:30px; " >Eliminar</button></td>';
				tr +='</tr>';
						
				$("#contenedor_detalle_escalafon").append(tr);
				$("#validacion_det_escalafon").val('lleno'); 
				$("#validacion_det_escalafon").trigger('keyup');
			    $("#contador_det_nivel").val((contador + 1));
				$("#slcCategoria option:first").attr('selected', 'selected');
				$("#slcClase").html('<option value=""></option>');	
				$("#slcCategoria, #slcClase").select2();
			}else {
			    crear_alerta('error','Informaci&oacute;n','Ese detalle ya ha sido agregado'); 
			}
		}else{
		  	crear_alerta('error', 'Error', 'Favor de seleccionar categoría y clase');
		}
  }); 

    $("#frm_disponibilidad").validate({
		ignore: "",
		rules: {
			slcEmpleado:{ required:true, min:1},
		}, 
		messages: {
			slcEmpleado: "Campo requerido"
		},
		errorPlacement: function (error, element) {
			var nombre=$(element).attr("id");
			$('#'+nombre+'_error').text('Campo requerido');
			if($("#estado").length > 0){
				if ($("#estado").val()=='') {
					$("#estado_error").text('Campo requerido');
				}
			}
			return false;
		},
		submitHandler: function(form) {
			if($("#estado").length > 0){
				if ($("#estado").val() == '') {
					wait.close();
					$("#estado_error").text('Campo requerido');
					return false;
				}
            }
            $("#estado_error").text('');
            // console.log($("#frm_disponibilidad").serializeArray());
            // wait.close();
            form.submit();
        }
    });


});//End jQuery

function agregar_detalle(area, nivel, areaText, nivelText){

	contador=parseInt($('#contador_det_nivel').val());
	tr='<tr class="dato'+contador+' " id="DH'+area+nivel+'" data-corr="'+contador+'" clase="dato'+contador+'"><td id="correlativo_td" style="display:none;">'+1+'</td><td class="td-input first">'
	tr +='<input type="hidden" value="'+area+'" id="detalle_arm'+contador+'" name="detalle_arm[]" >'
	tr +='<input type="hidden" value="'+nivel+'" id="detalle_n'+contador+'" name="detalle_n[]" >'
	tr +='<span id="area'+contador+'"> '+areaText+'</span> </td>'
	tr +='<td> <span id="frecuencia'+contador+'">'+nivelText+'</span></td>'
	tr +='<td width="15%">'
	tr += '<button type="button" value="'+contador+'" id="eliminar'+contador+'"  class="btn btn-danger btn-mini delete_fila" style="width: 50px;float: left; margin-right:10%; height:30px; " >Eliminar</button></td>'
	tr +='</tr>';

	$("#contenedor_detalle_nivel").append(tr);
	$("#validacion_det_nivel").val('lleno'); 
	$("#validacion_det_nivel").trigger('keyup');
	$("#contador_det_nivel").val((contador + 1));
	$("#slcAreaN option:first").attr('selected', 'selected');
	$("#slcNivel").html('<option value=""></option>');	
	$("#slcAreaN, #slcNivel").select2();

}
