jQuery(document).ready(function($) {
	window.gSateliteWhite.jsSelect();

	$("#slcArticulo").select2({
        placeholder: "Buscar curso",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'registro_academico/mantenimientos/get_cursos_libres',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (curso) {
                return {
                    curso: curso
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.mod_id_art,
                        'text': item.mod_nombre
                    });
                });
                return {
                    results: myResults
                };
                
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

	$("#slcMora").select2({
        placeholder: "Buscar cargo",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'facturacion/facturar/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    producto: producto
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.codigo+' - '+item.prod_nombre
                    });
                });
                return {
                    results: myResults
                };
                
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#txtCodigo").live('blur', function(event) {
	   var codigo = $("#txtCodigo").val();
	   var id = $("#id_conf").val();
	   if(id<=0){
	   	id=null;
	   }
	   validar_codigo_modulo(codigo, id);
	});

    $("#txtDiaCargo").live('blur', function(event) {
        dia = $(this).val();
        if(dia>31){
            crear_alerta('error', 'Error', 'El día cargo no puede ser mayor que 31.');
        }
    });

    $("#txtDiaPlazo").live('blur', function(event) {
        dia = $(this).val();
        if(dia>31){
            crear_alerta('error', 'Error', 'Los días plazo no pueden ser mas de 31.');
        }
    });

	$("#slcTipoValor").change(function(event) {

		tipo_valor = $(this).val();
    	if(tipo_valor == 1) {
			$('#txt_nota_valor_porcentaje').show();
		} else {
			$('#txt_nota_valor_porcentaje').hide();
		}
    });

	$("#txtValor").live('blur', function(event) {
		valor = $(this).val();
		tipo_valor = $("#slcTipoValor").val();
		
		if(tipo_valor == 1 && valor > 100) {
			crear_alerta('error', 'Error', 'El valor no puede ser superior al 100%.');
		}

	});

    $("#defecto").change(function(event) {
    	if($("#defecto").is(":checked")){
    		wait.start();

    		id = $("#id_conf").val();
    		$.ajax({
		      dataType:'json',
		      type:'post',
		      data:{id:id},
		      url: urlj+'registro_academico/mantenimientos/validar_defecto_conf',
		      success: function(data){
                wait.close();
		        if(data>0){
		          	$("#defecto").removeAttr( "checked" );
                    $("#defecto").iButton('repaint');
			        crear_alerta('error', 'Error', 'Ya existe una configuración por defecto');
		        }
		      }           
		    });
    	}
    });
	
	$("#agregar").click(function(event){
		var mor =  $('#slcMora').select2('data');
		var art =  $('#slcArticulo').select2('data');
		var articulo = art.id;
		var textArticulo = art.text;
		var cuota = $("#txtCuota").val();
		var cargo = $("#txtDiaCargo").val();
		var plazo = $("#txtDiaPlazo").val();
		var mora = (mor != null) ? mor.id : 0;
		var textMora = (mora > 0) ? mor.text : '';
		var tipo_apl_mora = $("#slcTipoValor").val();
		var nombre_tipo_apl_mora = $("#slcTipoValor option:selected").text();
		var valor_mora = $("#txtValor").val();
		if (articulo > 0 && cuota > 0 && cargo > 0 && plazo > 0) {
		  if(cargo > 31 || plazo > 31 ){
			crear_alerta('error', 'Días', 'Los días no deben ser mayores que 31.');
			} else {
				if (tipo_apl_mora == 1 && valor_mora > 100) {
			crear_alerta('error', 'Días', 'El valor no puede ser superior al 100%.');
		  } else {
					if ($("#DH_" + articulo + "_" + cuota).length > 0) {
						crear_alerta('error','Informaci&oacute;n','Ese detalle ya ha sido agregado'); 
					} else {
				contador=parseInt($('#contador_det_configuracion').val());
						tr  ='<tr class="dato'+contador+' fila" id="DH_'+articulo+'_'+cuota+'" data-corr="'+contador+'" >';
						tr +='<td class="td-input first">';
						tr +='<input type="hidden" id="id_dfc_'+contador+'" name="id_dfc[]" value="0" />';
						tr +='<input type="hidden" id="idArticulo_'+contador+'" name="detalle_articulo[]" style="width:auto;" value="'+articulo+'"/>';
						tr +='<input type="hidden" id="txtCuota_'+contador+'" name="detalle_cuota[]" value="'+cuota+'">';
						tr +='<input type="hidden" id="txtCargo_'+contador+'" name="detalle_cargo[]" value="'+cargo+'">';
						tr +='<input type="hidden" id="txtPlazo_'+contador+'" name="detalle_plazo[]" value="'+plazo+'">';
						tr +='<input type="hidden" id="txtTipoAplMora_'+contador+'" name="detalle_tipo_apl_mora[]" value="'+tipo_apl_mora+'"/>';
						tr +='<input type="hidden" id="txtValorMora_'+contador+'" name="detalle_valor_mora[]" value="'+valor_mora+'"/>';
						tr +='<input type="hidden" id="txtMora_'+contador+'" name="detalle_mora[]" value="'+mora+'">'+textArticulo+'</td>';
						tr +='<td>'+cuota+'</td>';
						tr +='<td>'+cargo+'</td>';
						tr +='<td>'+plazo+'</td>';
						tr +='<td>'+textMora+'</td>';
						tr +='<td>'+nombre_tipo_apl_mora+'</td>';
						tr +='<td>'+valor_mora+'</td>';
						tr +='<td width="15%">';
				tr +='<button type="button" value="'+contador+'" id="eliminar'+contador+'"  class="btn btn-danger btn-mini delete_fila" style="width: 50px;float: left; margin-right:10%; height:30px; " >Eliminar</button></td>';
				tr +='</tr>';
				$("#contenedor_detalle").append(tr);
				$("#validacion_det_configuracion").val('lleno'); 
				$("#validacion_det_configuracion").trigger('keyup');
				$("#contador_det_configuracion").val((contador + 1));
						$("#txtCuota, #txtDiaCargo, #txtDiaPlazo, #txtValor").val('');
						$("#slcTipoValor").val("").select2();
				$("#slcMora").select2("val", "");
						$("#slcArticulo").select2("val", "");
				$('#txt_nota_valor_porcentaje').hide();
			}
		}
			}
	} else {
	  	crear_alerta('error', 'Error', 'Favor de verificar todos los campos requeridos');
	}
  });


  // ****************** Eliminar Producto  *********************************
    $(".delete_fila").live("click", function () {
        var parent = $(this).parent().parent();
        $("#" + parent[0].id).remove().delay(300);
    });


    $("#guardar, #guardar_volver").click(function(event) {
    	event.preventDefault();

    	var codigo = $("#txtCodigo").val();
    	var nombre = $("#txtNombre").val();
		var defecto = $("#defecto").val();
    	wait.start();
    	if(codigo!='' && nombre!=''){ // Valida campo requerido
    		$("#txtCodigo").removeClass('error');
    		$("#txtCodigo_error").text('');
    		$("#txtNombre").removeClass('error');
    		$("#txtNombre_error").text('');
    		if($("#contenedor_detalle tr").length<=0 ){ //Valida que se agreguen detalles
    			wait.close();
    			crear_alerta('error', 'Detalles', 'Debe agregar al menos un detalle de configuración.');
    		}else{
		        $("#frm_evaluacion").submit();
    		}
    	}else{
    		wait.close();
    		if(codigo==''){
	    		$("#txtCodigo").addClass('error');
	    		$("#txtCodigo_error").text('Campo requerido');
    		}

    		if(nombre==''){
	    		$("#txtNombre").addClass('error');
	    		$("#txtNombre_error").text('Campo requerido');
    		}

    		
    	
    	}
    });


});//End jQuery

function validar_codigo_modulo(codigo, id=null){
     $.ajax({
      dataType:'json',
      type:'post',
      data:{codigo:codigo,id:id},
      url: urlj+'registro_academico/mantenimientos/validar_codigo_config',
      success: function(data){
        if(data>0){
          $("#txtCodigo").val('');
          $("#txtCodigo").addClass('error');
          crear_alerta('error', 'Error', 'El código ya existe');
          return false;
        }
      }           
    });

  }
