$(document).ready(function () {
    
    $("#slc_sucursal").select2();

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
   $(".datePicker").mask("99-99-9999");
    
    
    /*Busqueda*/
   $("#btnConsultar").click(function(){
       var fecha_ini = $("#txtFechaIni").val();
       var fecha_fin = $("#txtFechaFin").val();
       
       if(fecha_ini !='' && fecha_fin != ''){
           if(!verifica_fecha(fecha_ini,fecha_fin)){
               crear_alerta('error','Proyecciones','Verifique las fechas del período.');
               return false;
           }
       }

       $("#dv_contenedor_actividad").hide('slide',{
                direction:'right'
            },
            400,function(){
                $.ajax({
                   type:'post',
                   url:window.gSateliteWhite.baseUrl('registro_academico/procesos/actividades'),
                   data:{fecha_ini:fecha_ini,fecha_fin:fecha_fin},
                   beforeSend:function(){
                       wait.start();
                   },
                   success:function(result){
                       wait.close();
                       var oTabla = $("#tblActividad").dataTable();
                       
                       oTabla.fnDestroy();
                       $("#tbContenedorActividad").html(result);
                       
                       $("#dv_contenedor_actividad").show("slide", {
			                    direction: 'left'
                        }, 500);
                       aplidarDataTable('tblActividad');
                   }
                });
            }
        );
   });
  
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#fecha_fin_error").text('');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#fecha_fin").addClass('error');
        $("#fecha_fin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
        return true;
    }
}