$(document).ready(function(){
    $("#acciones").hide();
    $("select").select2({placeholder: "Seleccione"});
    $(".dias_fecha").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
    $(".dias_fecha").mask("99-99-9999");

    // $("#slcCliente").select2({
    //     placeholder: "Buscar Cliente",
    //     minimumInputLength: 3,
    //     ajax: {
    //         url: urlj + 'proyectos/procesos/get_clientes_like',
    //         dataType: 'json',
    //         type: 'POST',
    //         delay: 250,
    //         data: function (cliente) {
    //             return {
    //                 cliente: cliente
    //             };
    //         },
    //         results: function (data) {
    //             var myResults = [];
    //             $.each(data, function (index, item) {
    //                 myResults.push({
    //                     'id': item.cliente,
    //                     'text': item.cliente_nombre
    //                 });
    //             });
    //             return {
    //                 results: myResults
    //             };
    //         }
    //     }
    // });

    $(".dias_fecha").change(function() {
        if ($("#txt_fecha_d").val() != "" && $("#txt_fecha_h").val() != "") {
            verifica_fecha($("#txt_fecha_d").val(), $("#txt_fecha_h").val());
        }
    });

    $("#btnConsultar").click(function () {
        $("#acciones").hide();
        var ordenes = $("#slcOrden").val();
        var ord_ids = ($.isArray(ordenes)) ? ordenes.toString() : "";
        var etapa = $("#slcEtapa").val();
        var f_ini = $("#txt_fecha_d").val();
        var f_fin = $("#txt_fecha_h").val();
        var valido = true;
        if (f_ini != "" && f_fin != "") {
            valido = verifica_fecha(f_ini, f_fin);
        }
        if (valido) {
            $("#dvResultado").hide('slide', {direction: 'right'}, 400, function () {
                $.ajax({
                    type: 'post',
                    dataType: 'json',
                    url: urlj + 'proyectos/reportes/rptjob_tracking/1',
                    data: {
                        orden: ord_ids,
                        etapa: etapa,
                        f_ini: f_ini,
                        f_fin: f_fin
                    },
                    beforeSend: function () {
                        wait.start();
                    },
                    success: function (data) {
                        console.log(data);
                        if (data.cantidad > 0) {
                            $("#hdn_orden").val(ord_ids);
                            $("#hdn_etapa").val(etapa);
                            $("#hdn_fecha_ini").val(f_ini);
                            $("#hdn_fecha_fin").val(f_fin);
                            $("#acciones").show();
                        }
                        var oTable = $('#tblListado').dataTable();
                        oTable.fnDestroy();           
                        $("#tbContenedorListado").html(data.filas);
                        aplidarDataTable('tblListado');
                        $("#dvResultado").show("slide", {direction: 'left'}, 500);
                        wait.close();
                    }
                });
            });
        }
    });

});

function verifica_fecha(fecha_ini, fecha_fin){
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if(Date.parse(fecha_i) > Date.parse(fecha_f)){
        crear_alerta("error", "Verifique las fechas del período.");
        return false;
    } else {
        return true;
    }
}


function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}