$(document).ready(function () {

    $("#acciones").hide();
    $('select').select2({placeholder: 'Seleccione'});
    
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $("body").on("change", "#txtFechaIni, #txtFechaFin", function(){
        if (!(verifica_fecha($('#txtFechaIni').val(), $('#txtFechaFin').val()))) {
            $('#txtFechaIni').val('');
        }
    });

    /*Busqueda*/
    $("#btnConsultar").click(function () {
        $("#acciones").hide();
        var categoria = $("#slcTipoProd").val();
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        if (fecha_ini == '' || fecha_fin == '') {
            crear_alerta('error', 'Atención', 'Ambas fechas son obligatorias.');
            return false;
        }
        if (!(verifica_fecha($('#txtFechaIni').val(), $('#txtFechaFin').val()))) {
            crear_alerta('error', 'Atención', 'Verifique el período de las fechas.');
            return false;
        }
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: urlj + 'proyectos/reportes/rpt_prod_valor/1',
            data: {
                txtFechaIni: fecha_ini, 
                txtFechaFin: fecha_fin, 
                slcTipoProd: categoria
            },
            beforeSend: function () {
                wait.start();
            },
            success: function(data) {
                console.log(data);
                // var oTable = $('#datagried').dataTable();
                // oTable.fnDestroy(); 
                $("#contenedor").html(data.filas);
                // aplicarDataTable('datagried');                
                if (data.cantidad > 0) {
                    $("#hdn_fecha_ini").val(fecha_ini);
                    $("#hdn_fecha_fin").val(fecha_fin);
                    $("#hdn_categoria").val(categoria);
                    $("#acciones").show();
                }                            
                wait.close();
            }
        });        
    });


});

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        crear_alerta('error','Fechas','Verifique las fechas del período');
        return false;
    }else{
        return true;
    }
}

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "paging":   false,
        "ordering": false,
        "info":     false,
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}