$(document).ready(function () {
    $('select option[value=0]').text('');
    $('select option[value=0]').val('');
    $('select').select2({placeholder: "Seleccione una opción"});

    $("#frm-reporte").validate({
        rules: {
            slcProveedor: {required: true},
            txtFechaIni: {required: true},
            txtFechaFin: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error', 'Campos necesarios', 'Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form) {
            if (!validarPeriodo($("#txtFechaIni").val(), $("#txtFechaFin").val())) {
                crear_alerta('error', 'Filtros', 'Verifique el período de las fechas.');
                return false;
            }
            $("#filtro_inicio").val($("#txtFechaIni").val());
            $("#filtro_fin").val($("#txtFechaFin").val());

            form.submit();
        }
    });

    $("#slcCliente").select2({
        placeholder: "Buscar Cliente",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'proyectos/procesos/get_clientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cliente,
                        'text': item.cliente_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        }
    });

    //$("#get_ordenes_cliente")
    $("#slcCliente").change(function () {
        obtenerOrdenes();
    });

    $("#slcTipoOrden").change(function () {
        obtenerOrdenes();
    });

    $("#slcOrden").change(function () {
        var orden = $(this).val();
        if (orden != '') {
            var fechaOrden = $("#slcOrden option:selected").data('fecha');
            console.log(fechaOrden);
            $("#txtFechaOrden").val(fechaOrden);
        } else {
            $("#txtFechaOrden").val('');
        }
    });

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });


    /*Busqueda*/
    $("#btnConsultar").click(function () {

        var orden = ($("#slcOrden").val() > 0) ? $("#slcOrden").val() : "";

        if (orden == '') {
            crear_alerta('error', 'Filtros', 'Debe especificar Cliente y número de Orden.');
            return false;
        }

        $("#dvResultado").hide('slide', {
            direction: 'right'
        },
                400, function () {
                    $.ajax({
                        type: 'post',
                        url: window.gSateliteWhite.baseUrl('proyectos/reportes/reporte_uso_materia_prima/1'),
                        data: {orden: orden},
                        beforeSend: function () {
                            wait.start();
                        },
                        success: function (result) {
                            wait.close();
                            $(".print").show();
                            var orden = ($("#slcOrden").val() > 0) ? $("#slcOrden").val() : "";

                            $("#filtro_orden").val(orden);

                            $("#dv_contenedor_listado").html(result.trim());

                            $("#dv_contenedor_listado table:first").css('margin', '0px auto');

                            $("#dvResultado").show("slide", {
                                direction: 'left'
                            }, 500);
                        }
                    });
                }
        );
    });
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#fecha_fin_error").text('');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#fecha_fin").addClass('error');
        $("#fecha_fin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
        return true;
    }
}

function obtenerOrdenes() {
    var cliente = $("#slcCliente").val();
    var tipo_orden = ($("#slcTipoOrden").val() > 0) ? $("#slcTipoOrden").val() : '';
    $("#slcOrden").html('<option></option>');
    $("#slcOrden").select2({placeholder: "Seleccione una opción"});
    if (cliente != '') {
        $.ajax({
            type: 'post',
            url: window.gSateliteWhite.baseUrl('proyectos/reportes/get_ordenes_cliente'),
            data: {cliente: cliente, tipo_orden: tipo_orden},
            dataType: 'json',
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                wait.close();
                $("#slcOrden").html(result.ordenes);
                $("#slcOrden").select2({placeholder: "Seleccione una opción"});
            }
        });
    }

}