$(document).ready(function () {
    gSateliteWhite.jsSelect();
    
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    /*Busqueda*/
    $("#btnConsultar").click(function () {
        var categoria = $("#slcTipoProd").val();
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        $("#acciones").hide();
        if (fecha_ini == '' || fecha_fin == '') {
            crear_alerta('error', 'Reporte Productos Fabricados', 'Fechas son obligatorias.');
            return false;
        }
        if (!validarPeriodo(fecha_ini, fecha_fin)) {
                crear_alerta('error', 'Reporte Productos Fabricados', 'Verifique el período de las fechas.');
                return false;
        }
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.gSateliteWhite.baseUrl('proyectos/reportes/detalle_reporte_prod_fabricados'),
            data: {
                txtFechaIni: fecha_ini, 
                txtFechaFin: fecha_fin, 
                slcTipoProd: categoria
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                $("#datagried").dataTable().fnDestroy();
                $("#contenedor").html(result.tabla);
                aplicarDataTable('datagried');
                if (result.filas > 0) {
                    $("#fecha_ini").val(fecha_ini);
                    $("#fecha_fin").val(fecha_fin);
                    $("#cat_prodc").val(categoria);
                    $("#acciones").show();
                }
                wait.close();
            }
        });
    });

});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}